/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.network;

import net.blay09.mods.inventoryessentials.ServerInventoryTransfers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class SingleTransferMessage {
    private final int slotNumber;

    public SingleTransferMessage(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public static SingleTransferMessage decode(FriendlyByteBuf buf) {
        byte slotNumber = buf.readByte();
        return new SingleTransferMessage(slotNumber);
    }

    public static void encode(SingleTransferMessage message, FriendlyByteBuf buf) {
        buf.writeByte(message.slotNumber);
    }

    public static void handle(ServerPlayer player, SingleTransferMessage message) {
        AbstractContainerMenu menu = player.f_36096_;
        if (menu != null && message.slotNumber >= 0 && message.slotNumber < menu.f_38839_.size()) {
            Slot slot = (Slot)menu.f_38839_.get(message.slotNumber);
            ServerInventoryTransfers.singleTransfer(player, menu, slot);
        }
    }
}

