/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.snad.blocks;

import com.robrit.snad.blocks.SuolSnadBlock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SnadBlock
extends FallingBlock {
    private final int dustColor;

    public SnadBlock(int dustColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.dustColor = dustColor;
    }

    @ParametersAreNonnullByDefault
    public int m_6248_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.dustColor;
    }

    @ParametersAreNonnullByDefault
    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        if (plantable.getPlantType(world, pos) == PlantType.DESERT) {
            return true;
        }
        if (plantable.getPlantType(world, pos) == PlantType.BEACH) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                boolean isWater = world.m_6425_(pos.m_121945_(direction)).m_205070_(FluidTags.f_13131_);
                boolean isFrostedIce = world.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_50449_);
                if (!isWater && !isFrostedIce) continue;
                return true;
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        this.m_213897_(blockState, serverLevel, blockPos, random);
    }

    @ParametersAreNonnullByDefault
    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        SuolSnadBlock.acceleratedTick(serverLevel, blockPos, random);
    }
}

