/*
 * Decompiled with CFR 0.152.
 */
package tfar.functionalarmortrim.config;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.functionalarmortrim.TrimEffects;
import tfar.functionalarmortrim.init.ModAttributes;
import tfar.functionalarmortrim.network.PacketHandler;
import tfar.functionalarmortrim.network.client.S2CConfigPacket;

public class ConfigHandler {
    static final File file = new File("config/functionalarmortrim.json");
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Map<Item, Map<Attribute, Map<EquipmentSlot, AttributeModifier>>> MAP = new HashMap<Item, Map<Attribute, Map<EquipmentSlot, AttributeModifier>>>();

    static JsonObject createDefault() {
        JsonObject root = new JsonObject();
        JsonArray ironModifiers = new JsonArray();
        ConfigHandler.addMod(ironModifiers, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, 2.0);
        ConfigHandler.addTrim(root, Items.f_42416_, ironModifiers);
        JsonArray diamondModifiers = new JsonArray();
        ConfigHandler.addMod(diamondModifiers, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, 2.0);
        ConfigHandler.addMod(diamondModifiers, Attributes.f_22285_, AttributeModifier.Operation.ADDITION, 2.0);
        ConfigHandler.addTrim(root, Items.f_42415_, diamondModifiers);
        JsonArray netheriteModifiers = new JsonArray();
        ConfigHandler.addMod(netheriteModifiers, Attributes.f_22284_, AttributeModifier.Operation.ADDITION, 2.0);
        ConfigHandler.addMod(netheriteModifiers, Attributes.f_22285_, AttributeModifier.Operation.ADDITION, 2.0);
        ConfigHandler.addMod(netheriteModifiers, ModAttributes.FIRE_RESISTANCE, AttributeModifier.Operation.ADDITION, 0.25);
        ConfigHandler.addTrim(root, Items.f_42418_, netheriteModifiers);
        JsonArray redstoneModifiers = new JsonArray();
        ConfigHandler.addMod(redstoneModifiers, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1);
        ConfigHandler.addMod(redstoneModifiers, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), AttributeModifier.Operation.ADDITION, 1.0);
        ConfigHandler.addTrim(root, Items.f_42451_, redstoneModifiers);
        JsonArray copperModifiers = new JsonArray();
        ConfigHandler.addMod(copperModifiers, (Attribute)ForgeMod.SWIM_SPEED.get(), AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1);
        ConfigHandler.addTrim(root, Items.f_151052_, copperModifiers);
        JsonArray amethystModifiers = new JsonArray();
        ConfigHandler.addMod(amethystModifiers, ModAttributes.NIGHT_VISION, AttributeModifier.Operation.ADDITION, 0.25);
        ConfigHandler.addTrim(root, Items.f_151049_, amethystModifiers);
        JsonArray lapisModifiers = new JsonArray();
        ConfigHandler.addMod(lapisModifiers, ModAttributes.EXPERIENCE_BOOST, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1);
        ConfigHandler.addTrim(root, Items.f_42534_, lapisModifiers);
        JsonArray quartzModifiers = new JsonArray();
        ConfigHandler.addMod(quartzModifiers, ModAttributes.THORNS, AttributeModifier.Operation.ADDITION, 1.0);
        ConfigHandler.addTrim(root, Items.f_42692_, quartzModifiers);
        JsonArray emeraldModifiers = new JsonArray();
        ConfigHandler.addMod(emeraldModifiers, ModAttributes.GOSSIP_BOOST, AttributeModifier.Operation.MULTIPLY_TOTAL, 0.1);
        ConfigHandler.addTrim(root, Items.f_42616_, emeraldModifiers);
        return root;
    }

    static void addTrim(JsonObject root, Item item, JsonArray mods) {
        root.add(ConfigHandler.getName(item), (JsonElement)mods);
    }

    static void addMod(JsonArray array, Attribute attribute, AttributeModifier.Operation operation, double amount) {
        JsonObject object = new JsonObject();
        object.addProperty("attribute", ConfigHandler.getName(attribute));
        object.addProperty("operation", operation.name().toLowerCase(Locale.ROOT));
        object.addProperty("amount", (Number)amount);
        array.add((JsonElement)object);
    }

    public static JsonObject read(Gson gson) {
        JsonObject jsonObject;
        ConfigHandler.writeIfEmpty();
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            JsonReader jsonReader = new JsonReader((Reader)reader);
            LOGGER.info("Loading existing config");
            jsonObject = (JsonObject)gson.fromJson(jsonReader, JsonObject.class);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return jsonObject;
    }

    public static void load(JsonObject jsonObject) {
        MAP.clear();
        for (Map.Entry entry : jsonObject.asMap().entrySet()) {
            String key = (String)entry.getKey();
            ResourceLocation location = new ResourceLocation(key);
            if (!BuiltInRegistries.f_257033_.m_7804_(location)) {
                LOGGER.info("Skipping unregistered item {}", (Object)key);
                continue;
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(location);
            JsonArray mods = ((JsonElement)entry.getValue()).getAsJsonArray();
            HashMap attributeMapMap = new HashMap();
            for (JsonElement element : mods) {
                JsonObject obj = element.getAsJsonObject();
                Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(obj.get("attribute").getAsString()));
                AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)obj.get("operation").getAsString().toUpperCase(Locale.ROOT));
                double amount = obj.get("amount").getAsDouble();
                HashMap<EquipmentSlot, AttributeModifier> attributeModifierMap = new HashMap<EquipmentSlot, AttributeModifier>();
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (!slot.m_254934_()) continue;
                    UUID uuid = TrimEffects.trim_slot_uuids[slot.m_20749_()];
                    AttributeModifier modifier = new AttributeModifier(uuid, "Armor Trim Boost", amount, operation);
                    attributeModifierMap.put(slot, modifier);
                }
                attributeMapMap.put(attribute, attributeModifierMap);
            }
            MAP.put(item, attributeMapMap);
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.m_6846_().m_11314_().forEach(player -> PacketHandler.sendToClient(new S2CConfigPacket(MAP), player));
        }
    }

    public static void writeIfEmpty() {
        if (!file.exists()) {
            ConfigHandler.write(file);
        }
    }

    public static void write(File file) {
        Gson gson = new Gson();
        JsonWriter writer = null;
        try {
            writer = gson.newJsonWriter((Writer)new FileWriter(file));
            writer.setIndent("    ");
            gson.toJson((JsonElement)ConfigHandler.createDefault(), writer);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Couldn't save config");
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static String getName(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
    }

    public static Item getItem(String s) {
        return (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s));
    }

    public static String getName(Attribute attribute) {
        return BuiltInRegistries.f_256951_.m_7981_((Object)attribute).toString();
    }

    public static Attribute getAttribute(String s) {
        return (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(s));
    }
}

