/*
 * Decompiled with CFR 0.152.
 */
package tfar.functionalarmortrim;

import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import tfar.functionalarmortrim.Client;
import tfar.functionalarmortrim.client.ModClient;
import tfar.functionalarmortrim.config.ConfigHandler;
import tfar.functionalarmortrim.init.ModAttributes;

public class TrimEffects {
    public static final UUID[] trim_slot_uuids = new UUID[]{UUID.fromString("81a9ed67-25f2-40f5-9a14-5607bd76b506"), UUID.fromString("71dcc566-b25a-4f1a-b564-c9a8aa9e784f"), UUID.fromString("0a2787e9-a297-4ac9-9935-bed6f145e00c"), UUID.fromString("eb4dbe61-f520-44fe-81ee-7754188eb320")};

    public static void attributes(ItemAttributeModifierEvent e) {
        ArmorItem armorItem;
        ItemStack stack = e.getItemStack();
        Item item = stack.m_41720_();
        EquipmentSlot slot = e.getSlotType();
        if (item instanceof ArmorItem && slot == (armorItem = (ArmorItem)item).m_40402_()) {
            Level level = TrimEffects.getWorld();
            Item trim = TrimEffects.getTrimItem(level, stack);
            Map<Item, Map<Attribute, Map<EquipmentSlot, AttributeModifier>>> map = ConfigHandler.MAP;
            if (level.f_46443_) {
                map = ModClient.MAP;
            }
            map.getOrDefault(trim, Map.of()).forEach((attribute, attributeModifiers) -> e.addModifier(attribute, (AttributeModifier)attributeModifiers.get(slot)));
        }
    }

    public static Level getWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return Client.getClientWorld();
        }
        return server.m_129880_(Level.f_46428_);
    }

    public static void fireResist(LivingAttackEvent e) {
        double fire_resistance;
        DamageSource source = e.getSource();
        if (source.m_269533_(DamageTypeTags.f_268745_) && (fire_resistance = e.getEntity().m_21133_(ModAttributes.FIRE_RESISTANCE)) >= 1.0) {
            e.setCanceled(true);
        }
    }

    public static void fireDamage(LivingHurtEvent e) {
        DamageSource source = e.getSource();
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            double fire_resistance = e.getEntity().m_21133_(ModAttributes.FIRE_RESISTANCE);
            e.setAmount((float)((double)e.getAmount() * (1.0 - fire_resistance)));
        }
    }

    public static void breakBlock(BlockEvent.BreakEvent e) {
        Player player = e.getPlayer();
        if (player != null) {
            double experience_boost = player.m_21133_(ModAttributes.EXPERIENCE_BOOST);
            e.setExpToDrop((int)((double)e.getExpToDrop() * experience_boost));
        }
    }

    public static void livingXp(LivingExperienceDropEvent e) {
        Player player = e.getAttackingPlayer();
        if (player != null) {
            double experience_boost = player.m_21133_(ModAttributes.EXPERIENCE_BOOST);
            e.setDroppedExperience((int)((double)e.getDroppedExperience() * experience_boost));
        }
    }

    public static void livinghurt(LivingDamageEvent e) {
        double quartz;
        DamageSource source = e.getSource();
        LivingEntity living = e.getEntity();
        Entity attacker = source.m_7640_();
        if (attacker instanceof LivingEntity && (quartz = living.m_21133_(ModAttributes.THORNS)) > 0.0) {
            attacker.m_6469_(living.m_269291_().m_269374_((Entity)living), (float)quartz);
        }
    }

    @Nullable
    public static ArmorTrim getTrim(@Nullable Level level, ItemStack stack) {
        return level == null ? null : (ArmorTrim)ArmorTrim.m_266285_((RegistryAccess)level.m_9598_(), (ItemStack)stack).orElse(null);
    }

    @Nullable
    public static TrimMaterial getTrimMaterial(@Nullable Level level, ItemStack stack) {
        ArmorTrim armorTrim = TrimEffects.getTrim(level, stack);
        return armorTrim == null ? null : (TrimMaterial)armorTrim.m_266210_().get();
    }

    @Nullable
    public static Item getTrimItem(@Nullable Level level, ItemStack stack) {
        TrimMaterial trimMaterial = TrimEffects.getTrimMaterial(level, stack);
        return trimMaterial == null ? null : (Item)trimMaterial.f_265970_().get();
    }
}

