/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime.mixin;

import commonnetwork.api.Dispatcher;
import einstein.usefulslime.UsefulSlime;
import einstein.usefulslime.init.ModCommonConfigs;
import einstein.usefulslime.init.ModItems;
import einstein.usefulslime.networking.serverbound.ServerBoundHangClimbPacket;
import einstein.usefulslime.networking.serverbound.ServerBoundWallClimbPacket;
import einstein.usefulslime.util.ClimbingEntity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class ClimbingPlayerMixin
extends LivingEntity {
    @Unique
    private final ClimbingEntity usefulSlime$climbingEntity = (ClimbingEntity)((Object)this);
    @Unique
    private int usefulSlime$distanceWallClimbed = 0;
    @Unique
    private int usefulSlime$distanceHangClimbed = 0;

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    protected ClimbingPlayerMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="TAIL")})
    private void checkMovementStatistics(double distanceX, double distanceY, double distanceZ, CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && !this.m_20159_() && this.m_6147_()) {
            if (this.usefulSlime$climbingEntity.usefulSlime$canWallClimb() && ((Boolean)ModCommonConfigs.INSTANCE.wallClimbingDamagesSlimeChestplateAndLeggings.get()).booleanValue() && distanceY > 0.0) {
                ++this.usefulSlime$distanceWallClimbed;
                if (this.usefulSlime$distanceWallClimbed >= 100) {
                    this.usefulSlime$distanceWallClimbed = 0;
                    UsefulSlime.damageEquipment(this, EquipmentSlot.CHEST);
                    UsefulSlime.damageEquipment(this, EquipmentSlot.LEGS);
                }
            }
            if (this.usefulSlime$climbingEntity.usefulSlime$canHangClimb() && ((Boolean)ModCommonConfigs.INSTANCE.hangClimbingDamagesSlimeHelmet.get()).booleanValue() && Math.sqrt(distanceX * distanceX + distanceZ * distanceZ) > 0.0) {
                ++this.usefulSlime$distanceHangClimbed;
                if (this.usefulSlime$distanceHangClimbed >= 50) {
                    this.usefulSlime$distanceHangClimbed = 0;
                    UsefulSlime.damageEquipment(this, EquipmentSlot.HEAD);
                }
            }
        }
    }

    public boolean m_6147_() {
        if (this.m_9236_().f_46443_) {
            boolean canHangClimb = this.m_6844_(EquipmentSlot.HEAD).m_150930_(ModItems.SLIME_HELMET.get()) && this.usefulSlime$climbingEntity.usefulSlime$verticalCollisionAbove() && this.f_20899_;
            boolean canWallClimb = this.m_6844_(EquipmentSlot.LEGS).m_150930_(ModItems.SLIME_LEGGINGS.get()) && this.m_6844_(EquipmentSlot.CHEST).m_150930_(ModItems.SLIME_CHESTPLATE.get()) && this.f_19862_ && !super.m_6147_();
            this.usefulSlime$climbingEntity.usefulSlime$setHangClimbing(canHangClimb);
            Dispatcher.sendToServer((Object)new ServerBoundHangClimbPacket(canHangClimb));
            this.m_20242_(canHangClimb);
            this.usefulSlime$climbingEntity.usefulSlime$setWallClimbing(canWallClimb);
            Dispatcher.sendToServer((Object)new ServerBoundWallClimbPacket(canWallClimb));
        }
        return super.m_6147_() || this.usefulSlime$climbingEntity.usefulSlime$canWallClimb() || this.usefulSlime$climbingEntity.usefulSlime$canHangClimb();
    }
}

