/*
 * Decompiled with CFR 0.152.
 */
package einstein.usefulslime;

import einstein.usefulslime.UsefulSlime;
import einstein.usefulslime.init.ModCommonConfigs;
import einstein.usefulslime.init.ModItems;
import einstein.usefulslime.platform.ForgeRegistryHelper;
import einstein.usefulslime.util.BounceHandler;
import einstein.usefulslime.util.LivingFallData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod(value="usefulslime")
public class UsefulSlimeForge {
    public UsefulSlimeForge() {
        UsefulSlime.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onBuildContents);
        modEventBus.addListener(this::clientSetup);
        ForgeRegistryHelper.ITEMS.register(modEventBus);
        ForgeRegistryHelper.BLOCKS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onFall);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerFlyFall);
        MinecraftForge.EVENT_BUS.addListener(this::missingMappings);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModCommonConfigs.SPEC);
    }

    void clientSetup(FMLClientSetupEvent event) {
        UsefulSlime.clientSetup();
    }

    void onFall(LivingFallEvent event) {
        LivingFallData data = new LivingFallData(event.getEntity(), event.getDistance(), event.getDamageMultiplier());
        UsefulSlime.onFall(data);
        event.setDamageMultiplier(data.getDamageMultiplier());
        event.setDistance(data.getDistance());
        if (data.isCanceled()) {
            event.setCanceled(true);
        }
    }

    void onPlayerFlyFall(PlayerFlyableFallEvent event) {
        LivingFallData data = new LivingFallData((LivingEntity)event.getEntity(), event.getDistance(), 0.0f);
        UsefulSlime.onFall(data);
        event.setDistance(data.getDistance());
    }

    void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && BounceHandler.BOUNCING_ENTITIES.containsKey(player = event.player)) {
            BounceHandler.BOUNCING_ENTITIES.get(player).onPlayerTick(player);
        }
    }

    void onBuildContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tab = event.getTabKey();
        MutableHashedLinkedMap entries = event.getEntries();
        if (tab == CreativeModeTabs.f_256869_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_151059_), (Object)new ItemStack((ItemLike)ModItems.SLIME_SLING.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (tab == CreativeModeTabs.f_256791_) {
            event.accept(ModItems.SLIPPERY_SLIME_BLOCK_ITEM);
        } else if (tab == CreativeModeTabs.f_256797_) {
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42354_), (Object)new ItemStack((ItemLike)ModItems.SLIME_HELMET.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.SLIME_HELMET.get()), (Object)new ItemStack((ItemLike)ModItems.SLIME_CHESTPLATE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.SLIME_CHESTPLATE.get()), (Object)new ItemStack((ItemLike)ModItems.SLIME_LEGGINGS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.SLIME_LEGGINGS.get()), (Object)new ItemStack((ItemLike)ModItems.SLIME_BOOTS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (tab == CreativeModeTabs.f_256839_) {
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42400_), (Object)new ItemStack((ItemLike)ModItems.JELLO.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    void missingMappings(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getMappings(ForgeRegistries.ITEMS.getRegistryKey(), "usefulslime")) {
            if (!mapping.getKey().m_135815_().equals("slimesling")) continue;
            mapping.remap((Object)ModItems.SLIME_SLING.get());
        }
    }
}

