/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen.provider;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.regions_unexplored.RegionsUnexploredMod;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.worldgen.biome.RuBiomes;
import net.regions_unexplored.entity.RuEntities;
import org.jetbrains.annotations.NotNull;

public class RuLanguageProvider
extends LanguageProvider {
    public RuLanguageProvider(PackOutput output) {
        super(output, "regions_unexplored", "en_us");
    }

    protected void addTranslations() {
        this.add("advancements.regions_unexplored.title", "Regions Unexplored");
        this.add("advancements.regions_unexplored.description", "Discover the many biomes and explore the world!");
        this.add("advancements.regions_unexplored.pioneer.title", "Pioneer");
        this.add("advancements.regions_unexplored.pioneer.description", "Explore all Surface biomes from Regions Unexplored!");
        this.add("advancements.regions_unexplored.regions_explored.title", "Regions Explored");
        this.add("advancements.regions_unexplored.regions_explored.description", "You've explored all the biomes from Regions Unexplored");
        this.add("advancements.regions_unexplored.every_bit_of_the_rainbow.title", "Every Bit of the Rainbow");
        this.add("advancements.regions_unexplored.every_bit_of_the_rainbow.description", "Collect or craft every colour of the Snowbelle Flower.");
        this.add("advancements.regions_unexplored.from_the_tree_tops.title", "From the Tree Tops");
        this.add("advancements.regions_unexplored.from_the_tree_tops.description", "Hang from a Kapok tree's vines.");
        this.add("advancements.regions_unexplored.light_as_a_frog.title", "Light as a Frog");
        this.add("advancements.regions_unexplored.light_as_a_frog.description", "Walk or bounce on a Giant Lily Pad.");
        this.add("advancements.regions_unexplored.eternal_expedition.title", "Eternal Expedition");
        this.add("advancements.regions_unexplored.eternal_expedition.description", "Venture into all Nether biomes from Regions Unexplored!");
        this.add("advancements.regions_unexplored.downer.title", "Downer");
        this.add("advancements.regions_unexplored.downer.description", "Walk through and take damage from a Dorcel Flower.");
        this.add("advancements.regions_unexplored.light_snack.title", "Light Snack");
        this.add("advancements.regions_unexplored.light_snack.description", "Consume a Hanging Earlight Fruit.");
        this.add("advancements.regions_unexplored.spelunker.title", "Spelunker");
        this.add("advancements.regions_unexplored.spelunker.description", "Find all Cave biomes from Regions Unexplored!");
        this.add("advancements.regions_unexplored.blind_as_a_bat.title", "Blind as a Bat");
        this.add("advancements.regions_unexplored.blind_as_a_bat.description", "Consume a Duskmelon.");
        this.add("advancements.regions_unexplored.this_tree_bleeds_red.title", "This Tree Bleeds Red");
        this.add("advancements.regions_unexplored.this_tree_bleeds_red.description", "Chop down a Socotra tree.");
        this.add("advancements.regions_unexplored.got_wood.title", "Got Wood?");
        this.add("advancements.regions_unexplored.got_wood.description", "Collect every log from Regions Unexplored.");
        this.add("advancements.regions_unexplored.mycologist.title", "Mycologist");
        this.add("advancements.regions_unexplored.mycologist.description", "Collect every Bioshroom type.");
        this.add("advancements.regions_unexplored.ancient_specimens.title", "Ancient Specimens");
        this.add("advancements.regions_unexplored.ancient_specimens.description", "Collect every Bioshroom Stem type.");
        RegionsUnexploredMod.BLOCK_REGISTRY.getEntries().forEach(blockRegistryObject -> {
            if (!(((Block)blockRegistryObject.get()).toString().contains("potted_") || ((Block)blockRegistryObject.get()).toString().contains("hanging_earlight") || ((Block)blockRegistryObject.get()).toString().contains("duskmelon") || ((Block)blockRegistryObject.get()).toString().contains("salmonberry") || ((Block)blockRegistryObject.get()).toString().contains("_wall_sign") || ((Block)blockRegistryObject.get()).toString().contains("_wall_hanging_sign"))) {
                this.add((Block)blockRegistryObject.get(), RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBlockLang((Block)blockRegistryObject.get())));
            }
        });
        this.add((Block)RuBlocks.DUSKMELON.get(), "Duskmelon Slice");
        this.add((Block)RuBlocks.SALMONBERRY_BUSH.get(), "Salmonberry");
        this.add((Block)RuBlocks.HANGING_EARLIGHT.get(), "Hanging Earlight Fruit");
        this.add((EntityType)RuEntities.BOAT.get(), "Boat");
        this.add((EntityType)RuEntities.CHEST_BOAT.get(), "Boat With Chest");
        this.add("death.attack.dorcel", "%s was dragged underground by Dorcel");
        this.add("death.attack.dorcel.player", "%s was dragged underground by Dorcel");
        this.add("death.attack.dusk_trap", "%s was eaten by a Dusktrap");
        this.add("death.attack.dusk_trap.player", "%s was eaten by a Dusktrap");
        RegionsUnexploredMod.ITEM_REGISTRY.getEntries().forEach(itemRegistryObject -> {
            if (((Item)itemRegistryObject.get()).toString().contains("boat")) {
                if (((Item)itemRegistryObject.get()).toString().contains("chest_boat")) {
                    this.add((Item)itemRegistryObject.get(), RuLanguageProvider.filterChestBoatLang((ItemLike)itemRegistryObject.get()));
                } else {
                    this.add((Item)itemRegistryObject.get(), RuLanguageProvider.capitalizeString(RuLanguageProvider.filterItemLang((ItemLike)itemRegistryObject.get())));
                }
            }
        });
        this.add(RuBiomes.ALPHA_GROVE, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.ALPHA_GROVE)));
        this.add(RuBiomes.ANCIENT_DELTA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.ANCIENT_DELTA)));
        this.add(RuBiomes.ARID_MOUNTAINS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.ARID_MOUNTAINS)));
        this.add(RuBiomes.ASHEN_WOODLAND, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.ASHEN_WOODLAND)));
        this.add(RuBiomes.AUTUMNAL_MAPLE_FOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.AUTUMNAL_MAPLE_FOREST)));
        this.add(RuBiomes.BAOBAB_SAVANNA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.BAOBAB_SAVANNA)));
        this.add(RuBiomes.BAMBOO_FOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.BAMBOO_FOREST)));
        this.add(RuBiomes.BARLEY_FIELDS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.BARLEY_FIELDS)));
        this.add(RuBiomes.BAYOU, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.BAYOU)));
        this.add(RuBiomes.BIOSHROOM_CAVES, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.BIOSHROOM_CAVES)));
        this.add(RuBiomes.BLACKSTONE_BASIN, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.BLACKSTONE_BASIN)));
        this.add(RuBiomes.BLACKWOOD_TAIGA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.BLACKWOOD_TAIGA)));
        this.add(RuBiomes.BOREAL_TAIGA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.BOREAL_TAIGA)));
        this.add(RuBiomes.CHALK_CLIFFS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.CHALK_CLIFFS)));
        this.add(RuBiomes.COLD_BOREAL_TAIGA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.COLD_BOREAL_TAIGA)));
        this.add(RuBiomes.COLD_DECIDUOUS_FOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.COLD_DECIDUOUS_FOREST)));
        this.add(RuBiomes.COLD_RIVER, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.COLD_RIVER)));
        this.add(RuBiomes.DECIDUOUS_FOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.DECIDUOUS_FOREST)));
        this.add(RuBiomes.DRY_BUSHLAND, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.DRY_BUSHLAND)));
        this.add(RuBiomes.EUCALYPTUS_FOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.EUCALYPTUS_FOREST)));
        this.add(RuBiomes.FEN, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.FEN)));
        this.add(RuBiomes.FLOWER_FIELDS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.FLOWER_FIELDS)));
        this.add(RuBiomes.FROZEN_PINE_TAIGA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.FROZEN_PINE_TAIGA)));
        this.add(RuBiomes.FROZEN_TUNDRA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.FROZEN_TUNDRA)));
        this.add(RuBiomes.FUNGAL_FEN, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.FUNGAL_FEN)));
        this.add(RuBiomes.GLISTERING_MEADOW, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.GLISTERING_MEADOW)));
        this.add(RuBiomes.GOLDEN_BOREAL_TAIGA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.GOLDEN_BOREAL_TAIGA)));
        this.add(RuBiomes.GRASSLAND, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.GRASSLAND)));
        this.add(RuBiomes.GRASSY_BEACH, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.GRASSY_BEACH)));
        this.add(RuBiomes.GRAVEL_BEACH, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.GRAVEL_BEACH)));
        this.add(RuBiomes.HIGHLAND_FIELDS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.HIGHLAND_FIELDS)));
        this.add(RuBiomes.HYACINTH_DEEPS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.HYACINTH_DEEPS)));
        this.add(RuBiomes.ICY_HEIGHTS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.ICY_HEIGHTS)));
        this.add(RuBiomes.INFERNAL_HOLT, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.INFERNAL_HOLT)));
        this.add(RuBiomes.JOSHUA_DESERT, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.JOSHUA_DESERT)));
        this.add(RuBiomes.MAGNOLIA_WOODLAND, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.MAGNOLIA_WOODLAND)));
        this.add(RuBiomes.MARSH, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.MARSH)));
        this.add(RuBiomes.MAPLE_FOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.MAPLE_FOREST)));
        this.add(RuBiomes.MOUNTAINS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.MOUNTAINS)));
        this.add(RuBiomes.MAUVE_HILLS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.MAUVE_HILLS)));
        this.add(RuBiomes.MUDDY_RIVER, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.MUDDY_RIVER)));
        this.add(RuBiomes.MYCOTOXIC_UNDERGROWTH, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.MYCOTOXIC_UNDERGROWTH)));
        this.add(RuBiomes.ORCHARD, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.ORCHARD)));
        this.add(RuBiomes.OUTBACK, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.OUTBACK)));
        this.add(RuBiomes.OLD_GROWTH_BAYOU, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.OLD_GROWTH_BAYOU)));
        this.add(RuBiomes.PINE_SLOPES, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.PINE_SLOPES)));
        this.add(RuBiomes.PINE_TAIGA, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.PINE_TAIGA)));
        this.add(RuBiomes.PRAIRIE, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.PRAIRIE)));
        this.add(RuBiomes.PRISMACHASM, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.PRISMACHASM)));
        this.add(RuBiomes.POPPY_FIELDS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.POPPY_FIELDS)));
        this.add(RuBiomes.PUMPKIN_FIELDS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.PUMPKIN_FIELDS)));
        this.add(RuBiomes.RAINFOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.RAINFOREST)));
        this.add(RuBiomes.REDWOODS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.REDWOODS)));
        this.add(RuBiomes.REDSTONE_ABYSS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.REDSTONE_ABYSS)));
        this.add(RuBiomes.REDSTONE_CAVES, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.REDSTONE_CAVES)));
        this.add(RuBiomes.ROCKY_MEADOW, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.ROCKY_MEADOW)));
        this.add(RuBiomes.ROCKY_REEF, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.ROCKY_REEF)));
        this.add(RuBiomes.SAGUARO_DESERT, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.SAGUARO_DESERT)));
        this.add(RuBiomes.SHRUBLAND, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.SHRUBLAND)));
        this.add(RuBiomes.SCORCHING_CAVES, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.SCORCHING_CAVES)));
        this.add(RuBiomes.SPIRES, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.SPIRES)));
        this.add(RuBiomes.STEPPE, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.STEPPE)));
        this.add(RuBiomes.SILVER_BIRCH_FOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.SILVER_BIRCH_FOREST)));
        this.add(RuBiomes.SPARSE_RAINFOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.SPARSE_RAINFOREST)));
        this.add(RuBiomes.SPARSE_REDWOODS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.SPARSE_REDWOODS)));
        this.add(RuBiomes.TEMPERATE_GROVE, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.TEMPERATE_GROVE)));
        this.add(RuBiomes.TROPICS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.TROPICS)));
        this.add(RuBiomes.TROPICAL_RIVER, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.TROPICAL_RIVER)));
        this.add(RuBiomes.TOWERING_CLIFFS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.TOWERING_CLIFFS)));
        this.add(RuBiomes.WILLOW_FOREST, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.WILLOW_FOREST)));
        this.add(RuBiomes.CLOVER_PLAINS, RuLanguageProvider.capitalizeString(RuLanguageProvider.filterBiomeLang(RuBiomes.CLOVER_PLAINS)));
        this.add("itemGroup.regions_unexplored_main", "Regions Unexplored");
    }

    @NotNull
    private static String capitalizeString(String string) {
        char[] chars = string.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '.' && chars[i] != '_') continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    @NotNull
    private static String filterBlockLang(@NotNull Block key) {
        return key.m_7705_().replace("block.regions_unexplored.", "").replace("_plant", "").replace("_", " ");
    }

    @NotNull
    private static String filterItemLang(@NotNull ItemLike key) {
        return key.m_5456_().m_5524_().replace("item.regions_unexplored.", "").replace("_", " ");
    }

    @NotNull
    private static String filterChestBoatLang(@NotNull ItemLike key) {
        String type = key.m_5456_().m_5524_().replace("item.regions_unexplored.", "").replace("chest_boat", "").replace("_", "");
        String name = RuLanguageProvider.capitalizeString(type) + " Boat with Chest";
        return name;
    }

    private static String filterBiomeLang(ResourceKey<Biome> key) {
        return key.m_135782_().m_214298_().replace("regions_unexplored.", "").replace("_", " ");
    }

    private void add(ResourceKey<Biome> key, String translation) {
        this.add("biome." + key.m_135782_().m_214298_(), translation);
    }
}

