/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.supermartijn642.wormhole.portal.ITargetCellEntity;
import com.supermartijn642.wormhole.portal.PortalGroupBlockEntity;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TargetCellBlockEntity
extends PortalGroupBlockEntity
implements ITargetCellEntity {
    public final TargetCellType f_58855_;
    private final List<PortalTarget> targets = new ArrayList<PortalTarget>();
    private int ticks = 20;

    public TargetCellBlockEntity(TargetCellType type, BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)type.getBlockEntityType(), pos, state);
        this.f_58855_ = type;
        for (int i = 0; i < type.getCapacity(); ++i) {
            this.targets.add(null);
        }
    }

    @Override
    public void update() {
        super.update();
        ++this.ticks;
        if (this.ticks >= 20) {
            int targetCount = Math.min(this.getNonNullTargetCount(), this.f_58855_.getVisualCapacity());
            if ((Integer)this.m_58900_().m_61143_((Property)TargetCellBlock.VISUAL_TARGETS) != targetCount) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TargetCellBlock.VISUAL_TARGETS, (Comparable)Integer.valueOf(targetCount)));
                this.ticks = 0;
            }
        }
    }

    @Override
    public int getTargetCapacity() {
        return this.f_58855_.getCapacity();
    }

    @Override
    public PortalTarget getTarget(int index) {
        return this.targets.get(index);
    }

    @Override
    public void setTarget(int index, PortalTarget target) {
        this.targets.set(index, target);
        this.dataChanged();
    }

    @Override
    public List<PortalTarget> getTargets() {
        return this.targets;
    }

    @Override
    public int getNonNullTargetCount() {
        int count = 0;
        for (PortalTarget target : this.targets) {
            if (target == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag tag = super.writeData();
        CompoundTag targetsTag = new CompoundTag();
        int count = 0;
        for (int i = 0; i < this.targets.size(); ++i) {
            targetsTag.m_128379_("has" + i, this.targets.get(i) != null);
            if (this.targets.get(i) == null) continue;
            targetsTag.m_128365_("target" + i, (Tag)this.targets.get(i).write());
            count = i + 1;
        }
        tag.m_128405_("targetCount", count);
        tag.m_128365_("targets", (Tag)targetsTag);
        return tag;
    }

    @Override
    protected void readData(CompoundTag tag) {
        super.readData(tag);
        this.targets.clear();
        int count = tag.m_128441_("targetCount") ? tag.m_128451_("targetCount") : 0;
        CompoundTag targetsTag = tag.m_128469_("targets");
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            if (i < count && targetsTag.m_128441_("has" + i) && targetsTag.m_128471_("has" + i) && targetsTag.m_128441_("target" + i)) {
                this.targets.add(new PortalTarget(targetsTag.m_128469_("target" + i)));
                continue;
            }
            this.targets.add(null);
        }
    }

    public static class AdvancedTargetCellBlockEntity
    extends TargetCellBlockEntity {
        public AdvancedTargetCellBlockEntity(BlockPos pos, BlockState state) {
            super(TargetCellType.ADVANCED, pos, state);
        }
    }

    public static class BasicTargetCellBlockEntity
    extends TargetCellBlockEntity {
        public BasicTargetCellBlockEntity(BlockPos pos, BlockState state) {
            super(TargetCellType.BASIC, pos, state);
        }
    }
}

