/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TargetCellBlock
extends PortalGroupBlock {
    public static final IntegerProperty VISUAL_TARGETS;
    private final TargetCellType type;

    public TargetCellBlock(TargetCellType type) {
        super(type::getBlockEntityType);
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)VISUAL_TARGETS, (Comparable)Integer.valueOf(0)));
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"wormhole.target_cell.info").color(ChatFormatting.AQUA).get());
        CompoundTag tag = stack.m_41782_() && stack.m_41783_().m_128425_("tileData", 10) ? stack.m_41783_().m_128469_("tileData") : null;
        int targets = tag == null || tag.m_128456_() || !tag.m_128425_("targetCount", 3) ? 0 : tag.m_128451_("targetCount");
        int targetCapacity = this.type.getCapacity();
        if (targetCapacity > 0) {
            info.accept((Component)TextComponents.translation((String)"wormhole.portal_stabilizer.info.targets", (Object[])new Object[]{targets, targetCapacity}).color(ChatFormatting.YELLOW).get());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VISUAL_TARGETS});
    }

    static {
        int maxCapacity = 0;
        for (TargetCellType type : TargetCellType.values()) {
            if (type.getVisualCapacity() <= maxCapacity) continue;
            maxCapacity = type.getVisualCapacity();
        }
        VISUAL_TARGETS = IntegerProperty.m_61631_((String)"targets", (int)0, (int)maxCapacity);
    }
}

