/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.packets.PortalColorTargetPacket;
import com.supermartijn642.wormhole.portal.screen.PortalTargetColorScreen;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class PortalTargetSelectColorButton
extends AbstractButtonWidget {
    public static final ResourceLocation BUTTON_OUTLINE = new ResourceLocation("wormhole", "textures/gui/large_color_buttons.png");
    public static final ResourceLocation RANDOM_COLOR_PORTAL = new ResourceLocation("wormhole", "textures/gui/random_color_portal.png");
    private final DyeColor color;
    private final Supplier<DyeColor> targetColor;

    public PortalTargetSelectColorButton(int x, int y, PortalTargetColorScreen screen, DyeColor color) {
        super(x, y, 36, 36, () -> Wormhole.CHANNEL.sendToServer((BasePacket)new PortalColorTargetPacket(screen.getPortalGroup(), screen.targetIndex, color)));
        this.color = color;
        this.targetColor = () -> {
            PortalTarget target = screen.getPortalGroup().getTarget(screen.targetIndex);
            return target == null ? null : target.color;
        };
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((ResourceLocation)BUTTON_OUTLINE);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)(this.targetColor.get() == this.color ? 0.6666667f : (this.isFocused() ? 0.33333334f : 0.0f)), (float)1.0f, (float)0.33333334f);
        ScreenUtils.bindTexture((ResourceLocation)(this.color == null ? RANDOM_COLOR_PORTAL : new ResourceLocation("wormhole", "textures/portal/portal_" + this.color.m_41065_() + ".png")));
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)(this.x + 2), (float)(this.y + 2), (float)(this.width - 4), (float)(this.height - 4), (float)0.0f, (float)0.0f, (float)1.0f, (float)0.03125f);
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)("wormhole.color." + (this.color == null ? "random" : this.color.m_41065_()))).get();
    }
}

