/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.portal.IEnergyCellEntity;
import com.supermartijn642.wormhole.portal.PortalGroupBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCellBlockEntity
extends PortalGroupBlockEntity
implements IEnergyCellEntity {
    protected final EnergyCellType f_58855_;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this);
    protected int energy = 0;
    private int ticks = 40;

    public EnergyCellBlockEntity(EnergyCellType type, BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)type.getBlockEntityType(), pos, state);
        this.f_58855_ = type;
    }

    @Override
    public void update() {
        super.update();
        ++this.ticks;
        if (this.ticks >= 40) {
            int fillLevel;
            int maxEnergy = this.getMaxEnergyStored(true);
            int n = fillLevel = maxEnergy > 0 ? (int)Math.ceil((double)this.getEnergyStored(true) / (double)maxEnergy * 15.0) : 0;
            if ((Integer)this.m_58900_().m_61143_((Property)EnergyCellBlock.ENERGY_LEVEL) != fillLevel) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)EnergyCellBlock.ENERGY_LEVEL, (Comparable)Integer.valueOf(fillLevel)));
                this.ticks = 0;
            }
        }
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().receiveEnergy(maxReceive, simulate);
        }
        if (maxReceive < 0) {
            return -this.extractEnergy(-maxReceive, simulate);
        }
        int absorb = Math.min(this.getMaxEnergyStored(true) - this.energy, maxReceive);
        if (!simulate) {
            this.energy += absorb;
            if (absorb > 0) {
                this.dataChanged();
            }
        }
        return absorb;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
        if (maxExtract < 0) {
            return -this.receiveEnergy(-maxExtract, simulate);
        }
        int drain = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= drain;
            if (drain > 0) {
                this.dataChanged();
            }
        }
        return drain;
    }

    @Override
    public int getEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getStoredEnergy();
        }
        return Math.min(this.energy, this.getMaxEnergyStored(true));
    }

    @Override
    public int getMaxEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getEnergyCapacity();
        }
        return this.f_58855_.getCapacity();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCapability.invalidate();
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag tag = super.writeData();
        tag.m_128405_("energy", this.energy);
        return tag;
    }

    @Override
    protected void readData(CompoundTag tag) {
        super.readData(tag);
        this.energy = tag.m_128441_("energy") ? tag.m_128451_("energy") : 0;
    }

    public static class CreativeEnergyCellBlockEntity
    extends EnergyCellBlockEntity {
        public CreativeEnergyCellBlockEntity(BlockPos pos, BlockState state) {
            super(EnergyCellType.CREATIVE, pos, state);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
            return 0;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
            return maxExtract;
        }

        @Override
        public int getEnergyStored(boolean fromGroup) {
            return this.getMaxEnergyStored();
        }

        @Override
        public int getMaxEnergyStored(boolean fromGroup) {
            return this.f_58855_.getCapacity();
        }

        @Override
        public boolean canExtract() {
            return true;
        }

        @Override
        public void update() {
            super.update();
            for (Direction direction : Direction.values()) {
                BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                if (entity == null) continue;
                entity.getCapability(ForgeCapabilities.ENERGY).ifPresent(this::pushEnergy);
            }
        }

        public void pushEnergy(IEnergyStorage energyStorage) {
            if (energyStorage.canReceive()) {
                energyStorage.receiveEnergy(this.getMaxEnergyStored(true), false);
            }
        }
    }

    public static class AdvancedEnergyCellBlockEntity
    extends EnergyCellBlockEntity {
        public AdvancedEnergyCellBlockEntity(BlockPos pos, BlockState state) {
            super(EnergyCellType.ADVANCED, pos, state);
        }
    }

    public static class BasicEnergyCellBlockEntity
    extends EnergyCellBlockEntity {
        public BasicEnergyCellBlockEntity(BlockPos pos, BlockState state) {
            super(EnergyCellType.BASIC, pos, state);
        }
    }
}

