/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.client.gui.elements;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.phosphophyllite.client.gui.api.ITooltip;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class TooltipElement<T extends AbstractContainerMenu>
extends AbstractElement<T>
implements ITooltip {
    public boolean tooltipEnable;
    public Component tooltip;
    boolean focused = false;

    public TooltipElement(@Nonnull PhosphophylliteScreen<T> parent, int x, int y, int width, int height, @Nullable Component tooltip) {
        super(parent, x, y, width, height);
        this.tooltipEnable = tooltip != null;
        this.tooltip = tooltip;
    }

    @Override
    public void renderTooltip(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.tooltipEnable && this.tooltip != null && this.m_5953_(mouseX, mouseY)) {
            List list = Arrays.stream(this.tooltip.getString().split("\\n")).map(Component::m_237113_).map(MutableComponent::m_7532_).collect(Collectors.toList());
            graphics.m_280245_(this.parent.getFont(), list, mouseX, mouseY);
        }
    }

    @Override
    public void enable() {
        this.tooltipEnable = true;
    }

    @Override
    public void disable() {
        this.tooltipEnable = false;
    }

    public void m_93692_(boolean shouldFocus) {
        this.focused = shouldFocus;
    }

    public boolean m_93696_() {
        return this.focused;
    }
}

