/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.lang.ref.WeakReference;
import net.minecraft.core.SectionPos;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.AABB;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.internal.QuartzCore;

@NonnullDefault
public class WorldEngine {
    private final Long2ObjectOpenHashMap<WeakReference<DrawBatch>> sectionDrawBatchers = new Long2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<AABB, WeakReference<DrawBatch>> customDrawBatchers = new Object2ObjectOpenHashMap();

    public synchronized DrawBatch getBatcherForAABB(AABB aabb) {
        return this.getBatcherForAABB(aabb, false);
    }

    public synchronized DrawBatch getBatcherForAABB(AABB aabb, boolean allowReuse) {
        if (aabb.minX() >> 4 == aabb.maxX() >> 4 && aabb.minY() >> 4 == aabb.maxY() >> 4 && aabb.minZ() >> 4 == aabb.maxZ() >> 4) {
            return this.getBatcherForSection(SectionPos.m_123209_((int)(aabb.minX() >> 4), (int)(aabb.minY() >> 4), (int)(aabb.minZ() >> 4)));
        }
        WeakReference weakRef = (WeakReference)this.customDrawBatchers.get((Object)aabb);
        DrawBatch drawBatch = null;
        if (weakRef != null) {
            drawBatch = (DrawBatch)weakRef.get();
        }
        if (drawBatch == null) {
            if (allowReuse) {
                ObjectIterator iter = this.customDrawBatchers.object2ObjectEntrySet().fastIterator();
                while (iter.hasNext()) {
                    Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)iter.next();
                    AABB AABB2 = (AABB)entry.getKey();
                    if (!AABB2.contains(aabb) || (drawBatch = (DrawBatch)((WeakReference)entry.getValue()).get()) == null) continue;
                    return drawBatch;
                }
            }
            DrawBatch newDrawBatch = QuartzCore.INSTANCE.createDrawBatch();
            newDrawBatch.setCullAABB(aabb);
            QuartzCore.CLEANER.register(newDrawBatch, () -> {
                WorldEngine worldEngine = this;
                synchronized (worldEngine) {
                    this.customDrawBatchers.remove((Object)aabb);
                }
            });
            this.customDrawBatchers.put((Object)aabb, new WeakReference<DrawBatch>(newDrawBatch));
            return newDrawBatch;
        }
        return drawBatch;
    }

    public synchronized DrawBatch getBatcherForSection(long sectionPos) {
        WeakReference weakRef = (WeakReference)this.sectionDrawBatchers.get(sectionPos);
        DrawBatch drawBatch = null;
        if (weakRef != null) {
            drawBatch = (DrawBatch)weakRef.get();
        }
        if (drawBatch == null) {
            DrawBatch newDrawBatch = QuartzCore.INSTANCE.createDrawBatch();
            newDrawBatch.setCullAABB(new AABB(0, 0, 0, 15, 15, 15).translate(SectionPos.m_123223_((int)SectionPos.m_123213_((long)sectionPos)), SectionPos.m_123223_((int)SectionPos.m_123225_((long)sectionPos)), SectionPos.m_123223_((int)SectionPos.m_123230_((long)sectionPos))));
            QuartzCore.CLEANER.register(newDrawBatch, () -> {
                WorldEngine worldEngine = this;
                synchronized (worldEngine) {
                    this.sectionDrawBatchers.remove(sectionPos);
                }
            });
            this.sectionDrawBatchers.put(sectionPos, new WeakReference<DrawBatch>(newDrawBatch));
            return newDrawBatch;
        }
        return drawBatch;
    }
}

