/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.reflect.Field;
import net.roguelogix.quartz.internal.QuartzCore;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.Vector4fc;
import org.joml.Vector4ic;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libc.LibCString;

public record PointerWrapper(long pointer, long size) {
    private static final boolean JOML_UNSAFE_AVAILABLE;
    public static PointerWrapper NULLPTR;
    private static final Long2ObjectMap<MemoryLeak> liveAllocations;
    private static final ObjectArraySet<PointerWrapper> validWriteLocations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PointerWrapper trackPointer(PointerWrapper wrapper) {
        if (!QuartzCore.DEBUG) {
            return wrapper;
        }
        Long2ObjectMap<MemoryLeak> long2ObjectMap = liveAllocations;
        synchronized (long2ObjectMap) {
            liveAllocations.put(wrapper.pointer, (Object)new MemoryLeak(wrapper));
        }
        PointerWrapper.addAccessibleLocation(wrapper);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void untrackPointer(PointerWrapper wrapper) {
        if (!QuartzCore.DEBUG) {
            return;
        }
        Long2ObjectMap<MemoryLeak> long2ObjectMap = liveAllocations;
        synchronized (long2ObjectMap) {
            if (liveAllocations.remove(wrapper.pointer) == null) {
                for (MemoryLeak value : liveAllocations.values()) {
                    if (!value.allocated.contains(wrapper)) continue;
                    throw new IllegalStateException("Attempt to free sub pointer, source pointer originally allocated at cause", value);
                }
                throw new IllegalStateException("Attempt to free pointer not currently live, potential double free?");
            }
        }
        PointerWrapper.removeAccessibleLocation(wrapper);
    }

    public static PointerWrapper alloc(long size) {
        long ptr = MemoryUtil.nmemAlloc((long)size);
        return PointerWrapper.trackPointer(new PointerWrapper(ptr, size));
    }

    public PointerWrapper realloc(long newSize) {
        if (this.size == newSize) {
            return this;
        }
        long newPtr = MemoryUtil.nmemRealloc((long)this.pointer, (long)newSize);
        PointerWrapper newWrapped = new PointerWrapper(newPtr, newSize);
        if (this.pointer != newPtr) {
            PointerWrapper.untrackPointer(this);
        }
        PointerWrapper.trackPointer(newWrapped);
        return newWrapped;
    }

    public void free() {
        if (this == NULLPTR) {
            return;
        }
        PointerWrapper.untrackPointer(this);
        MemoryUtil.nmemFree((long)this.pointer);
    }

    public static void logLeakedMemory() {
        if (QuartzCore.DEBUG) {
            System.out.println("Logging memory leaks");
            for (MemoryLeak value : liveAllocations.values()) {
                value.printStackTrace();
            }
            System.out.println("Memory leaks logged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAccessibleLocation(PointerWrapper wrapper) {
        if (!QuartzCore.DEBUG) {
            return;
        }
        ObjectArraySet<PointerWrapper> objectArraySet = validWriteLocations;
        synchronized (objectArraySet) {
            validWriteLocations.add((Object)wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAccessibleLocation(PointerWrapper wrapper) {
        if (!QuartzCore.DEBUG) {
            return;
        }
        ObjectArraySet<PointerWrapper> objectArraySet = validWriteLocations;
        synchronized (objectArraySet) {
            validWriteLocations.remove((Object)wrapper);
        }
    }

    public static void verifyCanAccessLocation(long ptr, long size) {
        if (!QuartzCore.DEBUG) {
            return;
        }
        for (PointerWrapper value : validWriteLocations) {
            if (value.pointer > ptr || value.pointer + value.size <= ptr) continue;
            if (value.pointer + value.size < ptr + size) {
                throw new IllegalArgumentException("Attempt to write past end of native buffer");
            }
            return;
        }
        throw new NullPointerException("Unable to find a valid write location for attempted write");
    }

    public void set(byte data) {
        this.set(0L, this.size, data);
    }

    public void set(long offset, long size, byte data) {
        LibCString.nmemset((long)(this.pointer + offset), (int)data, (long)size);
    }

    public static void copy(PointerWrapper src, long srcOffset, PointerWrapper dst, long dstOffset, long size) {
        if (src.pointer == 0L || dst.pointer == 0L) {
            throw new IllegalStateException("Attempt to use NULLPTR");
        }
        long srcPtr = src.pointer + srcOffset;
        long dstPtr = dst.pointer + dstOffset;
        if (QuartzCore.DEBUG) {
            if (size <= 0L) {
                throw new IllegalArgumentException("Attempt to copy pointer with invalid size: " + size);
            }
            if (srcOffset <= 0L) {
                throw new IllegalArgumentException("Attempt to copy pointer with invalid srcOffset: " + srcOffset);
            }
            if (dstOffset <= 0L) {
                throw new IllegalArgumentException("Attempt to copy pointer with invalid dstOffset: " + dstOffset);
            }
            long srcEndIndex = srcOffset + size;
            if (srcEndIndex > src.size) {
                throw new IllegalArgumentException("Attempt to copy pointer would read past end of source. source size: " + src.size + ", source offset: " + srcOffset + ", copy size: " + size);
            }
            long dstEndIndex = dstOffset + size;
            if (dstEndIndex > dst.size) {
                throw new IllegalArgumentException("Attempt to copy pointer would read past end of destination. dest size: " + dst.size + ", dest offset: " + dstOffset + ", copy size: " + size);
            }
            PointerWrapper.verifyCanAccessLocation(srcPtr, size);
            PointerWrapper.verifyCanAccessLocation(dstPtr, size);
        }
        boolean overlaps = srcOffset == dstOffset;
        overlaps |= srcPtr < dstPtr && dstPtr < srcPtr + size;
        if (overlaps |= dstPtr < srcPtr && srcPtr < dstPtr + size) {
            LibCString.nmemmove((long)dstPtr, (long)srcPtr, (long)size);
        } else {
            LibCString.nmemcpy((long)dstPtr, (long)srcPtr, (long)size);
        }
    }

    public void copyTo(long srcOffset, PointerWrapper dst, long dstOffset, long size) {
        PointerWrapper.copy(this, srcOffset, dst, dstOffset, size);
    }

    public void copyToSize(long srcOffset, PointerWrapper dst, long size) {
        this.copyTo(srcOffset, dst, 0L, size);
    }

    public void copyTo(long srcOffset, PointerWrapper dst, long dstOffset) {
        this.copyTo(srcOffset, dst, 0L, Math.min(this.size - srcOffset, dst.size));
    }

    public void copyTo(long srcOffset, PointerWrapper dst) {
        this.copyTo(srcOffset, dst, 0L, Math.min(this.size - srcOffset, dst.size));
    }

    public void copyTo(PointerWrapper dst, long dstOffset) {
        this.copyTo(0L, dst, 0L, Math.min(this.size, dst.size - dstOffset));
    }

    public void copyToSize(PointerWrapper dst, long size) {
        this.copyTo(0L, dst, 0L, size);
    }

    public void copyTo(PointerWrapper dst) {
        this.copyTo(0L, dst, 0L, Math.min(this.size, dst.size));
    }

    private void checkRange(long offset, long writeSize) {
        this.checkRange(offset, writeSize, writeSize);
    }

    private void checkRange(long offset, long writeSize, long alignment) {
        if (this.pointer == 0L) {
            throw new IllegalStateException("Attempt to use NULLPTR");
        }
        long dstPtr = this.pointer + offset;
        if (QuartzCore.DEBUG) {
            if (offset < 0L) {
                throw new IllegalArgumentException("Attempt to access before beginning of pointer");
            }
            if (offset + writeSize > this.size) {
                throw new IllegalArgumentException("Attempt to access past end of pointer");
            }
            if (dstPtr % alignment != 0L) {
                throw new IllegalArgumentException("Attempt to access unaligned address");
            }
            PointerWrapper.verifyCanAccessLocation(dstPtr, writeSize);
        }
    }

    public void putByte(long offset, byte val) {
        this.checkRange(offset, 1L);
        MemoryUtil.memPutByte((long)(this.pointer + offset), (byte)val);
    }

    public void putShort(long offset, short val) {
        this.checkRange(offset, 2L);
        MemoryUtil.memPutShort((long)(this.pointer + offset), (short)val);
    }

    public void putInt(long offset, int val) {
        this.checkRange(offset, 4L);
        MemoryUtil.memPutInt((long)(this.pointer + offset), (int)val);
    }

    public void putLong(long offset, long val) {
        this.checkRange(offset, 8L);
        MemoryUtil.memPutLong((long)(this.pointer + offset), (long)val);
    }

    public void putFloat(long offset, float val) {
        this.checkRange(offset, 4L);
        MemoryUtil.memPutFloat((long)(this.pointer + offset), (float)val);
    }

    public void putDouble(long offset, double val) {
        this.checkRange(offset, 8L);
        MemoryUtil.memPutDouble((long)(this.pointer + offset), (double)val);
    }

    public void putVector3i(long offset, Vector3ic vector) {
        this.checkRange(offset, 12L, 16L);
        long dstPtr = this.pointer + offset;
        if (JOML_UNSAFE_AVAILABLE) {
            vector.getToAddress(this.pointer + offset);
        } else {
            MemoryUtil.memPutInt((long)dstPtr, (int)vector.x());
            MemoryUtil.memPutInt((long)(dstPtr + 4L), (int)vector.y());
            MemoryUtil.memPutInt((long)(dstPtr + 8L), (int)vector.z());
        }
    }

    public void putVector3f(long offset, Vector3fc vector) {
        this.checkRange(offset, 12L, 16L);
        long dstPtr = this.pointer + offset;
        if (JOML_UNSAFE_AVAILABLE) {
            vector.getToAddress(this.pointer + offset);
        } else {
            MemoryUtil.memPutFloat((long)dstPtr, (float)vector.x());
            MemoryUtil.memPutFloat((long)(dstPtr + 4L), (float)vector.y());
            MemoryUtil.memPutFloat((long)(dstPtr + 8L), (float)vector.z());
        }
    }

    public void putVector4i(long offset, Vector4ic vector) {
        this.checkRange(offset, 16L);
        long dstPtr = this.pointer + offset;
        if (JOML_UNSAFE_AVAILABLE) {
            vector.getToAddress(this.pointer + offset);
        } else {
            MemoryUtil.memPutInt((long)dstPtr, (int)vector.x());
            MemoryUtil.memPutInt((long)(dstPtr + 4L), (int)vector.y());
            MemoryUtil.memPutInt((long)(dstPtr + 8L), (int)vector.z());
            MemoryUtil.memPutInt((long)(dstPtr + 12L), (int)vector.w());
        }
    }

    public void putVector4f(long offset, Vector4fc vector) {
        this.checkRange(offset, 16L);
        long dstPtr = this.pointer + offset;
        if (JOML_UNSAFE_AVAILABLE) {
            vector.getToAddress(this.pointer + offset);
        } else {
            MemoryUtil.memPutFloat((long)dstPtr, (float)vector.x());
            MemoryUtil.memPutFloat((long)(dstPtr + 4L), (float)vector.y());
            MemoryUtil.memPutFloat((long)(dstPtr + 8L), (float)vector.z());
            MemoryUtil.memPutFloat((long)(dstPtr + 12L), (float)vector.w());
        }
    }

    public void putMatrix4f(long offset, Matrix4fc matrix) {
        this.checkRange(offset, 64L, 16L);
        long dstPtr = this.pointer + offset;
        if (JOML_UNSAFE_AVAILABLE) {
            matrix.getToAddress(dstPtr);
        } else {
            MemoryUtil.memPutFloat((long)dstPtr, (float)matrix.m00());
            MemoryUtil.memPutFloat((long)(dstPtr + 4L), (float)matrix.m01());
            MemoryUtil.memPutFloat((long)(dstPtr + 8L), (float)matrix.m02());
            MemoryUtil.memPutFloat((long)(dstPtr + 12L), (float)matrix.m03());
            MemoryUtil.memPutFloat((long)(dstPtr + 16L), (float)matrix.m10());
            MemoryUtil.memPutFloat((long)(dstPtr + 20L), (float)matrix.m11());
            MemoryUtil.memPutFloat((long)(dstPtr + 24L), (float)matrix.m12());
            MemoryUtil.memPutFloat((long)(dstPtr + 28L), (float)matrix.m13());
            MemoryUtil.memPutFloat((long)(dstPtr + 32L), (float)matrix.m20());
            MemoryUtil.memPutFloat((long)(dstPtr + 36L), (float)matrix.m21());
            MemoryUtil.memPutFloat((long)(dstPtr + 40L), (float)matrix.m22());
            MemoryUtil.memPutFloat((long)(dstPtr + 44L), (float)matrix.m23());
            MemoryUtil.memPutFloat((long)(dstPtr + 48L), (float)matrix.m30());
            MemoryUtil.memPutFloat((long)(dstPtr + 52L), (float)matrix.m31());
            MemoryUtil.memPutFloat((long)(dstPtr + 56L), (float)matrix.m32());
            MemoryUtil.memPutFloat((long)(dstPtr + 60L), (float)matrix.m33());
        }
    }

    public void putMatrix3x4f(long offset, Matrix4fc matrix) {
        this.checkRange(offset, 48L, 16L);
        long dstPtr = this.pointer + offset;
        MemoryUtil.memPutFloat((long)dstPtr, (float)matrix.m00());
        MemoryUtil.memPutFloat((long)(dstPtr + 4L), (float)matrix.m01());
        MemoryUtil.memPutFloat((long)(dstPtr + 8L), (float)matrix.m02());
        MemoryUtil.memPutFloat((long)(dstPtr + 12L), (float)matrix.m03());
        MemoryUtil.memPutFloat((long)(dstPtr + 16L), (float)matrix.m10());
        MemoryUtil.memPutFloat((long)(dstPtr + 20L), (float)matrix.m11());
        MemoryUtil.memPutFloat((long)(dstPtr + 24L), (float)matrix.m12());
        MemoryUtil.memPutFloat((long)(dstPtr + 28L), (float)matrix.m13());
        MemoryUtil.memPutFloat((long)(dstPtr + 32L), (float)matrix.m20());
        MemoryUtil.memPutFloat((long)(dstPtr + 36L), (float)matrix.m21());
        MemoryUtil.memPutFloat((long)(dstPtr + 40L), (float)matrix.m22());
        MemoryUtil.memPutFloat((long)(dstPtr + 44L), (float)matrix.m23());
    }

    public void putShortIdx(long index, short val) {
        this.putShort(index * 2L, val);
    }

    public void putIntIdx(long index, int val) {
        this.putInt(index * 4L, val);
    }

    public void putLongIdx(long index, long val) {
        this.putLong(index * 8L, val);
    }

    public void putFloatIdx(long index, float val) {
        this.putFloat(index * 4L, val);
    }

    public void putDoubleIdx(long index, double val) {
        this.putDouble(index * 8L, val);
    }

    public void putVector3iIdx(long index, Vector3ic vector) {
        this.putVector3i(index * 12L, vector);
    }

    public void putVector4iIdx(long index, Vector4ic vector) {
        this.putVector4i(index * 16L, vector);
    }

    public void putVector4fIdx(long index, Vector4fc vector) {
        this.putVector4f(index * 16L, vector);
    }

    public void putMatrix4fIdx(long index, Matrix4fc matrix4f) {
        this.putMatrix4f(index * 64L, matrix4f);
    }

    public byte getByte(long offset) {
        this.checkRange(offset, 1L);
        return MemoryUtil.memGetByte((long)(this.pointer + offset));
    }

    public short getShort(long offset) {
        this.checkRange(offset, 2L);
        return MemoryUtil.memGetShort((long)(this.pointer + offset));
    }

    public int getInt(long offset) {
        this.checkRange(offset, 4L);
        return MemoryUtil.memGetInt((long)(this.pointer + offset));
    }

    public long getLong(long offset) {
        this.checkRange(offset, 8L);
        return MemoryUtil.memGetLong((long)(this.pointer + offset));
    }

    public float getFloat(long offset) {
        this.checkRange(offset, 4L);
        return MemoryUtil.memGetFloat((long)(this.pointer + offset));
    }

    public double getDouble(long offset) {
        this.checkRange(offset, 8L);
        return MemoryUtil.memGetDouble((long)(this.pointer + offset));
    }

    public void getMatrix4f(long offset, Matrix4f matrix) {
        this.checkRange(offset, 64L, 16L);
        matrix.setFromAddress(this.pointer + offset);
    }

    public void getMatrix3x4f(long offset, Matrix4f matrix) {
        this.checkRange(offset, 64L, 16L);
        matrix.setFromAddress(this.pointer + offset);
    }

    public void getVector3i(long offset, Vector3i vector) {
        this.checkRange(offset, 12L, 16L);
        vector.setFromAddress(this.pointer + offset);
    }

    public short getShortIdx(long index) {
        return this.getShort(index * 2L);
    }

    public int getIntIdx(long index) {
        return this.getInt(index * 4L);
    }

    public long getLongIdx(long index) {
        return this.getLong(index * 8L);
    }

    public float getFloatIdx(long index) {
        return this.getFloat(index * 4L);
    }

    public double getDoubleIdx(long index) {
        return this.getDouble(index * 8L);
    }

    public void getMatrix4fIdx(long index, Matrix4f matrix4f) {
        this.getMatrix4f(index * 64L, matrix4f);
    }

    public PointerWrapper slice(long offset, long size) {
        if (this.pointer == 0L) {
            throw new IllegalStateException("Attempt to use NULLPTR");
        }
        if (QuartzCore.DEBUG) {
            if (size <= 0L) {
                throw new IllegalArgumentException("Attempt to slice pointer to invalid size: " + size);
            }
            if (offset < 0L) {
                throw new IllegalArgumentException("Attempt to slice pointer to invalid offset: " + offset);
            }
            if (offset >= this.size) {
                throw new IllegalArgumentException("Attempt to slice pointer to offset past end. offset: " + offset + ", source size: " + this.size);
            }
            if (offset + size > this.size) {
                throw new IllegalArgumentException("Attempt to slice pointer to offset and size past end. offset: " + offset + ", size: " + size + ", source size: " + this.size);
            }
        }
        return new PointerWrapper(this.pointer + offset, size);
    }

    public boolean contains(PointerWrapper that) {
        return this.pointer <= that.pointer && that.pointer + that.size <= this.pointer + this.size;
    }

    static {
        boolean available = false;
        try {
            Class<?> memUtilClass = PointerWrapper.class.getClassLoader().loadClass("org.joml.MemUtil");
            Class<?> memUtilUnsafeClass = PointerWrapper.class.getClassLoader().loadClass("org.joml.MemUtil$MemUtilUnsafe");
            Field instanceField = memUtilClass.getDeclaredField("INSTANCE");
            instanceField.setAccessible(true);
            Object memUtilInstance = instanceField.get(null);
            available = memUtilUnsafeClass.isInstance(memUtilInstance);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        JOML_UNSAFE_AVAILABLE = available;
        NULLPTR = new PointerWrapper(0L, 0L);
        liveAllocations = new Long2ObjectOpenHashMap();
        validWriteLocations = new ObjectArraySet();
    }

    private static class MemoryLeak
    extends Exception {
        private final PointerWrapper allocated;

        private MemoryLeak(PointerWrapper allocated) {
            super("ptr: " + allocated.pointer + " size: " + allocated.size);
            this.allocated = allocated;
        }
    }
}

