/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import net.minecraft.resources.ResourceLocation;
import net.roguelogix.phosphophyllite.util.Util;
import net.roguelogix.quartz.internal.util.VertexFormatOutput;
import org.lwjgl.opengl.GL45C;

public class GL46FeedbackPrograms {
    public static final ResourceLocation shaderLocation = new ResourceLocation("quartz", "shaders/gl46/transform_feedback.vert");
    private static int vertexShader;
    private static final Reference2IntMap<VertexFormatOutput> programs;

    public static void startup() {
        StringBuilder extensionsBuilder = new StringBuilder();
        extensionsBuilder.append("#version 450 core\n");
        extensionsBuilder.append("#line 1 1\n");
        StringBuilder prependBuilder = new StringBuilder();
        prependBuilder.append("#line 0 2\n");
        prependBuilder.append("#define QUARTZ_INSERT_DEFINES\n");
        prependBuilder.append("#define POSITION_LOCATION 0\n");
        prependBuilder.append("#define COLOR_LOCATION 1\n");
        prependBuilder.append("#define TEX_COORD_LOCATION 2\n");
        prependBuilder.append("#define NORMAL_LOCATION 3\n");
        prependBuilder.append("#define WORLD_POSITION_LOCATION 4\n");
        prependBuilder.append("#define DYNAMIC_MATRIX_ID_LOCATION 5\n");
        prependBuilder.append("#define STATIC_MATRIX_LOCATION 8\n");
        prependBuilder.append("#define STATIC_NORMAL_MATRIX_LOCATION 12\n");
        String shaderCode = Util.readResourceLocation((ResourceLocation)shaderLocation);
        if (shaderCode == null) {
            throw new IllegalStateException("Failed to load shader code for " + shaderLocation);
        }
        vertexShader = GL45C.glCreateShader((int)35633);
        GL45C.glShaderSource((int)vertexShader, (CharSequence[])new CharSequence[]{extensionsBuilder, prependBuilder, shaderCode});
        GL45C.glCompileShader((int)vertexShader);
        if (GL45C.glGetShaderi((int)vertexShader, (int)35713) != 1) {
            String infoLog = GL45C.glGetShaderInfoLog((int)vertexShader);
            GL45C.glDeleteShader((int)vertexShader);
            throw new IllegalStateException("Feedback shader compilation failed for " + shaderLocation + "\n" + infoLog + "\n");
        }
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85811_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85812_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85813_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85814_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85815_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_166851_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85816_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85817_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85818_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85819_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85820_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85821_));
        GL46FeedbackPrograms.getProgramForOutputFormat(VertexFormatOutput.of(DefaultVertexFormat.f_85822_));
    }

    public static void shutdown() {
        GL45C.glDeleteShader((int)vertexShader);
        vertexShader = 0;
        for (Reference2IntMap.Entry value : programs.reference2IntEntrySet()) {
            GL45C.glDeleteProgram((int)value.getIntValue());
        }
        programs.clear();
    }

    public static void reload() {
        GL46FeedbackPrograms.shutdown();
        GL46FeedbackPrograms.startup();
    }

    private static int createProgramForFormat(VertexFormatOutput outputFormat) {
        int vertexProgram = GL45C.glCreateProgram();
        GL45C.glAttachShader((int)vertexProgram, (int)vertexShader);
        GL45C.glTransformFeedbackVaryings((int)vertexProgram, (CharSequence[])outputFormat.varyings(), (int)35980);
        GL45C.glProgramParameteri((int)vertexProgram, (int)33368, (int)1);
        GL45C.glLinkProgram((int)vertexProgram);
        if (GL45C.glGetProgrami((int)vertexProgram, (int)35714) != 1) {
            String infoLog = GL45C.glGetProgramInfoLog((int)vertexProgram);
            GL45C.glDeleteShader((int)vertexShader);
            GL45C.glDeleteProgram((int)vertexProgram);
            throw new IllegalStateException("Feedback program link failed for " + outputFormat.format() + "\n" + infoLog + "\n");
        }
        GL45C.glDetachShader((int)vertexProgram, (int)vertexShader);
        return vertexProgram;
    }

    public static int getProgramForOutputFormat(VertexFormatOutput formatOutput) {
        return programs.computeIfAbsent((Object)formatOutput, GL46FeedbackPrograms::createProgramForFormat);
    }

    static {
        programs = new Reference2IntArrayMap();
    }
}

