/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33.batching;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.AABB;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.MagicNumbers;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.B3DStateHelper;
import net.roguelogix.quartz.internal.common.DynamicMatrixManager;
import net.roguelogix.quartz.internal.common.InternalMesh;
import net.roguelogix.quartz.internal.gl33.GL33Buffer;
import net.roguelogix.quartz.internal.gl33.batching.GL33DrawBatch;
import net.roguelogix.quartz.internal.gl33.batching.GL33DrawChunk;
import net.roguelogix.quartz.internal.gl33.batching.GL33Instance;
import org.joml.Matrix4fc;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL33C;

@NonnullDefault
public class GL33InstanceManager {
    final GL33DrawBatch drawBatch;
    private final boolean autoDelete;
    private int instancesAllocated = 8;
    GL33Buffer.Allocation instanceDataAlloc;
    private InternalMesh staticMesh;
    private InternalMesh.Manager.TrackedMesh trackedMesh;
    private final Consumer<InternalMesh.Manager.TrackedMesh> meshBuildCallback;
    final ReferenceArrayList<GL33DrawChunk> drawChunks = new ReferenceArrayList();
    final ReferenceArrayList<WeakReference<GL33Instance>> instances = new ReferenceArrayList();
    final FastArraySet<WeakReference<GL33Instance>> dirtyInstances = new FastArraySet();
    int matrixUpdateVAO;
    private final Buffer.CallbackHandle matrixVAOUpdateHandle;

    public GL33InstanceManager(GL33DrawBatch drawBatch, InternalMesh mesh, boolean autoDelete) {
        this.drawBatch = drawBatch;
        this.autoDelete = autoDelete;
        WeakReference<GL33InstanceManager> ref = new WeakReference<GL33InstanceManager>(this);
        this.meshBuildCallback = ignored -> {
            GL33InstanceManager manager = (GL33InstanceManager)ref.get();
            if (manager != null) {
                manager.onRebuild();
            }
        };
        this.instanceDataAlloc = drawBatch.instanceDataBuffer.alloc(this.instancesAllocated * 128, 128);
        this.matrixVAOUpdateHandle = this.instanceDataAlloc.addReallocCallback(this::rebuildVAOs);
        this.rebuildVAOs(this.instanceDataAlloc);
        this.updateMesh(mesh);
    }

    void delete() {
        while (!this.instances.isEmpty()) {
            WeakReference lastInstanceRef = (WeakReference)this.instances.peek(0);
            GL33Instance lastInstance = (GL33Instance)lastInstanceRef.get();
            if (lastInstance == null) {
                this.instances.pop();
                continue;
            }
            this.removeInstance(lastInstance.location);
        }
        this.drawChunks.forEach(this.drawBatch::removeDrawChunk);
        this.drawChunks.clear();
        this.drawBatch.instanceManagers.remove((Object)this.staticMesh, (Object)this);
        this.drawBatch.instanceBatches.remove((Object)this);
        this.trackedMesh.removeBuildCallback(this.meshBuildCallback);
        this.instanceDataAlloc.free();
        GL33C.glDeleteVertexArrays((int)this.matrixUpdateVAO);
        this.matrixVAOUpdateHandle.delete();
    }

    void rebuildVAOs(Buffer.Allocation newBuffer) {
        GL33C.glDeleteVertexArrays((int)this.matrixUpdateVAO);
        this.matrixUpdateVAO = GL33C.glGenVertexArrays();
        B3DStateHelper.bindVertexArray(this.matrixUpdateVAO);
        B3DStateHelper.bindArrayBuffer(newBuffer.allocator().as(GL33Buffer.class).handle());
        for (int i = 0; i < 9; ++i) {
            GL33C.glEnableVertexAttribArray((int)i);
        }
        int instanceDataOffset = newBuffer.offset();
        GL33C.glVertexAttribPointer((int)0, (int)4, (int)5126, (boolean)false, (int)128, (long)(0 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)128, (long)(16 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)2, (int)4, (int)5126, (boolean)false, (int)128, (long)(32 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)3, (int)4, (int)5126, (boolean)false, (int)128, (long)(48 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)4, (int)4, (int)5126, (boolean)false, (int)128, (long)(64 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)5, (int)4, (int)5126, (boolean)false, (int)128, (long)(80 + instanceDataOffset));
        GL33C.glVertexAttribPointer((int)6, (int)4, (int)5126, (boolean)false, (int)128, (long)(96 + instanceDataOffset));
        GL33C.glVertexAttribIPointer((int)7, (int)3, (int)5124, (int)128, (long)(112 + instanceDataOffset));
        GL33C.glVertexAttribIPointer((int)8, (int)1, (int)5124, (int)128, (long)(124 + instanceDataOffset));
        for (GL33DrawChunk chunk : this.drawChunks) {
            chunk.rebuildVAO(newBuffer.offset());
        }
    }

    void setDirty() {
        this.drawBatch.dirtyBatches.add((Object)this);
    }

    void updateMesh(Mesh quartzMesh) {
        if (!(quartzMesh instanceof InternalMesh)) {
            return;
        }
        InternalMesh mesh = (InternalMesh)quartzMesh;
        if (this.trackedMesh != null) {
            this.trackedMesh.removeBuildCallback(this.meshBuildCallback);
        }
        this.staticMesh = mesh;
        this.trackedMesh = QuartzCore.INSTANCE.meshManager.getMeshInfo(mesh);
        if (this.trackedMesh == null) {
            throw new IllegalArgumentException("Unable to find mesh in mesh registry");
        }
        this.onRebuild();
        this.trackedMesh.addBuildCallback(this.meshBuildCallback);
    }

    private void onRebuild() {
        this.drawChunks.forEach(this.drawBatch::removeDrawChunk);
        this.drawChunks.clear();
        for (RenderType renderType : this.trackedMesh.usedRenderTypes()) {
            InternalMesh.Manager.TrackedMesh.Component component = this.trackedMesh.renderTypeComponent(renderType);
            if (component == null) continue;
            GL33DrawChunk newChunk = new GL33DrawChunk(this, renderType, component);
            this.drawChunks.add((Object)newChunk);
            this.drawBatch.addDrawChunk(newChunk);
        }
        this.setDirty();
        this.drawBatch.setVertexCountDirty();
    }

    @Nullable
    GL33Instance createInstance(Vector3ic position, @Nullable DynamicMatrix dynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable AABB aabb) {
        DynamicMatrixManager.Matrix castedMatrix;
        block6: {
            block5: {
                if (dynamicMatrix == null) {
                    dynamicMatrix = this.drawBatch.IDENTITY_DYNAMIC_MATRIX;
                }
                if (!(dynamicMatrix instanceof DynamicMatrixManager.Matrix)) break block5;
                castedMatrix = (DynamicMatrixManager.Matrix)dynamicMatrix;
                if (this.drawBatch.dynamicMatrixManager.owns(dynamicMatrix)) break block6;
            }
            return null;
        }
        if (staticMatrix == null) {
            staticMatrix = MagicNumbers.IDENTITY_MATRIX;
        }
        return this.createInstance(position, castedMatrix, staticMatrix, aabb);
    }

    GL33Instance createInstance(Vector3ic position, @Nullable DynamicMatrixManager.Matrix dynamicMatrix, @Nullable Matrix4fc staticMatrix, @Nullable AABB aabb) {
        GL33Instance instance = new GL33Instance(this, this.instances.size());
        instance.updatePosition(position);
        instance.updateDynamicMatrix(dynamicMatrix);
        instance.updateStaticMatrix(staticMatrix);
        instance.updateAABB(aabb);
        this.instances.add(instance.selfWeakRef);
        this.setDirty();
        this.drawBatch.setVertexCountDirty();
        return instance;
    }

    public void removeInstance(GL33Instance.Location location) {
        if (location.location == -1) {
            return;
        }
        if (this.instances.isEmpty()) {
            return;
        }
        WeakReference lastInstanceRef = (WeakReference)this.instances.pop();
        this.setDirty();
        this.drawBatch.setVertexCountDirty();
        if (this.instances.size() == location.location) {
            location.location = -1;
            this.dirtyInstances.remove((Object)lastInstanceRef);
            if (this.instances.isEmpty() && this.autoDelete) {
                this.delete();
            }
            return;
        }
        GL33Instance lastInstance = (GL33Instance)lastInstanceRef.get();
        if (lastInstance == null) {
            location.location = -1;
            this.dirtyInstances.remove((Object)lastInstanceRef);
            return;
        }
        lastInstance.location.location = location.location;
        WeakReference removed = (WeakReference)this.instances.set(location.location, (Object)lastInstanceRef);
        location.location = -1;
        this.dirtyInstances.remove((Object)removed);
        lastInstance.setDirty();
    }

    public int instanceCount() {
        return this.instances.size();
    }

    public void writeUpdates() {
        if (this.dirtyInstances.isEmpty()) {
            return;
        }
        if (this.instanceCount() > this.instancesAllocated || this.instanceCount() > 16 && this.instanceCount() <= this.instancesAllocated / 4) {
            int newAllocCount = this.instancesAllocated;
            do {
                int n = newAllocCount = this.instanceCount() > newAllocCount ? newAllocCount * 2 : newAllocCount / 2;
            } while (this.instanceCount() > newAllocCount || this.instanceCount() > 16 && this.instanceCount() <= newAllocCount / 4);
            this.instanceDataAlloc = this.drawBatch.instanceDataBuffer.realloc(this.instanceDataAlloc, newAllocCount * 128, 128, false);
            this.instancesAllocated = newAllocCount;
            for (WeakReference instanceRef : this.instances) {
                GL33Instance instance = (GL33Instance)instanceRef.get();
                if (instance == null) continue;
                instance.setDirty();
            }
        }
        for (int i = 0; i < this.dirtyInstances.size(); ++i) {
            WeakReference dirtyInstanceRef = (WeakReference)this.dirtyInstances.get(i);
            GL33Instance instance = (GL33Instance)dirtyInstanceRef.get();
            if (instance == null) continue;
            instance.write();
        }
        this.dirtyInstances.clear();
    }
}

