/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl33;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.internal.Buffer;
import net.roguelogix.quartz.internal.IrisDetection;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.DrawInfo;
import net.roguelogix.quartz.internal.gl33.BrokenMacDriverWorkaroundFragmentShader;
import net.roguelogix.quartz.internal.gl33.GL33Buffer;
import net.roguelogix.quartz.internal.gl33.GL33ComputePrograms;
import net.roguelogix.quartz.internal.gl33.GL33FeedbackDrawing;
import net.roguelogix.quartz.internal.gl33.GL33FeedbackPrograms;
import net.roguelogix.quartz.internal.gl33.GL33LightEngine;
import net.roguelogix.quartz.internal.gl33.GL33Statics;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.KHRDebug;

@NonnullDefault
public class GL33Core
extends QuartzCore {
    public static final GL33Core INSTANCE;
    private long lastTimeNano = 0L;
    public final DrawInfo drawInfo = new DrawInfo();

    @Override
    protected void startupInternal() {
        BrokenMacDriverWorkaroundFragmentShader.startup();
        GL33ComputePrograms.startup();
        GL33FeedbackPrograms.startup();
        GL33LightEngine.startup();
        GL33FeedbackDrawing.startup();
    }

    @Override
    protected void shutdownInternal() {
        GL33FeedbackDrawing.shutdown();
        GL33LightEngine.shutdown();
        GL33FeedbackPrograms.shutdown();
        GL33ComputePrograms.shutdown();
        BrokenMacDriverWorkaroundFragmentShader.shutdown();
    }

    @Override
    protected void resourcesReloadedInternal() {
        GL33FeedbackPrograms.reload();
    }

    @Override
    public DrawBatch createDrawBatch() {
        return GL33FeedbackDrawing.createDrawBatch();
    }

    @Override
    public Buffer allocBuffer(boolean GPUOnly) {
        return new GL33Buffer(GPUOnly);
    }

    @Override
    public void frameStart(PoseStack pMatrixStack, float pPartialTicks, long pFinishTimeNano, boolean pDrawBlockOutline, Camera pActiveRenderInfo, GameRenderer pGameRenderer, LightTexture pLightmap, Matrix4f pProjection) {
        deletionQueue.runAll();
        long timeNanos = System.nanoTime();
        long deltaNano = timeNanos - this.lastTimeNano;
        this.lastTimeNano = timeNanos;
        if (this.lastTimeNano == 0L) {
            deltaNano = 0L;
        }
        Vec3 playerPosition = pActiveRenderInfo.m_90583_();
        Vector3d vec3d = new Vector3d(playerPosition.f_82479_, playerPosition.f_82480_, playerPosition.f_82481_);
        vec3d.floor();
        this.drawInfo.playerPosition.set((int)vec3d.x, (int)vec3d.y, (int)vec3d.z);
        this.drawInfo.playerPositionNegative.set((Vector3ic)this.drawInfo.playerPosition).negate();
        this.drawInfo.playerSubBlock.set(playerPosition.f_82479_ - (double)this.drawInfo.playerPosition.x, playerPosition.f_82480_ - (double)this.drawInfo.playerPosition.y, playerPosition.f_82481_ - (double)this.drawInfo.playerPosition.z);
        this.drawInfo.playerSubBlockNegative.set((Vector3fc)this.drawInfo.playerSubBlockNegative).negate();
        this.drawInfo.projectionMatrix.set((Matrix4fc)pProjection);
        this.drawInfo.projectionMatrix.mul((Matrix4fc)pMatrixStack.m_85850_().m_252922_());
        this.drawInfo.projectionMatrix.get(this.drawInfo.projectionMatrixFloatBuffer);
        this.drawInfo.mojPose = pMatrixStack.m_85850_();
        this.drawInfo.deltaNano = deltaNano;
        this.drawInfo.partialTicks = pPartialTicks;
        GL33FeedbackDrawing.beginFrame();
        this.meshManager.vertexBuffer.as(GL33Buffer.class).flush();
    }

    @Override
    public void lightUpdated() {
        GL33LightEngine.update((BlockAndTintGetter)Minecraft.m_91087_().f_91073_);
        if (!GL33FeedbackDrawing.hasBatch()) {
            return;
        }
        GL33FeedbackDrawing.collectAllFeedback(IrisDetection.areShadersActive());
    }

    @Override
    public void preTerrainSetup() {
    }

    @Override
    public void shadowPass(PoseStack modelView, Matrix4f projectionMatrix) {
        if (!GL33FeedbackDrawing.hasBatch()) {
            return;
        }
        GL33FeedbackDrawing.setMatrices(projectionMatrix, modelView.m_85850_().m_252922_());
        GL33FeedbackDrawing.getActiveRenderTypes().forEach(GL33FeedbackDrawing::drawRenderType);
    }

    @Override
    public void preOpaque() {
        if (!GL33FeedbackDrawing.hasBatch()) {
            return;
        }
        BufferUploader.m_231208_();
        IrisDetection.bindIrisFramebuffer();
        GL33FeedbackDrawing.setMatrices(RenderSystem.getProjectionMatrix(), this.drawInfo.mojPose.m_252922_());
        for (RenderType renderType : GL33FeedbackDrawing.getActiveRenderTypes()) {
            if (!(renderType instanceof RenderType.CompositeRenderType)) continue;
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            if (compositeRenderType.m_173265_().f_110577_ != RenderStateShard.f_110134_) continue;
            GL33FeedbackDrawing.drawRenderType(renderType);
        }
    }

    @Override
    public void endOpaque() {
        if (!GL33FeedbackDrawing.hasBatch()) {
            return;
        }
        BufferUploader.m_231208_();
        for (RenderType renderType : GL33FeedbackDrawing.getActiveRenderTypes()) {
            if (!(renderType instanceof RenderType.CompositeRenderType)) continue;
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            if (compositeRenderType.m_173265_().f_110577_ == RenderStateShard.f_110134_) continue;
            RenderSystem.depthMask((boolean)false);
            GL33FeedbackDrawing.drawRenderType(renderType);
        }
        RenderSystem.depthMask((boolean)true);
    }

    @Override
    public void endTranslucent() {
    }

    @Override
    public void waitIdle() {
    }

    @Override
    public int frameInFlight() {
        return 0;
    }

    @Override
    public void sectionDirty(int x, int y, int z) {
        GL33LightEngine.sectionDirty(x, y, z);
    }

    @Override
    public void addDebugText(List<String> list) {
        list.add("Quartz backend: OpenGL 3.3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (!GL33Statics.AVAILABLE) {
            LOGGER.error("OpenGL 3.3 implementation requirements not available, this is the fallback for Quartz, something is very wrong");
            StringBuilder builder = new StringBuilder();
            builder.append("Unable to initialize Quartz GL33Core due to missing GL capability, report this error!\n");
            builder.append("ISSUE URL -> https://github.com/BiggerSeries/Quartz/issues\n");
            builder.append("GL_VENDOR : ").append(GL33C.glGetString((int)7936)).append('\n');
            builder.append("GL_RENDERER : ").append(GL33C.glGetString((int)7937)).append('\n');
            builder.append("GL_VERSION : ").append(GL33C.glGetString((int)7938)).append('\n');
            builder.append("GL_SHADING_LANGUAGE_VERSION : ").append(GL33C.glGetString((int)35724)).append('\n');
            GLCapabilities caps = GL.getCapabilities();
            builder.append("GL_ARB_separate_shader_objects : ").append(caps.GL_ARB_separate_shader_objects).append('\n');
            int extensionCount = GL33C.glGetInteger((int)33309);
            builder.append("Supported OpenGL Extensions : ").append(extensionCount).append('\n');
            for (int i = 0; i < extensionCount; ++i) {
                builder.append(GL33C.glGetStringi((int)7939, (int)i)).append('\n');
            }
            Minecraft.m_91332_((CrashReport)new CrashReport("Quartz startup failed", (Throwable)new IllegalStateException(builder.toString())));
        }
        boolean hasKHRDebug = GL.getCapabilities().GL_KHR_debug;
        try {
            LOGGER.info("Quartz initializing GL33Core");
            if (hasKHRDebug) {
                KHRDebug.glPushDebugGroup((int)33353, (int)0, (CharSequence)"Quartz GL33 Renderer Setup");
            }
            INSTANCE = new GL33Core();
            LOGGER.info("Quartz GL33Core initialized");
        }
        finally {
            if (hasKHRDebug) {
                KHRDebug.glPopDebugGroup();
            }
        }
    }
}

