/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.AABB;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.Quartz;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@NonnullDefault
public interface QuartzTile
extends IModularTile {
    @Nullable
    default public DrawBatch.Instance createInstance(Mesh mesh, @Nullable DynamicMatrix dynamicMatrix, @Nullable Matrix4fc staticMatrix) {
        return ((Module)this.module(QuartzTile.class, Module.class)).createInstance(mesh, dynamicMatrix, staticMatrix);
    }

    default public DynamicMatrix createDynamicMatrix(@Nullable DynamicMatrix parentTransform, @Nullable DynamicMatrix.UpdateFunc updateFunc) {
        return ((Module)this.module(QuartzTile.class, Module.class)).createDynamicMatrix(parentTransform, updateFunc);
    }

    default public void rebuildModel(PhosphophylliteCompound modelData) {
        ((Module)this.module(QuartzTile.class, Module.class)).rebuildModel(modelData);
    }

    public void buildQuartzModel(PhosphophylliteCompound var1);

    default public void updateModelData(PhosphophylliteCompound updateData) {
        ((Module)this.module(QuartzTile.class, Module.class)).updateModelData(updateData);
    }

    public void modelDataUpdate(PhosphophylliteCompound var1);

    @Nullable
    default public AABB getAABB() {
        return null;
    }

    public static class Module
    extends TileModule<QuartzTile> {
        private DrawBatch drawBatch;
        private final ObjectArrayList<DrawBatch.Instance> instances = new ObjectArrayList();
        private final BlockPos blockPos = ((BlockEntity)((QuartzTile)this.iface).as(BlockEntity.class)).m_58899_();
        private final Vector3i position = new Vector3i(this.blockPos.m_123341_(), this.blockPos.m_123342_(), this.blockPos.m_123343_());
        @Nullable
        PhosphophylliteCompound fullModelData;
        @Nullable
        PhosphophylliteCompound lastDataUpdate;

        private Module(QuartzTile iface) {
            super((IModularTile)iface);
        }

        @Nullable
        private DrawBatch.Instance createInstance(Mesh mesh, @Nullable DynamicMatrix dynamicMatrix, @Nullable Matrix4fc staticMatrix) {
            return this.getDrawBatch().createInstance((Vector3ic)this.position, mesh, dynamicMatrix, staticMatrix, null);
        }

        DynamicMatrix createDynamicMatrix(@Nullable DynamicMatrix parentTransform, @Nullable DynamicMatrix.UpdateFunc updateFunc) {
            return this.getDrawBatch().createDynamicMatrix(null, parentTransform, updateFunc);
        }

        private DrawBatch getDrawBatch() {
            if (this.drawBatch == null) {
                AABB aabb = ((QuartzTile)this.iface).getAABB();
                this.drawBatch = aabb == null ? Quartz.getDrawBatchForBlock(this.blockPos) : Quartz.getDrawBatcherForAABB(aabb);
            }
            return this.drawBatch;
        }

        private void rebuildModel(PhosphophylliteCompound modelData) {
            this.fullModelData = modelData;
            this.lastDataUpdate = null;
            this.requestUpdate();
        }

        private void updateModelData(PhosphophylliteCompound modelData) {
            this.lastDataUpdate = modelData;
            if (this.fullModelData == null) {
                this.fullModelData = this.lastDataUpdate;
            } else {
                this.fullModelData.combine(modelData);
            }
            this.requestUpdate();
        }

        private void requestUpdate() {
            BlockEntity BE = (BlockEntity)((QuartzTile)this.iface).as(BlockEntity.class);
            Level level = BE.m_58904_();
            if (level != null) {
                level.m_7260_(BE.m_58899_(), BE.m_58900_(), BE.m_58900_(), 0);
            }
        }

        @Nullable
        public CompoundTag getUpdateNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.lastDataUpdate != null) {
                tag.m_177853_("data", (List)this.lastDataUpdate.toROBN());
            } else if (this.fullModelData != null) {
                tag.m_177853_("fullData", (List)this.fullModelData.toROBN());
            } else {
                return null;
            }
            return tag;
        }

        public void handleUpdateNBT(CompoundTag nbt) {
            if (nbt.m_128441_("fullData")) {
                this.handleDataNBT(nbt);
                return;
            }
            this.lastDataUpdate = new PhosphophylliteCompound(nbt.m_128463_("data"));
            if (this.fullModelData == null) {
                this.fullModelData = this.lastDataUpdate;
            } else {
                this.fullModelData.combine(this.lastDataUpdate);
            }
            ((QuartzTile)this.iface).updateModelData(this.fullModelData);
        }

        @Nullable
        public CompoundTag getDataNBT() {
            if (this.fullModelData != null) {
                CompoundTag tag = new CompoundTag();
                tag.m_177853_("fullData", (List)this.fullModelData.toROBN());
                return tag;
            }
            return null;
        }

        public void handleDataNBT(CompoundTag nbt) {
            for (DrawBatch.Instance instance : this.instances) {
                instance.delete();
            }
            this.instances.clear();
            this.fullModelData = new PhosphophylliteCompound(nbt.m_128463_("fullData"));
            this.drawBatch = null;
            ((QuartzTile)this.iface).buildQuartzModel(this.fullModelData);
        }
    }
}

