/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.facade;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.blockentity.IFacadeBlockEntity;
import ca.teamdman.sfm.common.facade.FacadeData;
import ca.teamdman.sfm.common.facade.FacadePlanAnalysisResult;
import ca.teamdman.sfm.common.facade.FacadeTransparency;
import ca.teamdman.sfm.common.facade.IFacadePlan;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.ConfirmationParams;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public record ApplyFacadesFacadePlan(FacadeData facadeData, FacadeTransparency facadeTransparency, Set<BlockPos> positions) implements IFacadePlan
{
    @Override
    public void apply(Level level) {
        this.positions().forEach(pos -> {
            BlockState blockState = level.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block instanceof IFacadableBlock) {
                IFacadableBlock facadableBlock = (IFacadableBlock)block;
                BlockState nextBlockState = (BlockState)((BlockState)facadableBlock.getFacadeBlock().getStateForPlacementByFacadePlan((LevelAccessor)level, (BlockPos)pos).m_61124_(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY, (Comparable)((Object)this.facadeTransparency()))).m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(this.facadeData.facadeBlockState().getLightEmission((BlockGetter)level, pos)));
                level.m_7731_(pos, nextBlockState, 10);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof IFacadeBlockEntity) {
                    IFacadeBlockEntity facadeBlockEntity = (IFacadeBlockEntity)blockEntity;
                    facadeBlockEntity.updateFacadeData(this.facadeData());
                } else {
                    SFM.LOGGER.warn("Block entity {} at {} is not a facade block entity", pos, (Object)blockEntity);
                }
            } else {
                SFM.LOGGER.warn("Block {} at {} is not a facadable block", (Object)block, pos);
            }
        });
    }

    @Override
    @Nullable
    public ConfirmationParams computeWarning(Level level) {
        FacadePlanAnalysisResult analysisResult = FacadePlanAnalysisResult.analyze(level, this.positions);
        if (analysisResult.shouldWarn()) {
            return ConfirmationParams.of(LocalizationKeys.FACADE_CONFIRM_APPLY_SCREEN_TITLE.getComponent(), LocalizationKeys.FACADE_CONFIRM_APPLY_SCREEN_MESSAGE.getComponent(analysisResult.facadeDataToCount().size(), analysisResult.countAffected()));
        }
        return null;
    }
}

