/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.client.screen.SFMConfirmationScreen;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.text_editor.SFMTextEditScreenDiskOpenContext;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.command.ConfigCommandBehaviourInput;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.diagnostics.SFMDiagnostics;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.ServerboundManagerFixPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerRebuildPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerResetPacket;
import ca.teamdman.sfm.common.net.ServerboundServerConfigRequestPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.joml.Matrix4f;

public class ManagerScreen
extends AbstractContainerScreen<ManagerContainerMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = new ResourceLocation("sfm", "textures/gui/container/manager.png");
    private final float STATUS_DURATION = 40.0f;
    private Component status = Component.m_237119_();
    private float statusCountdown = 0.0f;
    private Button diagButton;
    private Button clipboardPasteButton;
    private Button clipboardCopyButton;
    private Button discordButton;
    private Button resetButton;
    private Button editButton;
    private Button examplesButton;
    private Button logsButton;
    private Button rebuildButton;
    private Button serverConfigButton;

    public ManagerScreen(ManagerContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    public List<Button> getButtonsForJEIExclusionZones() {
        return List.of(this.clipboardPasteButton, this.editButton, this.examplesButton, this.clipboardCopyButton, this.logsButton, this.rebuildButton, this.serverConfigButton);
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player == null || player.m_5833_();
    }

    public void updateVisibilities() {
        boolean diskPresent = ((ManagerContainerMenu)this.f_97732_).m_38853_(0).m_6657_();
        this.diagButton.f_93624_ = this.shouldShowDiagButton();
        this.clipboardCopyButton.f_93624_ = diskPresent;
        this.logsButton.f_93624_ = diskPresent;
        this.rebuildButton.f_93624_ = diskPresent && !this.isReadOnly();
        this.clipboardPasteButton.f_93624_ = diskPresent && !this.isReadOnly();
        this.resetButton.f_93624_ = diskPresent && !this.isReadOnly();
        this.editButton.f_93624_ = diskPresent && !this.isReadOnly();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (Screen.m_96630_((int)pKeyCode) && this.clipboardPasteButton.f_93624_) {
            this.onClipboardPasteButtonClicked();
            return true;
        }
        if (Screen.m_96632_((int)pKeyCode) && this.clipboardCopyButton.f_93624_) {
            this.onClipboardCopyButtonClicked();
            return true;
        }
        if (pKeyCode == 69 && Screen.m_96637_() && Screen.m_96638_() && this.examplesButton.f_93624_) {
            this.onExamplesButtonClicked();
            return true;
        }
        if (SFMKeyMappings.isKeyDown(SFMKeyMappings.MANAGER_SCREEN_OPEN_TEXT_EDITOR_KEY) && this.editButton.f_93624_) {
            this.onEditButtonClicked();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public ChatFormatting getMillisecondColour(float ms) {
        if (ms <= 5.0f) {
            return ChatFormatting.GREEN;
        }
        if (ms <= 15.0f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public void m_88315_(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mx, my, partialTicks);
        this.m_280072_(graphics, mx, my);
        this.updateVisibilities();
        this.statusCountdown -= partialTicks;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 120;
        int buttonHeight = 16;
        this.clipboardPasteButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 16).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON).setOnPress(button -> this.onClipboardPasteButtonClicked()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.MANAGER_GUI_PASTE_FROM_CLIPBOARD_BUTTON_TOOLTIP).build());
        this.editButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 16 + 50).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_EDIT_BUTTON).setOnPress(button -> this.onEditButtonClicked()).setTooltip((Screen)this, this.f_96547_, (Component)LocalizationKeys.MANAGER_GUI_EDIT_BUTTON_TOOLTIP.getComponent(SFMKeyMappings.getKeyDisplay(SFMKeyMappings.MANAGER_SCREEN_OPEN_TEXT_EDITOR_KEY))).build());
        this.examplesButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 32 + 50).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON).setOnPress(button -> this.onExamplesButtonClicked()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.MANAGER_GUI_VIEW_EXAMPLES_BUTTON_TOOLTIP).build());
        this.discordButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 112).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_DISCORD_BUTTON).setOnPress(button -> this.onDiscordButtonClicked()).build());
        this.clipboardCopyButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 128).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_COPY_TO_CLIPBOARD_BUTTON).setOnPress(button -> this.onClipboardCopyButtonClicked()).build());
        this.logsButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 144).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_VIEW_LOGS_BUTTON).setOnPress(button -> this.onLogsButtonClicked()).build());
        this.rebuildButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 160).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_REBUILD_BUTTON).setOnPress(button -> this.onRebuildButtonClicked()).build());
        this.serverConfigButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 - buttonWidth, (this.f_96544_ - this.f_97727_) / 2 + 176).setSize(buttonWidth, buttonHeight).setText(LocalizationKeys.MANAGER_GUI_SERVER_CONFIG_BUTTON).setOnPress(button -> this.onServerConfigButtonClicked()).build());
        this.resetButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 + 120, (this.f_96544_ - this.f_97727_) / 2 + 10).setSize(50, 12).setText(LocalizationKeys.MANAGER_GUI_RESET_BUTTON).setOnPress(button -> this.onResetButtonClicked()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.MANAGER_GUI_RESET_BUTTON_TOOLTIP).build());
        this.diagButton = (Button)this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition((this.f_96543_ - this.f_97726_) / 2 + 35, (this.f_96544_ - this.f_97727_) / 2 + 48).setSize(12, 14).setText((Component)Component.m_237113_((String)"!")).setOnPress(button -> this.onDiagButtonClicked()).setTooltip((Screen)this, this.f_96547_, this.isReadOnly() ? LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP_READ_ONLY : LocalizationKeys.MANAGER_GUI_WARNING_BUTTON_TOOLTIP).build());
        this.updateVisibilities();
    }

    private void onDiagButtonClicked() {
        if (Screen.m_96638_() && !this.isReadOnly()) {
            this.sendAttemptFix();
        } else {
            this.onSaveDiagnosticsToClipboard();
        }
    }

    private String getProgram() {
        return ((ManagerContainerMenu)this.f_97732_).program;
    }

    private void onEditButtonClicked() {
        SFMScreenChangeHelpers.showProgramEditScreen(new SFMTextEditScreenDiskOpenContext(this.getProgram(), LabelPositionHolder.from(((ManagerContainerMenu)this.f_97732_).getDisk()), this::sendProgram));
    }

    private void onExamplesButtonClicked() {
        SFMScreenChangeHelpers.showExampleListScreen(this.getProgram(), LabelPositionHolder.from(((ManagerContainerMenu)this.f_97732_).getDisk()), this::sendProgram);
    }

    private void onLogsButtonClicked() {
        SFMScreenChangeHelpers.showLogsScreen((ManagerContainerMenu)this.f_97732_);
    }

    private void performReset() {
        SFMPackets.sendToServer(new ServerboundManagerResetPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION));
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_RESET.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onResetButtonClicked() {
        if (this.getProgram().isBlank() && LabelPositionHolder.from(((ManagerContainerMenu)this.f_97732_).getDisk()).isEmpty()) {
            this.performReset();
            return;
        }
        SFMScreenChangeHelpers.setOrPushScreen((Screen)new SFMConfirmationScreen(this::performReset, LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_TITLE.getComponent(), LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_MESSAGE.getComponent(), LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_YES_BUTTON.getComponent(), LocalizationKeys.MANAGER_RESET_CONFIRM_SCREEN_NO_BUTTON.getComponent(), 20));
    }

    private void onRebuildButtonClicked() {
        SFMPackets.sendToServer(new ServerboundManagerRebuildPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION));
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_REBUILD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onServerConfigButtonClicked() {
        SFMPackets.sendToServer(new ServerboundServerConfigRequestPacket(ConfigCommandBehaviourInput.SHOW));
    }

    private void sendAttemptFix() {
        SFMPackets.sendToServer(new ServerboundManagerFixPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION));
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_FIX.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void sendProgram(String program) {
        program = SFMPacketDaddy.truncate(program, 32367);
        SFMPackets.sendToServer(new ServerboundManagerProgramPacket(((ManagerContainerMenu)this.f_97732_).f_38840_, ((ManagerContainerMenu)this.f_97732_).MANAGER_POSITION, program));
        ((ManagerContainerMenu)this.f_97732_).program = program;
        this.status = LocalizationKeys.MANAGER_GUI_STATUS_LOADED_CLIPBOARD.getComponent();
        this.statusCountdown = 40.0f;
    }

    private void onDiscordButtonClicked() {
        String discordUrl = "https://discord.gg/xjXYj9MmS4";
        SFMScreenChangeHelpers.setOrPushScreen((Screen)new ConfirmLinkScreen(proceed -> {
            if (proceed) {
                Util.m_137581_().m_137646_(discordUrl);
            }
            SFMScreenChangeHelpers.popScreen();
        }, discordUrl, false));
    }

    private void onClipboardCopyButtonClicked() {
        try {
            Minecraft.m_91087_().f_91068_.m_90911_(((ManagerContainerMenu)this.f_97732_).program);
            this.status = LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed to save clipboard", t);
        }
    }

    private boolean shouldShowDiagButton() {
        ItemStack disk = ((ManagerContainerMenu)this.f_97732_).getDisk();
        if (!(disk.m_41720_() instanceof DiskItem)) {
            return false;
        }
        List<TranslatableContents> errors = DiskItem.getErrors(disk);
        List<TranslatableContents> warnings = DiskItem.getWarnings(disk);
        return !errors.isEmpty() || !warnings.isEmpty();
    }

    private void onSaveDiagnosticsToClipboard() {
        try {
            ItemStack disk = ((ManagerContainerMenu)this.f_97732_).CONTAINER.m_8020_(0);
            if (!(disk.m_41720_() instanceof DiskItem)) {
                return;
            }
            String diagnosticInfo = SFMDiagnostics.getDiagnosticsSummary(disk);
            Minecraft.m_91087_().f_91068_.m_90911_(diagnosticInfo);
            this.status = LocalizationKeys.MANAGER_GUI_STATUS_SAVED_CLIPBOARD.getComponent();
            this.statusCountdown = 40.0f;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed saving clipboard", t);
        }
    }

    private void onClipboardPasteButtonClicked() {
        boolean shouldConfirm;
        String clipboardContents;
        try {
            clipboardContents = Minecraft.m_91087_().f_91068_.m_90876_();
        }
        catch (Throwable t) {
            SFM.LOGGER.error("failed loading clipboard", t);
            return;
        }
        String existingProgram = this.getProgram();
        boolean bl = shouldConfirm = !existingProgram.isBlank() && !existingProgram.equals(clipboardContents);
        if (!shouldConfirm) {
            this.sendProgram(clipboardContents);
            return;
        }
        SFMScreenChangeHelpers.setOrPushScreen((Screen)new SFMConfirmationScreen(() -> this.sendProgram(clipboardContents), LocalizationKeys.MANAGER_PASTE_CONFIRM_SCREEN_TITLE.getComponent(), LocalizationKeys.MANAGER_PASTE_CONFIRM_SCREEN_MESSAGE.getComponent(), LocalizationKeys.MANAGER_PASTE_CONFIRM_SCREEN_YES_BUTTON.getComponent(), LocalizationKeys.MANAGER_PASTE_CONFIRM_SCREEN_NO_BUTTON.getComponent(), 20));
    }

    @MCVersionDependentBehaviour
    private void disableTexture() {
    }

    protected void m_280003_(GuiGraphics graphics, int mx, int my) {
        PoseStack poseStack = graphics.m_280168_();
        super.m_280003_(graphics, mx, my);
        ManagerBlockEntity.State state = ((ManagerContainerMenu)this.f_97732_).state;
        SFMFontUtils.draw(graphics, this.f_96547_, (Component)LocalizationKeys.MANAGER_GUI_STATE.getComponent(state.LOC.getComponent().m_130940_(state.COLOR)), this.f_97728_, 20, 0, false);
        if (!((ManagerContainerMenu)this.f_97732_).logLevel.equals(Level.OFF.name())) {
            poseStack.m_85836_();
            double d = this.f_97728_;
            Objects.requireNonNull(this.f_96547_);
            poseStack.m_85837_(d, 9.0 * 1.5, 0.0);
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            SFMFontUtils.draw(graphics, this.f_96547_, (Component)Component.m_237113_((String)((ManagerContainerMenu)this.f_97732_).logLevel), 0, 0, 0, false);
            poseStack.m_85849_();
        }
        if (this.statusCountdown > 0.0f) {
            SFMFontUtils.draw(graphics, this.f_96547_, this.status, this.f_97730_ + this.f_96547_.m_92895_(this.f_169604_.getString()) + 5, this.f_97731_, 0, false);
        }
        long peakTickTimeNanoseconds = 0L;
        for (int i = 0; i < ((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length; ++i) {
            peakTickTimeNanoseconds = Long.max(peakTickTimeNanoseconds, ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[i]);
        }
        long yMax = Long.max(peakTickTimeNanoseconds, 50000000L);
        int plotX = this.f_97728_ + 45;
        int plotY = 40;
        int spaceBetweenPoints = 6;
        int plotWidth = 6 * (((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length - 1);
        int plotHeight = 30;
        this.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        Matrix4f pose = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(pose, (float)plotX, 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_252986_(pose, (float)(plotX + plotWidth), 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_252986_(pose, (float)(plotX + plotWidth), 70.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_252986_(pose, (float)plotX, 70.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        bufferbuilder.m_252986_(pose, (float)plotX, 40.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.5f).m_5752_();
        tesselator.m_85914_();
        bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        int mouseTickTimeIndex = -1;
        for (int i = 0; i < ((ManagerContainerMenu)this.f_97732_).tickTimeNanos.length; ++i) {
            long y = ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[i];
            float normalizedTickTime = y == 0L ? 0.0f : (float)(Math.log10(y) / Math.log10(yMax));
            int plotPosY = 70 - (int)(normalizedTickTime * 30.0f);
            int plotPosX = plotX + 6 * i;
            ChatFormatting c = this.getMillisecondColour((float)y / 1000000.0f);
            float red = (float)(c.m_126665_() >> 16 & 0xFF) / 255.0f;
            float green = (float)(c.m_126665_() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(c.m_126665_() & 0xFF) / 255.0f;
            bufferbuilder.m_252986_(pose, (float)plotPosX, (float)plotPosY, this.getBlitOffsetGood()).m_85950_(red, green, blue, 1.0f).m_5752_();
            if (mx - this.f_97735_ < plotPosX - 3 || mx - this.f_97735_ > plotPosX + 3 || my - this.f_97736_ < 38 || my - this.f_97736_ > 72) continue;
            mouseTickTimeIndex = i;
        }
        tesselator.m_85914_();
        DecimalFormat format = new DecimalFormat("0.000");
        if (mouseTickTimeIndex != -1) {
            long hoveredTickTimeNanoseconds = ((ManagerContainerMenu)this.f_97732_).tickTimeNanos[mouseTickTimeIndex];
            float hoveredTickTimeMilliseconds = (float)hoveredTickTimeNanoseconds / 1000000.0f;
            String formattedMillis = format.format(hoveredTickTimeMilliseconds);
            ChatFormatting lagColor = this.getMillisecondColour(hoveredTickTimeMilliseconds);
            MutableComponent milliseconds = Component.m_237113_((String)formattedMillis).m_130940_(lagColor);
            MutableComponent mutableComponent = LocalizationKeys.MANAGER_GUI_HOVERED_TICK_TIME_MS.getComponent(milliseconds);
            Objects.requireNonNull(this.f_96547_);
            SFMFontUtils.draw(graphics, this.f_96547_, (Component)mutableComponent, this.f_97728_, 20 + 9, 0, false);
            RenderSystem.setShader(GameRenderer::m_172811_);
            tesselator = Tesselator.m_85913_();
            bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            pose = graphics.m_280168_().m_85850_().m_252922_();
            int x = plotX + 6 * mouseTickTimeIndex;
            bufferbuilder.m_252986_(pose, (float)x, 40.0f, this.getBlitOffsetGood()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            bufferbuilder.m_252986_(pose, (float)x, 70.0f, this.getBlitOffsetGood()).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_5752_();
            tesselator.m_85914_();
        } else {
            float peakTickTimeMilliseconds = (float)peakTickTimeNanoseconds / 1000000.0f;
            String formattedMillis = format.format(peakTickTimeMilliseconds);
            ChatFormatting lagColor = this.getMillisecondColour(peakTickTimeMilliseconds);
            MutableComponent milliseconds = Component.m_237113_((String)formattedMillis).m_130940_(lagColor);
            MutableComponent mutableComponent = LocalizationKeys.MANAGER_GUI_PEAK_TICK_TIME_MS.getComponent(milliseconds);
            Objects.requireNonNull(this.f_96547_);
            SFMFontUtils.draw(graphics, this.f_96547_, (Component)mutableComponent, this.f_97728_, 20 + 9, 0, false);
        }
        RenderSystem.disableBlend();
        this.enableTexture();
    }

    @MCVersionDependentBehaviour
    private void enableTexture() {
    }

    @MCVersionDependentBehaviour
    public float getBlitOffsetGood() {
        return 0.0f;
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        if (Minecraft.m_91087_().f_91080_ != this) {
            this.f_169369_.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(w -> w.m_93692_(false));
            return;
        }
        this.drawChildTooltips(pGuiGraphics, pX, pY);
        super.m_280072_(pGuiGraphics, pX, pY);
    }

    @MCVersionDependentBehaviour
    private void drawChildTooltips(GuiGraphics guiGraphics, int mx, int my) {
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mx, int my) {
        if (!((ManagerContainerMenu)this.f_97732_).logLevel.equals(Level.OFF.name())) {
            RenderSystem.setShaderColor((float)0.2f, (float)0.8f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(BACKGROUND_TEXTURE_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }
}

