/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.teamprojecte;

import cn.leomc.teamprojecte.TPCommand;
import cn.leomc.teamprojecte.TPSavedData;
import cn.leomc.teamprojecte.TPTeam;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import moze_intel.projecte.api.capabilities.PECapabilities;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod(value="teamprojecte")
public class TeamProjectE {
    public static final Logger LOGGER = LogUtils.getLogger();

    public TeamProjectE() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRegisterCommand(RegisterCommandsEvent event) {
        TPCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        TPCommand.INVITATIONS.clear();
        TPSavedData.onServerStopped();
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().m_46472_() == Level.f_46428_ && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TeamProjectE.sync(player);
        }
    }

    public static List<ServerPlayer> getAllOnline(List<UUID> uuids) {
        return uuids.stream().map(uuid -> ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid)).filter(Objects::nonNull).toList();
    }

    public static void sync(ServerPlayer player) {
        player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(provider -> provider.sync(player));
    }

    public static List<ServerPlayer> getOnlineTeamMembers(UUID uuid) {
        return TeamProjectE.getOnlineTeamMembers(uuid, true);
    }

    public static List<ServerPlayer> getOnlineTeamMembers(UUID uuid, boolean includeOwner) {
        TPTeam team = TPTeam.getOrCreateTeam(uuid);
        return TeamProjectE.getAllOnline(includeOwner ? team.getAll() : team.getMembers());
    }

    public static UUID getPlayerUUID(Player player) {
        UUID uuid = player.m_36316_().getId();
        if (uuid == null) {
            uuid = player.m_20148_();
        }
        return uuid;
    }
}

