/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.teamprojecte;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import moze_intel.projecte.api.ItemInfo;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public interface KnowledgeData {
    public boolean addKnowledge(ItemInfo var1, UUID var2);

    public boolean removeKnowledge(ItemInfo var1, UUID var2);

    public void clearKnowledge(UUID var1);

    public Set<ItemInfo> getKnowledge(UUID var1);

    public void setFullKnowledge(boolean var1, UUID var2);

    public boolean hasFullKnowledge(UUID var1);

    public void removeMember(UUID var1);

    public KnowledgeData convert(UUID var1);

    public void load(CompoundTag var1);

    public CompoundTag save();

    public static KnowledgeData of(CompoundTag tag) {
        KnowledgeData data = null;
        String type = tag.m_128461_("type");
        if (Sharing.getType().equals(type)) {
            data = new Sharing();
        }
        if (NotSharing.getType().equals(type)) {
            data = new NotSharing();
        }
        if (data == null) {
            return new Sharing();
        }
        data.load(tag);
        return data;
    }

    public static class Sharing
    implements KnowledgeData {
        private final Set<ItemInfo> knowledge = new HashSet<ItemInfo>();
        private boolean fullKnowledge = false;

        @Override
        public boolean addKnowledge(ItemInfo info, UUID player) {
            return this.knowledge.add(info);
        }

        @Override
        public boolean removeKnowledge(ItemInfo info, UUID player) {
            return this.knowledge.remove(info);
        }

        @Override
        public void clearKnowledge(UUID player) {
            this.knowledge.clear();
        }

        @Override
        public Set<ItemInfo> getKnowledge(UUID player) {
            return Set.copyOf(this.knowledge);
        }

        @Override
        public void setFullKnowledge(boolean fullKnowledge, UUID player) {
            this.fullKnowledge = fullKnowledge;
        }

        @Override
        public boolean hasFullKnowledge(UUID player) {
            return this.fullKnowledge;
        }

        @Override
        public void removeMember(UUID player) {
        }

        @Override
        public KnowledgeData convert(UUID owner) {
            NotSharing data = new NotSharing();
            this.knowledge.forEach(info -> data.addKnowledge((ItemInfo)info, owner));
            data.setFullKnowledge(this.fullKnowledge, owner);
            return data;
        }

        @Override
        public void load(CompoundTag tag) {
            this.knowledge.clear();
            this.knowledge.addAll(tag.m_128437_("knowledge", 10).stream().map(t -> ItemInfo.read((CompoundTag)((CompoundTag)t))).filter(Objects::nonNull).toList());
            this.fullKnowledge = tag.m_128471_("fullKnowledge");
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            ListTag itemInfos = new ListTag();
            for (ItemInfo info : this.knowledge) {
                itemInfos.add((Object)info.write(new CompoundTag()));
            }
            tag.m_128365_("knowledge", (Tag)itemInfos);
            tag.m_128379_("fullKnowledge", this.fullKnowledge);
            tag.m_128359_("type", Sharing.getType());
            return tag;
        }

        public static String getType() {
            return "sharing";
        }
    }

    public static class NotSharing
    implements KnowledgeData {
        private final Map<UUID, Set<ItemInfo>> knowledge = new HashMap<UUID, Set<ItemInfo>>();
        private final Set<UUID> fullKnowledge = new HashSet<UUID>();

        @Override
        public boolean addKnowledge(ItemInfo info, UUID player) {
            return this.knowledge.computeIfAbsent(player, k -> new HashSet()).add(info);
        }

        @Override
        public boolean removeKnowledge(ItemInfo info, UUID player) {
            if (this.knowledge.containsKey(player)) {
                return this.knowledge.get(player).remove(info);
            }
            return false;
        }

        @Override
        public void clearKnowledge(UUID player) {
            this.knowledge.remove(player);
        }

        @Override
        public Set<ItemInfo> getKnowledge(UUID player) {
            return Set.copyOf(this.knowledge.getOrDefault(player, Collections.emptySet()));
        }

        @Override
        public void setFullKnowledge(boolean fullKnowledge, UUID player) {
            if (fullKnowledge) {
                this.fullKnowledge.add(player);
            } else {
                this.fullKnowledge.remove(player);
            }
        }

        @Override
        public boolean hasFullKnowledge(UUID player) {
            return this.fullKnowledge.contains(player);
        }

        @Override
        public void removeMember(UUID player) {
            this.knowledge.remove(player);
            this.fullKnowledge.remove(player);
        }

        @Override
        public KnowledgeData convert(UUID owner) {
            Sharing data = new Sharing();
            this.knowledge.values().stream().flatMap(Collection::stream).forEach(info -> data.addKnowledge((ItemInfo)info, Util.f_137441_));
            data.setFullKnowledge(!this.fullKnowledge.isEmpty(), Util.f_137441_);
            return data;
        }

        @Override
        public void load(CompoundTag tag) {
            this.knowledge.clear();
            this.fullKnowledge.clear();
            tag.m_128437_("knowledge", 10).forEach(t -> {
                CompoundTag ct = (CompoundTag)t;
                this.knowledge.put(ct.m_128342_("player"), ct.m_128437_("knowledge", 10).stream().map(i -> ItemInfo.read((CompoundTag)((CompoundTag)i))).filter(Objects::nonNull).collect(Collectors.toSet()));
            });
            tag.m_128437_("fullKnowledge", 11).forEach(t -> this.fullKnowledge.add(NbtUtils.m_129233_((Tag)t)));
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            ListTag k = new ListTag();
            this.knowledge.forEach((uuid, knowledge) -> {
                CompoundTag t = new CompoundTag();
                t.m_128362_("player", uuid);
                ListTag list = new ListTag();
                knowledge.forEach(info -> list.add((Object)info.write(new CompoundTag())));
                t.m_128365_("knowledge", (Tag)list);
                k.add((Object)t);
            });
            tag.m_128365_("knowledge", (Tag)k);
            ListTag fk = new ListTag();
            this.fullKnowledge.forEach(uuid -> fk.add((Object)NbtUtils.m_129226_((UUID)uuid)));
            tag.m_128365_("fullKnowledge", (Tag)fk);
            tag.m_128359_("type", NotSharing.getType());
            return tag;
        }

        public static String getType() {
            return "not_sharing";
        }
    }
}

