/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellGhostPos;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.GhostRenderer;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.CheckForNull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class PanelTileRenderer
implements BlockEntityRenderer<PanelTile> {
    public static ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("tinyredstone", "block/redstone_panel"), new ResourceLocation("tinyredstone", "block/redstone_panel_0001"), new ResourceLocation("tinyredstone", "block/redstone_panel_0010"), new ResourceLocation("tinyredstone", "block/redstone_panel_0011"), new ResourceLocation("tinyredstone", "block/redstone_panel_0100"), new ResourceLocation("tinyredstone", "block/redstone_panel_0101"), new ResourceLocation("tinyredstone", "block/redstone_panel_0110"), new ResourceLocation("tinyredstone", "block/redstone_panel_0111"), new ResourceLocation("tinyredstone", "block/redstone_panel_1000"), new ResourceLocation("tinyredstone", "block/redstone_panel_1001"), new ResourceLocation("tinyredstone", "block/redstone_panel_1010"), new ResourceLocation("tinyredstone", "block/redstone_panel_1011"), new ResourceLocation("tinyredstone", "block/redstone_panel_1100"), new ResourceLocation("tinyredstone", "block/redstone_panel_1101"), new ResourceLocation("tinyredstone", "block/redstone_panel_1110"), new ResourceLocation("tinyredstone", "block/redstone_panel_1111")};
    public static ResourceLocation TEXTURE = TEXTURES[0];
    public static ResourceLocation TEXTURE_BORDER = new ResourceLocation("tinyredstone", "block/redstone_panel_border");
    public static ResourceLocation TEXTURE_CRASHED = new ResourceLocation("tinyredstone", "block/redstone_panel_crashed");
    private float scale = 0.125f;
    private float t2X = 0.0f;
    private float t2Y = -1.0f;
    private float t2Z = 0.0f;
    private float rotation1 = 270.0f;
    private double cellSize = 0.125;

    public PanelTileRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PanelTile tileEntity, float p_112308_, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Boolean hasBase = tileEntity.hasBase();
        matrixStack.m_85836_();
        switch ((Direction)tileEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)) {
            case UP: {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                matrixStack.m_252880_(0.0f, -1.0f, -1.0f);
                break;
            }
            case NORTH: {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                matrixStack.m_252880_(0.0f, 0.0f, -1.0f);
                break;
            }
            case EAST: {
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                matrixStack.m_252880_(0.0f, -1.0f, 0.0f);
                break;
            }
            case SOUTH: {
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                matrixStack.m_252880_(0.0f, -1.0f, 0.0f);
                break;
            }
            case WEST: {
                matrixStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
                matrixStack.m_252880_(-1.0f, 0.0f, 0.0f);
            }
        }
        TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE);
        TextureAtlasSprite borderSprite = RenderHelper.getSprite(TEXTURE_BORDER);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        if (tileEntity.isCovered()) {
            matrixStack.m_85836_();
            tileEntity.panelCover.render(matrixStack, buffer, combinedLight, combinedOverlay, tileEntity.getColor());
            matrixStack.m_85849_();
        } else {
            if (hasBase.booleanValue()) {
                int topTextureIndex = (tileEntity.getConnectedPanelNeighbor(Side.FRONT) ? 2 : 0) + (tileEntity.getConnectedPanelNeighbor(Side.RIGHT) ? 1 : 0) + (tileEntity.getConnectedPanelNeighbor(Side.BACK) ? 8 : 0) + (tileEntity.getConnectedPanelNeighbor(Side.LEFT) ? 4 : 0);
                TextureAtlasSprite topSprite = topTextureIndex == 0 ? sprite : RenderHelper.getSprite(TEXTURES[topTextureIndex]);
                int color = tileEntity.getColor();
                matrixStack.m_85836_();
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(270.0f));
                matrixStack.m_85837_(0.0, -1.0, 0.125);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, topSprite, combinedLight, color, 1.0f);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                matrixStack.m_85837_(0.0, -0.125, 0.0);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.125f, sprite, combinedLight, color, 1.0f);
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                matrixStack.m_252880_(0.0f, -1.0f, 0.0f);
                RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, color, 1.0f);
                matrixStack.m_85849_();
            }
            List<PanelCellPos> positions = tileEntity.getCellPositions();
            for (PanelCellPos pos : positions) {
                IPanelCell panelCell = pos.getIPanelCell();
                if (panelCell == null) continue;
                this.renderCell(matrixStack, pos, buffer, tileEntity.isCrashed() ? 0 : combinedLight, combinedOverlay, tileEntity.isCrashed() ? 0.5f : 1.0f, hasBase);
            }
            if (tileEntity.panelCellGhostPos != null) {
                this.renderCell(matrixStack, tileEntity.panelCellGhostPos, buffer, combinedLight, combinedOverlay, 0.5f, hasBase);
            }
        }
        if (tileEntity.isCrashed() || tileEntity.isOverflown()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.126, 1.0);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(this.rotation1));
            sprite = RenderHelper.getSprite(TEXTURE_CRASHED);
            RenderHelper.drawRectangle(buffer.m_6299_(Minecraft.m_91085_() ? RenderType.m_110451_() : RenderType.m_110466_()), matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, 0.9f);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    private void renderCell(PoseStack matrixStack, PanelCellPos pos, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha, boolean hasBase) {
        alpha = Minecraft.m_91085_() ? 1.0f : alpha;
        matrixStack.m_85836_();
        matrixStack.m_85837_(this.cellSize * (double)pos.getRow(), (hasBase ? 0.125 : 0.0) + (double)pos.getLevel() * 0.125, this.cellSize * (double)pos.getColumn());
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(this.rotation1));
        Side facing = pos.getCellFacing();
        if (facing == Side.LEFT) {
            matrixStack.m_85837_(0.0, -this.cellSize, 0.0);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        } else if (facing == Side.BACK) {
            matrixStack.m_85837_(this.cellSize, -this.cellSize, 0.0);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        } else if (facing == Side.RIGHT) {
            matrixStack.m_85837_(this.cellSize, 0.0, 0.0);
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(270.0f));
        } else if (pos.getCellFacing() == Side.BOTTOM) {
            matrixStack.m_85837_(0.0, -this.cellSize, 0.0);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (pos.getCellFacing() == Side.TOP) {
            matrixStack.m_85837_(0.0, 0.0, this.cellSize);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        matrixStack.m_85841_(this.scale, this.scale, this.scale);
        matrixStack.m_252880_(this.t2X, this.t2Y, this.t2Z);
        pos.getIPanelCell().render(matrixStack, buffer, combinedLight, combinedOverlay, alpha);
        matrixStack.m_85849_();
    }

    @CheckForNull
    public static PanelCellGhostPos getPlayerLookingAtCell(PanelTile panelTile) {
        double distance;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos blockPos = panelTile.m_58899_();
        if (player != null && (distance = panelTile.m_58899_().m_203193_((Position)player.m_20182_())) < 6.0) {
            PosInPanelCell posInPanelCell;
            BlockHitResult blockHitResult = panelTile.getPlayerCollisionHitResult((Player)player);
            PosInPanelCell cellPos1 = PosInPanelCell.fromHitVec(panelTile, panelTile.m_58899_(), blockHitResult);
            panelTile.panelCellHovering = cellPos1;
            if (PanelBlock.isPanelCellItem(player.m_21205_().m_41720_()) && cellPos1 != null) {
                PanelCellPos cellPos = cellPos1;
                if (cellPos.getIPanelCell() != null && (!cellPos.getIPanelCell().hasActivation((Player)player) || player.m_6047_())) {
                    cellPos = cellPos.offset(panelTile.getSideFromDirection(blockHitResult.m_82434_()));
                }
                if (cellPos != null && cellPos.getIPanelCell() == null) {
                    try {
                        Side cellFacing;
                        IPanelCell panelCell = (IPanelCell)PanelBlock.getPanelCellClassFromItem(player.m_21205_().m_41720_()).getConstructors()[0].newInstance(new Object[0]);
                        Side rotationLock = RotationLock.getRotationLock();
                        Side side = cellFacing = rotationLock == null ? panelTile.getSideFromDirection(panelTile.getPlayerDirectionFacing((Player)player, panelCell.canPlaceVertical())) : rotationLock;
                        if (panelCell.needsSolidBase()) {
                            Side attachingSideRel;
                            Side attachingSideDir = panelTile.getSideFromDirection(blockHitResult.m_82434_()).getOpposite();
                            Side side2 = attachingSideRel = attachingSideDir == Side.TOP || attachingSideDir == Side.BOTTOM ? attachingSideDir : Side.FRONT;
                            if (!(panelCell.canAttachToBaseOnSide(attachingSideRel) && (cellPos1.equals(cellPos) || cellPos1.getIPanelCell() != null && cellPos1.getIPanelCell().isPushable()))) {
                                return null;
                            }
                            panelCell.setBaseSide(attachingSideRel);
                            if (attachingSideRel == Side.FRONT) {
                                cellFacing = attachingSideDir;
                            }
                        }
                        panelCell.onPlace(cellPos, (Player)player);
                        return PanelCellGhostPos.fromPosInPanelCell(cellPos, panelCell, cellFacing);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        TinyRedstone.LOGGER.error("Exception thrown when attempting to draw ghost cell: " + e.getMessage());
                    }
                }
            }
            if ((posInPanelCell = PosInPanelCell.fromHitVec(panelTile, blockPos, blockHitResult)) != null && posInPanelCell.getIPanelCell() instanceof RedstoneDust) {
                PanelCellSegment segmentHovering = posInPanelCell.getSegment();
                return PanelCellGhostPos.fromPosInPanelCell(posInPanelCell, new GhostRenderer(segmentHovering), posInPanelCell.getCellFacing());
            }
        }
        return null;
    }
}

