/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.containers.handlers;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import thetadev.constructionwand.api.IContainerHandler;
import thetadev.constructionwand.basics.WandUtil;

public class HandlerBundle
implements IContainerHandler {
    @Override
    public boolean matches(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return inventoryStack != null && inventoryStack.m_41613_() == 1 && inventoryStack.m_41720_() == Items.f_151058_;
    }

    @Override
    public int countItems(Player player, ItemStack itemStack, ItemStack inventoryStack) {
        return this.getContents(inventoryStack).filter(stack -> WandUtil.stackEquals(stack, itemStack)).map(ItemStack::m_41613_).reduce(0, Integer::sum);
    }

    @Override
    public int useItems(Player player, ItemStack itemStack, ItemStack inventoryStack, int count) {
        AtomicInteger newCount = new AtomicInteger(count);
        List<ItemStack> itemStacks = this.getContents(inventoryStack).filter(stack -> {
            if (WandUtil.stackEquals(stack, itemStack)) {
                int toTake = Math.min(newCount.get(), stack.m_41613_());
                stack.m_41774_(toTake);
                newCount.set(newCount.get() - toTake);
            }
            return !stack.m_41619_();
        }).toList();
        this.setItemList(inventoryStack, itemStacks);
        return newCount.get();
    }

    private Stream<ItemStack> getContents(ItemStack bundleStack) {
        CompoundTag compoundtag = bundleStack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private void setItemList(ItemStack itemStack, List<ItemStack> itemStacks) {
        CompoundTag rootTag = itemStack.m_41784_();
        ListTag listTag = new ListTag();
        rootTag.m_128365_("Items", (Tag)listTag);
        for (ItemStack stack : itemStacks) {
            CompoundTag itemTag = new CompoundTag();
            stack.m_41739_(itemTag);
            listTag.add((Object)itemTag);
        }
    }
}

