/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.addons;

import com.tagnumelite.projecteintegration.api.conversion.AConversionProvider;
import com.tagnumelite.projecteintegration.api.conversion.ConversionProvider;
import com.tagnumelite.projecteintegration.api.recipe.ARecipeTypeMapper;
import com.tagnumelite.projecteintegration.api.recipe.nss.NSSOutput;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.PureInfusionRecipe;
import sirttas.elementalcraft.recipe.SpellCraftRecipe;
import sirttas.elementalcraft.recipe.instrument.CrystallizationRecipe;
import sirttas.elementalcraft.recipe.instrument.InscriptionRecipe;
import sirttas.elementalcraft.recipe.instrument.binding.AbstractBindingRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;
import sirttas.elementalcraft.recipe.instrument.io.sawing.SawingRecipe;

public class ElementalCraftAddon {
    public static final String MODID = "elementalcraft";

    public static String NAME(String name) {
        return "ElementalCraft" + name + "Mapper";
    }

    @ConversionProvider(value="elementalcraft")
    public static class ECConversionProvider
    extends AConversionProvider {
        @Override
        public void convert(CustomConversionBuilder builder) {
            builder.comment("Default conversions for ElementalCraft").before((ItemLike)ECItems.INERT_CRYSTAL.get(), 8L).before((ItemLike)ECItems.AIR_SHARD.get(), 8L).before((ItemLike)ECItems.EARTH_SHARD.get(), 8L).before((ItemLike)ECItems.FIRE_SHARD.get(), 8L).before((ItemLike)ECItems.WATER_SHARD.get(), 8L);
            this.gem(builder, (Item)ECItems.CRUDE_AIR_GEM.get(), (Item)ECItems.FINE_AIR_GEM.get(), (Item)ECItems.AIR_CRYSTAL.get(), (Item)ECItems.AIR_SHARD.get());
            this.gem(builder, (Item)ECItems.CRUDE_EARTH_GEM.get(), (Item)ECItems.FINE_EARTH_GEM.get(), (Item)ECItems.AIR_CRYSTAL.get(), (Item)ECItems.AIR_SHARD.get());
            this.gem(builder, (Item)ECItems.CRUDE_FIRE_GEM.get(), (Item)ECItems.FINE_FIRE_GEM.get(), (Item)ECItems.AIR_CRYSTAL.get(), (Item)ECItems.AIR_SHARD.get());
            this.gem(builder, (Item)ECItems.CRUDE_WATER_GEM.get(), (Item)ECItems.FINE_WATER_GEM.get(), (Item)ECItems.AIR_CRYSTAL.get(), (Item)ECItems.AIR_SHARD.get());
        }

        protected void gem(CustomConversionBuilder builder, Item crudeGem, Item fineGem, Item crystal, Item shard) {
            ((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)builder.conversion((ItemLike)crudeGem)).ingredient((ItemLike)Items.f_42415_)).ingredient((ItemLike)crystal)).ingredient((ItemLike)shard)).end();
            ((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)((CustomConversionBuilder.FixedValueConversionBuilder)builder.conversion((ItemLike)fineGem)).ingredient((ItemLike)Items.f_42415_)).ingredient((ItemLike)crystal)).ingredient((ItemLike)shard)).end();
        }
    }

    @RecipeTypeMapper(requiredMods={"elementalcraft"}, priority=1)
    public static class ECSpellCraftMapper
    extends ARecipeTypeMapper<SpellCraftRecipe> {
        @Override
        public String getName() {
            return ElementalCraftAddon.NAME("SpellCraft");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ECRecipeTypes.SPELL_CRAFT.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"elementalcraft"}, priority=1)
    public static class ECPureInfusionMapper
    extends ARecipeTypeMapper<PureInfusionRecipe> {
        @Override
        public String getName() {
            return ElementalCraftAddon.NAME("PureInfusion");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ECRecipeTypes.PURE_INFUSION.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"elementalcraft"}, priority=1)
    public static class ECSawingMapper
    extends ARecipeTypeMapper<SawingRecipe> {
        @Override
        public String getName() {
            return ElementalCraftAddon.NAME("Sawing");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ECRecipeTypes.SAWING.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"elementalcraft"}, priority=1)
    public static class ECGrindingMapper
    extends ARecipeTypeMapper<IGrindingRecipe> {
        @Override
        public String getName() {
            return ElementalCraftAddon.NAME("Grinding");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ECRecipeTypes.GRINDING.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"elementalcraft"}, priority=1)
    public static class ECInscriptionMapper
    extends ARecipeTypeMapper<InscriptionRecipe> {
        @Override
        public String getName() {
            return ElementalCraftAddon.NAME("Inscription");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ECRecipeTypes.INSCRIPTION.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"elementalcraft"}, priority=1)
    public static class ECCrystallizationMapper
    extends ARecipeTypeMapper<CrystallizationRecipe> {
        @Override
        public String getName() {
            return ElementalCraftAddon.NAME("Crystallization");
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " NOTE: Skips all recipes with more than one output chance";
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ECRecipeTypes.CRYSTALLIZATION.get();
        }

        @Override
        public NSSOutput getOutput(CrystallizationRecipe recipe) {
            if (recipe.getOutputs().size() != 1) {
                return NSSOutput.EMPTY;
            }
            return new NSSOutput(((CrystallizationRecipe.ResultEntry)recipe.getOutputs().get(0)).getResult());
        }
    }

    @RecipeTypeMapper(requiredMods={"elementalcraft"}, priority=1)
    public static class ECBindingMapper
    extends ARecipeTypeMapper<AbstractBindingRecipe> {
        @Override
        public String getName() {
            return ElementalCraftAddon.NAME("Binding");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ECRecipeTypes.BINDING.get();
        }
    }

    @RecipeTypeMapper(requiredMods={"elementalcraft"}, priority=1)
    public static class ECInfusionMapper
    extends ARecipeTypeMapper<IInfusionRecipe> {
        @Override
        public String getName() {
            return ElementalCraftAddon.NAME("Infusion");
        }

        public boolean canHandle(RecipeType<?> recipeType) {
            return recipeType == ECRecipeTypes.INFUSION.get();
        }
    }
}

