/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.Constants;
import com.leobeliik.extremesoundmuffler.SoundMufflerCommon;
import com.leobeliik.extremesoundmuffler.gui.buttons.MuffledSlider;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.leobeliik.extremesoundmuffler.utils.DataManager;
import com.leobeliik.extremesoundmuffler.utils.Tips;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MufflerScreen
extends Screen
implements ISoundLists,
IColorsGui {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static boolean isMuffling = true;
    private static Component toggleSoundsListMessage;
    private static Component screenTitle;
    private static Component tip;
    private final int xSize = 256;
    private final int ySize = 202;
    private final boolean isAnchorsDisabled = CommonConfig.get().disableAnchors().get();
    private int minYButton;
    private int maxYButton;
    private int index;
    private Button btnTMS;
    private Button btnDelete;
    private Button btnCSL;
    private Button btnSetAnchor;
    private Button btnEditAnchor;
    private Button btnNextSounds;
    private Button btnPrevSounds;
    private Button btnAccept;
    private Button btnCancel;
    private Button btnAnchor;
    private EditBox searchBar;
    private EditBox editAnchorTitleBar;
    private EditBox editRadBar;
    private MuffledSlider firstSoundButton;
    private MuffledSlider lastSoundButton;
    private Anchor anchor;

    private MufflerScreen(Component title, Anchor anchor) {
        super(title);
        screenTitle = title;
        this.anchor = anchor;
        minecraft.m_91152_((Screen)this);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.minYButton = this.getY() + 46;
        this.maxYButton = this.getY() + 164;
        this.addButtons();
        this.addSideButtons();
        this.addAnchorButtons();
        this.addSoundListButtons();
    }

    public void m_88315_(@NotNull GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        SoundMufflerCommon.renderGui();
        stack.m_280218_(SoundMufflerCommon.getTextureRL(), this.getX(), this.getY(), 0, 0, 256, 202);
        this.renderSideScreen(stack);
        super.m_88315_(stack, mouseX, mouseY, partialTicks);
        stack.m_280653_(this.f_96547_, screenTitle, this.getX() + 128, this.getY() + 8, 0xFFFFFF);
        this.renderTips(stack);
        this.renderButtons(stack, mouseX, mouseY);
    }

    public void renderBackground(@NotNull GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.editRadBar.m_94153_(s -> s.matches("[0-9]*(?:[0-9]*)?"));
        if (keyCode == 257 || keyCode == 335) {
            this.searchBar.m_93692_(false);
            this.editAnchorTitleBar.m_93692_(false);
            this.editRadBar.m_93692_(false);
            return true;
        }
        if (!(this.searchBar.m_93696_() || this.editAnchorTitleBar.m_93696_() || this.editRadBar.m_93696_() || !MufflerScreen.minecraft.f_91066_.f_92092_.m_90832_(keyCode, scanCode) && !Constants.soundMufflerKey.m_90832_(keyCode, scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.m_93696_()) {
            this.updateButtons();
        }
        if (!this.editRadBar.m_94155_().isEmpty()) {
            int Radius = Integer.parseInt(this.editRadBar.m_94155_());
            this.editRadBar.m_94202_(Radius > 32 || Radius < 1 ? 65535 : 0xFFFFFF);
        } else {
            this.editRadBar.m_94202_(0xFFFFFF);
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double dir) {
        if (this.firstSoundButton == null) {
            return false;
        }
        if (dir > 0.0 && this.firstSoundButton.m_252907_() == this.minYButton || dir < 0.0 && this.lastSoundButton.m_252907_() <= this.maxYButton) {
            return false;
        }
        this.m_6702_().stream().filter(b -> b instanceof MuffledSlider).map(b -> (MuffledSlider)b).forEach(b -> {
            b.m_253211_((int)((double)b.m_252907_() + (double)(b.m_93694_() * 10) * Mth.m_14008_((double)dir, (double)-1.0, (double)1.0)));
            b.isVisible(b.m_252907_() >= this.minYButton && b.m_252907_() <= this.maxYButton);
        });
        return super.m_6050_(mouseX, mouseY, dir);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            if (this.searchBar.m_93696_()) {
                this.searchBar.m_94144_("");
                this.updateButtons();
                return true;
            }
            if (this.editAnchorTitleBar.m_93696_()) {
                this.editAnchorTitleBar.m_94144_("");
                return true;
            }
            if (this.editRadBar.m_198029_()) {
                this.editRadBar.m_94144_("");
                return true;
            }
        } else {
            this.searchBar.m_93692_(this.searchBar.m_5953_(mouseX, mouseY));
            this.editAnchorTitleBar.m_93692_(this.editAnchorTitleBar.m_5953_(mouseX, mouseY));
            this.editRadBar.m_93692_(this.editRadBar.m_5953_(mouseX, mouseY));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7379_() {
        DataManager.saveData();
        super.m_7379_();
    }

    private void open(Component title, Anchor anchor) {
        new MufflerScreen(title, anchor);
    }

    public static void open() {
        new MufflerScreen((Component)Component.m_237115_((String)"main_screen.main_title"), null);
    }

    private void addButtons() {
        this.btnCSL = Button.m_253074_((Component)Component.m_237115_((String)"main_screen.btn.csl.recent"), b -> {
            boolean isAnchorMuffling = this.anchor != null && !this.anchor.getMuffledSounds().isEmpty();
            Component component = this.btnCSL.m_6035_();
            toggleSoundsListMessage = Component.m_237115_((String)"main_screen.btn.csl.recent").equals((Object)component) ? Component.m_237115_((String)"main_screen.btn.csl.all") : (Component.m_237115_((String)"main_screen.btn.csl.all").equals((Object)component) ? Component.m_237115_((String)"main_screen.btn.csl.muffled") : Component.m_237115_((String)"main_screen.btn.csl.recent"));
            b.m_93666_(toggleSoundsListMessage);
            this.updateButtons();
        }).m_252987_(this.getX() + 13, this.getY() + 181, 52, 13).m_253136_();
        this.m_7787_((GuiEventListener)this.btnCSL);
        this.searchBar = new EditBox(this.f_96547_, this.getX() + 74, this.getY() + 183, 119, 13, (Component)Component.m_237119_());
        ((EditBox)this.m_142416_((GuiEventListener)this.searchBar)).m_94182_(false);
        this.btnTMS = Button.m_253074_((Component)Component.m_237115_((String)"main_screen.btn.tms.stop"), b -> {
            isMuffling = !isMuffling;
        }).m_252987_(this.getX() + 229, this.getY() + 180, 17, 17).m_253136_();
        this.m_7787_((GuiEventListener)this.btnTMS);
        this.btnDelete = Button.m_253074_((Component)Component.m_237115_((String)"main_screen.btn.delete.sounds"), b -> {
            if (MufflerScreen.m_96638_()) {
                recentSoundsList.clear();
            } else if (this.anchor == null) {
                muffledSounds.clear();
            } else {
                this.anchor.deleteAnchor();
            }
            this.updateButtons();
        }).m_252987_(this.getX() + 205, this.getY() + 180, 17, 17).m_253136_();
        this.m_7787_((GuiEventListener)this.btnDelete);
        this.btnPrevSounds = Button.m_253074_((Component)Component.m_237119_(), b -> this.m_6050_(0.0, 0.0, 1.0)).m_252987_(this.getX() + 10, this.getY() + 22, 13, 20).m_253136_();
        this.m_7787_((GuiEventListener)this.btnPrevSounds);
        this.btnNextSounds = Button.m_253074_((Component)Component.m_237119_(), b -> this.m_6050_(0.0, 0.0, -1.0)).m_252987_(this.getX() + 233, this.getY() + 22, 13, 20).m_253136_();
        this.m_7787_((GuiEventListener)this.btnNextSounds);
    }

    private void addSideButtons() {
        this.btnSetAnchor = Button.m_253074_((Component)Component.m_237119_(), b -> this.anchor.setAnchor()).m_252987_(this.getX() + 261, this.getY() + 62, 11, 11).m_253136_();
        ((Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), b -> this.anchor.setAnchor()).m_252987_(this.getX() + 261, this.getY() + 62, 11, 11).m_253136_())).f_93623_ = false;
        this.btnEditAnchor = Button.m_253074_((Component)Component.m_237119_(), b -> this.editTitle()).m_252987_(this.getX() + 275, this.getY() + 62, 11, 11).m_253136_();
        ((Button)this.m_7787_((GuiEventListener)Button.m_253074_((Component)Component.m_237119_(), b -> this.editTitle()).m_252987_(this.getX() + 275, this.getY() + 62, 11, 11).m_253136_())).f_93623_ = false;
        this.editAnchorTitleBar = new EditBox(this.f_96547_, this.getX() + 302, this.btnEditAnchor.m_252907_() + 20, 84, 11, (Component)Component.m_237119_());
        ((EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.getX() + 302, this.btnEditAnchor.m_252907_() + 20, 84, 11, (Component)Component.m_237119_()))).f_93624_ = false;
        this.editRadBar = new EditBox(this.f_96547_, this.getX() + 302, this.editAnchorTitleBar.m_252907_() + 15, 30, 11, (Component)Component.m_237119_());
        ((EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.getX() + 302, this.editAnchorTitleBar.m_252907_() + 15, 30, 11, (Component)Component.m_237119_()))).f_93624_ = false;
        this.btnAccept = Button.m_253074_((Component)Component.m_237115_((String)"main_screen.btn.accept"), b -> {
            if (!this.editAnchorTitleBar.m_94155_().isEmpty() && !this.editRadBar.m_94155_().isEmpty() && this.anchor != null) {
                this.anchor.editAnchor(this.editAnchorTitleBar.m_94155_(), Mth.m_14045_((int)Integer.parseInt(this.editRadBar.m_94155_()), (int)1, (int)32));
                screenTitle = Component.m_130674_((String)this.editAnchorTitleBar.m_94155_());
                this.editTitle();
            }
        }).m_252987_(this.getX() + 259, this.editRadBar.m_252907_() + 15, 40, 20).m_253136_();
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"main_screen.btn.accept"), b -> {
            if (!this.editAnchorTitleBar.m_94155_().isEmpty() && !this.editRadBar.m_94155_().isEmpty() && this.anchor != null) {
                this.anchor.editAnchor(this.editAnchorTitleBar.m_94155_(), Mth.m_14045_((int)Integer.parseInt(this.editRadBar.m_94155_()), (int)1, (int)32));
                screenTitle = Component.m_130674_((String)this.editAnchorTitleBar.m_94155_());
                this.editTitle();
            }
        }).m_252987_(this.getX() + 259, this.editRadBar.m_252907_() + 15, 40, 20).m_253136_())).f_93624_ = false;
        this.btnCancel = Button.m_253074_((Component)Component.m_237115_((String)"main_screen.btn.cancel"), b -> this.editTitle()).m_252987_(this.getX() + 300, this.editRadBar.m_252907_() + 15, 40, 20).m_253136_();
        ((Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"main_screen.btn.cancel"), b -> this.editTitle()).m_252987_(this.getX() + 300, this.editRadBar.m_252907_() + 15, 40, 20).m_253136_())).f_93624_ = false;
    }

    private void addAnchorButtons() {
        int buttonW = this.getX() + 30;
        for (int i = 0; i <= 9; ++i) {
            if (this.isAnchorsDisabled) {
                String[] disabledMsg = new String[]{"-", "D", "i", "s", "a", "b", "l", "e", "d", "-"};
                this.btnAnchor = Button.m_253074_((Component)Component.m_130674_((String)disabledMsg[i]), b -> {}).m_252987_(buttonW, this.getY() + 24, 16, 16).m_253136_();
                this.btnAnchor.f_93623_ = false;
            } else {
                int finalI = i;
                this.btnAnchor = Button.m_253074_((Component)Component.m_130674_((String)String.valueOf(i)), b -> {
                    this.anchor = (Anchor)anchorList.get(finalI);
                    this.hideSideButtons();
                    if (screenTitle.getString().equals(this.anchor.getName())) {
                        this.anchor = null;
                        screenTitle = Component.m_237115_((String)"main_screen.main_title");
                    } else {
                        screenTitle = Component.m_130674_((String)this.anchor.getName());
                        this.btnSetAnchor.f_93623_ = true;
                    }
                    this.updateButtons();
                }).m_252987_(buttonW, this.getY() + 24, 16, 16).m_253136_();
            }
            ((Button)this.m_142416_((GuiEventListener)this.btnAnchor)).m_93650_(0.0f);
            buttonW += 20;
        }
    }

    private void addSoundListButtons() {
        int bx;
        int by;
        block15: {
            block14: {
                by = this.minYButton;
                bx = CommonConfig.get().leftButtons().get() != false ? this.getX() + 36 : this.getX() + 11;
                this.firstSoundButton = null;
                soundsList.clear();
                Component component = this.btnCSL.m_6035_();
                if (Component.m_237115_((String)"main_screen.btn.csl.recent").equals((Object)component)) {
                    soundsList.addAll(recentSoundsList);
                    Collections.reverse(soundsList);
                } else if (Component.m_237115_((String)"main_screen.btn.csl.all").equals((Object)component)) {
                    BuiltInRegistries.f_256894_.forEach(k -> soundsList.add(k.m_11660_()));
                    Collections.sort(soundsList);
                } else {
                    soundsList.addAll(this.anchor == null ? muffledSounds.keySet() : this.anchor.getMuffledSounds().keySet());
                }
                if (CommonConfig.get().lawfulAllList().get().booleanValue() && this.btnCSL.m_6035_().equals(Component.m_237115_((String)"main_screen.btn.csl.all"))) break block14;
                if (!this.btnCSL.m_6035_().equals(Component.m_237115_((String)"main_screen.btn.csl.recent"))) break block15;
            }
            forbiddenSounds.stream().map(fs -> sl -> sl.toString().contains((CharSequence)fs)).forEach(soundsList::removeIf);
        }
        if (soundsList.isEmpty()) {
            return;
        }
        for (ResourceLocation sound : soundsList) {
            if (!sound.toString().contains(this.searchBar.m_94155_())) continue;
            double volume = this.anchor == null ? (muffledSounds.get(sound) == null ? 1.0 : (Double)muffledSounds.get(sound)) : (this.anchor.getMuffledSounds().get(sound) == null ? 1.0 : (Double)this.anchor.getMuffledSounds().get(sound));
            int bg = this.m_6702_().size() % 2 == 0 ? darkBG : brightBG;
            MuffledSlider btnSound = new MuffledSlider(bx, by, bg, sound, volume, this);
            if (this.anchor != null) {
                this.setFGColor(btnSound, this.anchor.getMuffledSounds().containsKey(sound) ? "aqua" : "white");
            } else if (!muffledSounds.isEmpty()) {
                this.setFGColor(btnSound, muffledSounds.containsKey(sound) ? "aqua" : "white");
            } else {
                this.setFGColor(btnSound, "white");
            }
            this.m_142416_((GuiEventListener)btnSound);
            by += btnSound.m_93694_();
            btnSound.isVisible(btnSound.m_252907_() < this.maxYButton);
            if (this.firstSoundButton == null) {
                this.firstSoundButton = btnSound;
            }
            this.lastSoundButton = btnSound;
        }
    }

    private void updateButtons() {
        Iterator iterator = this.m_6702_().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MuffledSlider)) continue;
            MuffledSlider button = (MuffledSlider)e;
            button.isVisible(false);
            iterator.remove();
        }
        this.addSoundListButtons();
    }

    private void renderButtons(GuiGraphics stack, int mouseX, int mouseY) {
        boolean notMuffling;
        MutableComponent message;
        if (isMuffling) {
            stack.m_280163_(SoundMufflerCommon.getTextureRL(), this.btnTMS.m_252754_() + 1, this.btnTMS.m_252907_(), 54.0f, 202.0f, 15, 15, 256, 256);
        }
        MutableComponent mutableComponent = message = isMuffling ? Component.m_237115_((String)"main_screen.btn.tms.stop") : Component.m_237115_((String)"main_screen.btn.tms.start");
        if (this.btnTMS.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnTMS);
        }
        MutableComponent mutableComponent2 = message = this.anchor == null ? Component.m_237115_((String)"main_screen.btn.delete.sounds") : Component.m_237115_((String)"main_screen.btn.delete.anchor");
        if (MufflerScreen.m_96638_()) {
            stack.m_280163_(SoundMufflerCommon.getTextureRL(), this.btnDelete.m_252754_() + 2, this.btnDelete.m_252907_() + 1, 54.0f, 217.0f, 13, 13, 256, 256);
            message = Component.m_237115_((String)"main_screen.btn.delete.list");
        }
        if (this.btnDelete.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnDelete);
        }
        MutableComponent searchHint = Component.m_237115_((String)"gui.recipebook.search_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
        if (!this.searchBar.m_93696_() && this.searchBar.m_94155_().isEmpty()) {
            stack.m_280430_(this.f_96547_, (Component)searchHint, this.searchBar.m_252754_() + 1, this.searchBar.m_252907_() + 1, -1);
        }
        boolean bl = notMuffling = this.anchor == null ? muffledSounds.isEmpty() : this.anchor.getMuffledSounds().isEmpty();
        if (notMuffling && this.btnCSL.m_6035_().equals(Component.m_237115_((String)"main_screen.btn.csl.muffled"))) {
            MutableComponent text = Component.m_237115_((String)"main_screen.empty").m_6881_().m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
            stack.m_280653_(this.f_96547_, (Component)text, this.getX() + 128, this.getY() + 101, 0xFFFFFF);
        }
        float centerX = (float)this.btnCSL.m_252754_() + (float)this.btnCSL.m_5711_() / 2.0f - (float)this.f_96547_.m_92895_(this.btnCSL.m_6035_().getString()) / 2.0f;
        stack.m_280056_(this.f_96547_, this.btnCSL.m_6035_().getString(), (int)centerX, this.btnCSL.m_252907_() + 3, 0, false);
        message = Component.m_237110_((String)"main_screen.btn.csl.tooltip", (Object[])new Object[]{this.btnCSL.m_6035_().getString()});
        if (this.btnCSL.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnCSL);
        }
        message = Component.m_237115_((String)"main_screen.btn.next_sounds");
        if (this.btnNextSounds.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnNextSounds);
        }
        message = Component.m_237115_((String)"main_screen.btn.previous_sounds");
        if (this.btnPrevSounds.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnPrevSounds);
        }
        if (mouseX > this.getX() + 30 && mouseX < this.btnAnchor.m_252754_() + this.btnAnchor.m_5711_() && mouseY > this.btnAnchor.m_252907_() && mouseY < this.btnAnchor.m_252907_() + this.btnAnchor.m_93694_() && CommonConfig.get().disableAnchors().get().booleanValue()) {
            stack.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"main_screen.btn.anchors.disabled"), this.getX() + 60, this.getY() + 40);
        }
        for (GuiEventListener widget : this.m_6702_()) {
            if (!(widget instanceof AbstractWidget)) continue;
            AbstractWidget btn = (AbstractWidget)widget;
            if (btn instanceof MuffledSlider) {
                if (this.anchor == null || this.anchor.getAnchorPos() != null || !((MuffledSlider)widget).getBtnToggleSound().m_5953_((double)mouseX, (double)mouseY)) continue;
                this.renderButtonTooltip(stack, (Component)Component.m_237115_((String)"main_screen.btn.anchors.set_message"), (AbstractWidget)((MuffledSlider)widget).getBtnToggleSound());
                continue;
            }
            if (!btn.m_6035_().getString().matches("[0-9]") || anchorList.isEmpty()) continue;
            String color = ((Anchor)anchorList.get(Integer.parseInt(btn.m_6035_().getString()))).getAnchorPos() != null ? "green" : "white";
            this.setFGColor(btn, color);
            if (this.anchor == null || !btn.m_6035_().getString().equals(String.valueOf(this.anchor.getAnchorId()))) continue;
            stack.m_280163_(SoundMufflerCommon.getTextureRL(), btn.m_252754_() - 5, btn.m_252907_() - 2, 71.0f, 202.0f, 27, 22, 256, 256);
        }
        if (this.editRadBar.m_198029_()) {
            this.renderButtonTooltip(stack, (Component)Component.m_237115_((String)"main_screen.btn.anchors.set_range"), (AbstractWidget)this.editRadBar);
        }
        if (this.editAnchorTitleBar.m_198029_()) {
            this.renderButtonTooltip(stack, (Component)Component.m_237115_((String)"main_screen.btn.anchors.set_title"), (AbstractWidget)this.editAnchorTitleBar);
        }
        if (this.btnSetAnchor.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)Component.m_237115_((String)"main_screen.btn.anchors.set"), (AbstractWidget)this.btnSetAnchor);
        }
        if (this.btnEditAnchor.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)Component.m_237115_((String)"main_screen.btn.anchors.edit"), (AbstractWidget)this.btnEditAnchor);
        }
    }

    private void renderSideScreen(GuiGraphics stack) {
        String Radius;
        if (this.anchor == null) {
            return;
        }
        String dimensionName = "";
        int x = this.btnSetAnchor.m_252754_();
        int y = this.btnSetAnchor.m_252907_();
        int stringW = this.f_96547_.m_92852_((FormattedText)Component.m_237115_((String)"main_screen.side_screen.dimension"));
        String string = Radius = this.anchor.getRadius() == 0 ? "" : String.valueOf(this.anchor.getRadius());
        if (this.anchor.getDimension() != null) {
            stringW += this.f_96547_.m_92895_(this.anchor.getDimension().m_135815_());
            dimensionName = this.anchor.getDimension().m_135815_();
        }
        stack.m_280509_(x - 5, y - 57, x + stringW + 7, y + 17, whiteBG);
        stack.m_280509_(x - 5, y - 56, x + stringW + 6, y + 16, darkBG);
        stack.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"main_screen.side_screen.x", (Object[])new Object[]{this.anchor.getX()}), x + 1, y - 50, 0xFFFFFF);
        stack.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"main_screen.side_screen.y", (Object[])new Object[]{this.anchor.getY()}), x + 1, y - 40, 0xFFFFFF);
        stack.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"main_screen.side_screen.z", (Object[])new Object[]{this.anchor.getZ()}), x + 1, y - 30, 0xFFFFFF);
        stack.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"main_screen.side_screen.radius", (Object[])new Object[]{Radius}), x + 1, y - 20, 0xFFFFFF);
        stack.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"main_screen.side_screen.dimension", (Object[])new Object[]{dimensionName}), x + 1, y - 10, 0xFFFFFF);
        SoundMufflerCommon.renderGui();
        stack.m_280163_(SoundMufflerCommon.getTextureRL(), x, y, 0.0f, 69.45f, 11, 11, 88, 88);
        if (this.anchor.getAnchorPos() != null) {
            this.btnEditAnchor.f_93623_ = true;
            stack.m_280163_(SoundMufflerCommon.getTextureRL(), this.btnEditAnchor.m_252754_(), this.btnEditAnchor.m_252907_(), 32.0f, 213.0f, 11, 11, 256, 256);
        } else {
            this.btnEditAnchor.f_93623_ = false;
        }
        x = this.btnSetAnchor.m_252754_();
        y = this.editAnchorTitleBar.m_252907_();
        if (this.editRadBar.f_93624_) {
            stack.m_280509_(x + stringW + 7, y - 5, this.editAnchorTitleBar.m_252754_() + this.editAnchorTitleBar.m_5711_() + 4, this.btnAccept.m_252907_() + 23, whiteBG);
            stack.m_280509_(x - 5, this.btnAccept.m_252907_() + 23, this.editAnchorTitleBar.m_252754_() + this.editAnchorTitleBar.m_5711_() + 4, this.btnAccept.m_252907_() + 24, whiteBG);
            stack.m_280509_(x - 6, y - 4, this.editAnchorTitleBar.m_252754_() + this.editAnchorTitleBar.m_5711_() + 3, this.btnAccept.m_252907_() + 23, darkBG);
            stack.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"main_screen.side_screen.title"), x - 2, y + 1, 0xFFFFFF);
            stack.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"main_screen.side_screen.radius_edit"), x - 2, this.editRadBar.m_252907_() + 1, 0xFFFFFF);
        }
    }

    private void renderButtonTooltip(GuiGraphics stack, Component message, AbstractWidget button) {
        int CSLShift = button.equals(this.btnCSL) ? 25 : 0;
        int centeredMessageX = button.m_252754_() - (this.f_96547_.m_92852_((FormattedText)message) - CSLShift) / 2;
        int centeredMessageY = button.equals(this.btnPrevSounds) || button.equals(this.btnNextSounds) ? button.m_252907_() - 1 : button.m_252907_() + button.m_93694_() + 16;
        stack.m_280557_(this.f_96547_, message, centeredMessageX, centeredMessageY);
    }

    private void renderTips(GuiGraphics stack) {
        if (CommonConfig.get().showTip().get().booleanValue()) {
            if (this.index % 500 == 0) {
                tip = Component.m_237115_((String)Tips.randomTip());
                this.index = 0;
            }
            Objects.requireNonNull(this.f_96547_);
            int h = 9 * (this.f_96547_.m_92852_((FormattedText)Component.m_237110_((String)"main_screen.tip", (Object[])new Object[]{tip})) / 240 + 1) + 215;
            stack.m_280509_(this.getX() - 2, this.getY() + 208, this.getX() + 257, this.getY() + h + 2, darkBG);
            stack.m_280509_(this.getX() - 1, this.getY() + 209, this.getX() + 256, this.getY() + h + 1, goldBG);
            stack.m_280509_(this.getX(), this.getY() + 210, this.getX() + 255, this.getY() + h, darkBG);
            stack.m_280554_(this.f_96547_, (FormattedText)Component.m_237110_((String)"main_screen.tip", (Object[])new Object[]{tip}), this.getX() + 5, this.getY() + 213, 245, 0xFFFFFF);
            ++this.index;
        }
    }

    private void hideSideButtons() {
        this.btnSetAnchor.f_93623_ = false;
        this.btnEditAnchor.f_93623_ = false;
        this.editAnchorTitleBar.f_93624_ = false;
        this.editRadBar.f_93624_ = false;
        this.btnAccept.f_93624_ = false;
        this.btnCancel.f_93624_ = false;
    }

    private void editTitle() {
        this.editAnchorTitleBar.m_94144_(this.anchor.getName());
        this.editAnchorTitleBar.f_93624_ = !this.editAnchorTitleBar.f_93624_;
        this.editRadBar.m_94144_(String.valueOf(this.anchor.getRadius()));
        this.editRadBar.f_93624_ = !this.editRadBar.f_93624_;
        this.btnAccept.f_93624_ = !this.btnAccept.f_93624_;
        this.btnCancel.f_93624_ = !this.btnCancel.f_93624_;
        this.editRadBar.m_94202_(0xFFFFFF);
    }

    public boolean removeSoundMuffled(ResourceLocation sound) {
        if (this.anchor != null) {
            if (this.anchor.getAnchorPos() != null) {
                this.anchor.removeSound(sound);
                return true;
            }
        } else {
            muffledSounds.remove(sound);
            return true;
        }
        return false;
    }

    public boolean addSoundMuffled(ResourceLocation sound, double volume) {
        if (this.anchor != null) {
            if (this.anchor.getAnchorPos() != null) {
                this.anchor.addSound(sound, volume);
                return true;
            }
        } else {
            muffledSounds.put(sound, volume);
            return true;
        }
        return false;
    }

    public void replaceVolume(ResourceLocation sound, double volume) {
        if (this.anchor != null) {
            this.anchor.replaceSound(sound, volume);
        } else {
            muffledSounds.replace(sound, volume);
        }
    }

    public static boolean isMuffling() {
        return isMuffling;
    }

    private int getX() {
        return (this.f_96543_ - 256) / 2;
    }

    private int getY() {
        return (this.f_96544_ - 202) / 2;
    }

    public Component getBtnCSLTitle() {
        return this.btnCSL.m_6035_();
    }
}

