/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.screen.text;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.moddingx.libx.impl.screen.text.TextScreenContent;
import org.moddingx.libx.render.RenderHelper;
import org.moddingx.libx.screen.text.ComponentLayout;

public class TextScreen
extends Screen {
    private final ComponentLayout layout;
    private final int displayWidth;
    @Nullable
    private TextScreenContent content;

    public TextScreen(ComponentLayout layout) {
        this(layout, 176);
    }

    public TextScreen(ComponentLayout layout, int width) {
        super(Optional.ofNullable(layout.title()).orElse((Component)Component.m_237119_()));
        this.layout = layout;
        this.displayWidth = width;
        this.content = null;
    }

    private int left() {
        if (this.content == null) {
            return 0;
        }
        return (this.f_96543_ - this.content.width()) / 2;
    }

    private int top() {
        if (this.content == null) {
            return 0;
        }
        return (this.f_96544_ - this.content.height()) / 2;
    }

    protected void m_7856_() {
        this.content = new TextScreenContent(this.f_96547_, this.displayWidth, this.layout.alignComponents(this.f_96547_, this.displayWidth));
        this.content.addWidgets(this.left(), this.top(), x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        if (this.content == null) {
            return;
        }
        int left = this.left();
        int top = this.top();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 20.0f);
        this.drawBackground(graphics, left - 10, top - 10, this.content.width() + 20, this.content.height() + 20, partialTick);
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        this.content.render(graphics, left, top);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        Style tooltip = this.content.hoveredStyle(mouseX - left, mouseY - top);
        if (tooltip != null) {
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 20.0f);
            RenderHelper.resetColor();
            graphics.m_280304_(this.f_96547_, tooltip, mouseX, mouseY);
        }
        graphics.m_280168_().m_85849_();
    }

    protected void drawBackground(GuiGraphics graphics, int x, int y, int width, int height, float partialTick) {
        RenderHelper.renderGuiBackground(graphics, x, y, width, height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Style click;
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.content != null && (click = this.content.hoveredStyle((int)mouseX - this.left(), (int)mouseY - this.top())) != null) {
            return this.m_5561_(click);
        }
        return false;
    }

    protected void m_6697_(@Nonnull String text, boolean overwrite) {
        Minecraft.m_91087_().m_91326_(text);
    }
}

