/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.loot.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class AdditionLootModifier
extends LootModifier {
    public static final Codec<AdditionLootModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(lm -> lm.table), (App)ResourceLocation.f_135803_.optionalFieldOf("random_sequence").forGetter(lm -> lm.randomSequence), (App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions)).apply((Applicative)instance, AdditionLootModifier::new));
    private final ResourceLocation table;
    private final Optional<ResourceLocation> randomSequence;

    public AdditionLootModifier(ResourceLocation table, LootItemCondition ... conditions) {
        this(table, Optional.empty(), conditions);
    }

    public AdditionLootModifier(ResourceLocation table, ResourceLocation randomSequence, LootItemCondition ... conditions) {
        this(table, Optional.of(randomSequence), conditions);
    }

    private AdditionLootModifier(ResourceLocation table, Optional<ResourceLocation> randomSequence, LootItemCondition ... conditions) {
        super(conditions);
        this.table = table;
        this.randomSequence = randomSequence;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> loot, LootContext context) {
        LootTable table = context.m_278643_().m_278676_(this.table);
        LootContext copy = new LootContext.Builder(context).withQueriedLootTableId(this.table).m_287259_((ResourceLocation)this.randomSequence.orElse(null));
        ObjectArrayList stacks = table.m_230922_(copy);
        loot.addAll((ObjectList)stacks);
        return loot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

