/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.BrushableBlockEntityAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BuryLootGoal
extends Goal {
    private static final double MAX_ALLOWED_SQR_DISTANCE_TO_TARGET = 100.0;
    private final SandSnapperEntity sandSnapper;
    @Nullable
    private final PathNavigation pathNav;
    private Vec3 targetPos;
    private final int buryingDuration;
    private int buryingTimer;
    private final int xzRange;
    private final int yRange;
    private boolean isDone;

    public BuryLootGoal(SandSnapperEntity sandSnapper, int xzRange, int yRange, int buryingDuration) {
        this.sandSnapper = sandSnapper;
        this.pathNav = sandSnapper.m_21573_();
        this.buryingDuration = buryingDuration;
        this.xzRange = xzRange;
        this.yRange = yRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.sandSnapper.carryingItem.m_41619_() || this.isDone) {
            return false;
        }
        this.targetPos = this.findTargetPos();
        return this.targetPos != null;
    }

    public boolean m_8045_() {
        if (this.isDone) {
            return false;
        }
        if (!this.isBlockAValidTarget(BlockPos.m_274446_((Position)this.targetPos).m_7495_())) {
            this.popItem();
            this.isDone = true;
            return false;
        }
        return this.buryingTimer > 0 || this.sandSnapper.m_20238_(this.targetPos) < 100.0;
    }

    public void m_8056_() {
        this.isDone = false;
    }

    public void m_8041_() {
        this.sandSnapper.setForceSpawnDigParticles(false);
        this.buryingTimer = 0;
        this.isDone = false;
    }

    public void m_8037_() {
        if (this.isDone) {
            return;
        }
        if (this.buryingTimer > 0) {
            --this.buryingTimer;
            if (this.buryingTimer == 0) {
                BlockState blockStateOn = this.sandSnapper.m_20075_();
                if (blockStateOn.m_60713_(Blocks.f_49992_)) {
                    this.sandSnapper.m_9236_().m_7605_((Entity)this.sandSnapper, (byte)8);
                    this.sandSnapper.m_9236_().m_7731_(this.sandSnapper.m_20097_(), Blocks.f_271439_.m_49966_(), 3);
                    this.sandSnapper.m_9236_().m_141902_(this.sandSnapper.m_20097_(), BlockEntityType.f_271323_).ifPresentOrElse(blockEntity -> {
                        ((BrushableBlockEntityAccessor)blockEntity).setItem(this.sandSnapper.carryingItem);
                        this.sandSnapper.carryingItem = ItemStack.f_41583_;
                    }, this::popItem);
                } else if (blockStateOn.m_60713_((Block)BlockModule.ANCIENT_SAND.get())) {
                    this.sandSnapper.m_9236_().m_7605_((Entity)this.sandSnapper, (byte)9);
                    this.sandSnapper.m_9236_().m_7731_(this.sandSnapper.m_20097_(), ((Block)BlockModule.SUSPICIOUS_ANCIENT_SAND.get()).m_49966_(), 3);
                    this.sandSnapper.m_9236_().m_141902_(this.sandSnapper.m_20097_(), (BlockEntityType)EntityTypeModule.SUSPICIOUS_ANCIENT_SAND.get()).ifPresentOrElse(blockEntity -> {
                        blockEntity.setItem(this.sandSnapper.carryingItem);
                        this.sandSnapper.carryingItem = ItemStack.f_41583_;
                    }, this::popItem);
                } else if (blockStateOn.m_60713_(Blocks.f_49994_)) {
                    this.sandSnapper.m_9236_().m_7605_((Entity)this.sandSnapper, (byte)10);
                    this.sandSnapper.m_9236_().m_7731_(this.sandSnapper.m_20097_(), Blocks.f_276445_.m_49966_(), 3);
                    this.sandSnapper.m_9236_().m_141902_(this.sandSnapper.m_20097_(), BlockEntityType.f_271323_).ifPresentOrElse(blockEntity -> {
                        ((BrushableBlockEntityAccessor)blockEntity).setItem(this.sandSnapper.carryingItem);
                        this.sandSnapper.carryingItem = ItemStack.f_41583_;
                    }, this::popItem);
                } else {
                    this.popItem();
                }
                this.isDone = true;
            } else if (this.buryingTimer == this.buryingDuration / 2) {
                this.sandSnapper.setForceSpawnDigParticles(true);
            }
        } else if (!this.sandSnapper.m_20183_().equals((Object)BlockPos.m_274446_((Position)this.targetPos))) {
            double sqrDist = this.sandSnapper.m_20182_().m_82557_(this.targetPos);
            if (sqrDist > 4.0 && this.pathNav != null) {
                this.pathNav.m_26519_(this.targetPos.m_7096_(), this.targetPos.m_7098_(), this.targetPos.m_7094_(), 1.0);
            } else {
                this.sandSnapper.m_21566_().m_6849_(this.targetPos.m_7096_(), this.targetPos.m_7098_(), this.targetPos.m_7094_(), 1.0);
            }
        } else {
            this.buryingTimer = this.buryingDuration;
            if (this.pathNav != null) {
                this.pathNav.m_26573_();
            }
            if (!this.sandSnapper.isSubmerged() && !this.sandSnapper.isDiggingDown() && !this.sandSnapper.isDiving() && this.sandSnapper.canSubmerge(true)) {
                this.sandSnapper.setSubmerged(true);
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    @Nullable
    private Vec3 findTargetPos() {
        return BlockPos.m_121930_((BlockPos)this.sandSnapper.m_20097_(), (int)this.xzRange, (int)this.yRange, this::isBlockAValidTarget).map(BlockPos::m_7494_).map(pos -> new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5)).orElse(null);
    }

    private boolean isBlockAValidTarget(BlockPos blockPos) {
        Block block = this.sandSnapper.m_9236_().m_8055_(blockPos).m_60734_();
        return (block == Blocks.f_49992_ || block == BlockModule.ANCIENT_SAND.get() || block == Blocks.f_49994_) && this.sandSnapper.m_9236_().m_8055_(blockPos.m_7494_()).m_60795_();
    }

    private void popItem() {
        if (!this.sandSnapper.carryingItem.m_41619_()) {
            BlockPos spawnPos = this.sandSnapper.m_20183_();
            double x = (double)spawnPos.m_123341_() + 0.5;
            double y = (double)spawnPos.m_123342_() + 0.5 - (double)(EntityType.f_20461_.m_20679_() / 2.0f);
            double z = (double)spawnPos.m_123343_() + 0.5;
            RandomSource random = this.sandSnapper.m_217043_();
            double xOffset = Mth.m_216263_((RandomSource)random, (double)0.0, (double)0.2);
            double yOffset = 0.2;
            double zOffset = Mth.m_216263_((RandomSource)random, (double)0.0, (double)0.2);
            double dx = Mth.m_216263_((RandomSource)random, (double)0.0, (double)0.05);
            double dy = 0.2;
            double dz = Mth.m_216263_((RandomSource)random, (double)0.0, (double)0.05);
            if (random.m_188499_()) {
                xOffset *= -1.0;
                dx *= -1.0;
            }
            if (random.m_188499_()) {
                zOffset *= -1.0;
                dz *= -1.0;
            }
            ItemEntity itemEntity = new ItemEntity(this.sandSnapper.m_9236_(), x += xOffset, y += yOffset, z += zOffset, this.sandSnapper.carryingItem, dx, dy, dz);
            itemEntity.m_32060_();
            this.sandSnapper.m_9236_().m_7967_((Entity)itemEntity);
            this.sandSnapper.carryingItem = ItemStack.f_41583_;
        }
    }
}

