/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.salju.trialstowers.block.TrialSpawnerEntity;
import net.salju.trialstowers.init.TrialsBlockEntities;
import net.salju.trialstowers.init.TrialsProperties;

public class TrialSpawnerBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = TrialsProperties.ACTIVE;
    public static final BooleanProperty EJECT = TrialsProperties.EJECT;
    public static final BooleanProperty CURSED = TrialsProperties.CURSED;

    public TrialSpawnerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EJECT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CURSED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
        builder.m_61104_(new Property[]{EJECT});
        builder.m_61104_(new Property[]{CURSED});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rez) {
        BlockEntity entity = world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (entity instanceof TrialSpawnerEntity) {
            TrialSpawnerEntity target = (TrialSpawnerEntity)entity;
            if (player.m_7500_() && stack.m_41720_() instanceof SpawnEggItem) {
                target.setEgg(stack);
                target.updateBlock();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult rez, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TrialSpawnerEntity) {
            TrialSpawnerEntity target = (TrialSpawnerEntity)blockEntity;
            ItemStack stack = super.getCloneItemStack(state, rez, world, pos, player);
            stack.m_41700_("BlockEntityTag", (Tag)target.m_5995_());
            return stack;
        }
        return super.getCloneItemStack(state, rez, world, pos, player);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity entity;
        super.m_6402_(world, pos, state, livingEntity, stack);
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag") && (entity = world.m_7702_(pos)) instanceof TrialSpawnerEntity) {
            TrialSpawnerEntity spawnerEntity = (TrialSpawnerEntity)entity;
            spawnerEntity.m_142466_(stack.m_41783_().m_128469_("BlockEntityTag"));
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int i, int e) {
        return world.m_7702_(pos) == null ? super.m_8133_(state, world, pos, i, e) : world.m_7702_(pos).m_7531_(i, e);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrialSpawnerEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return TrialSpawnerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TrialsBlockEntities.SPAWNER.get()), TrialSpawnerEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isActive(BlockState state) {
        return (Boolean)state.m_61143_((Property)ACTIVE);
    }

    public boolean isEjecting(BlockState state) {
        return (Boolean)state.m_61143_((Property)EJECT);
    }

    public boolean isCursed(BlockState state) {
        return (Boolean)state.m_61143_((Property)CURSED);
    }
}

