/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.Blocks;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.event.PlayerAttemptLearnEvent;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.items.IFireProtector;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Util {
    public static final UUID DUMMY_UUID = new UUID(0L, 0L);

    @Nullable
    public static ServerPlayer getPlayer(UUID uuid) {
        return ServerLifecycleHooks.getCurrentServer() == null ? null : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
    }

    @Nullable
    public static ServerPlayer getPlayer(@Nullable Level level, UUID uuid) {
        return level == null || level.m_7654_() == null ? null : level.m_7654_().m_6846_().m_11259_(uuid);
    }

    public static ItemStack cleanStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        if (stackCopy.m_41763_()) {
            stackCopy.m_41721_(0);
        }
        return NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)stackCopy)).createStack();
    }

    public static AddKnowledgeResult addKnowledge(Player player, IKnowledgeProvider provider, Item rawItem, Item cleanItem) {
        return Util.addKnowledge(player, provider, ItemInfo.fromItem((ItemLike)rawItem), ItemInfo.fromItem((ItemLike)cleanItem));
    }

    public static AddKnowledgeResult addKnowledge(Player player, IKnowledgeProvider provider, ItemStack rawStack, ItemStack cleanStack) {
        return Util.addKnowledge(player, provider, ItemInfo.fromStack((ItemStack)rawStack), ItemInfo.fromStack((ItemStack)cleanStack));
    }

    public static AddKnowledgeResult addKnowledge(Player player, IKnowledgeProvider provider, ItemInfo rawInfo, ItemInfo cleanInfo) {
        if (cleanInfo.createStack().m_41619_()) {
            return AddKnowledgeResult.FAIL;
        }
        if (!provider.hasKnowledge(cleanInfo)) {
            if (MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptLearnEvent(player, rawInfo, cleanInfo))) {
                return AddKnowledgeResult.FAIL;
            }
            provider.addKnowledge(cleanInfo);
            return AddKnowledgeResult.SUCCESS;
        }
        return AddKnowledgeResult.UNKNOWN;
    }

    public static int safeIntValue(BigInteger val) {
        try {
            return val.intValueExact();
        }
        catch (ArithmeticException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    public static int safeIntValue(BigDecimal val) {
        try {
            return val.intValueExact();
        }
        catch (ArithmeticException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    public static long safeLongValue(BigInteger val) {
        try {
            return val.longValueExact();
        }
        catch (ArithmeticException ignore) {
            return Long.MAX_VALUE;
        }
    }

    public static int mod(int a, int b) {
        return (a %= b) < 0 ? a + b : a;
    }

    public static void markDirty(BlockEntity block) {
        if (block.m_58904_() != null) {
            Util.markDirty(block.m_58904_(), block);
        }
    }

    public static void markDirty(Level level, BlockEntity block) {
        Util.markDirty(level, block.m_58899_());
    }

    public static void markDirty(Level level, BlockPos pos) {
        level.m_46745_(pos).m_8092_(true);
        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
    }

    @Nullable
    public static IKnowledgeProvider getKnowledgeProvider(UUID uuid) {
        ServerPlayer player = Util.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return Util.getKnowledgeProvider((Player)player);
    }

    @Nullable
    public static IKnowledgeProvider getKnowledgeProvider(Player player) {
        try {
            return (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).orElseThrow(NullPointerException::new);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    public static long spreadEMC(long emc, List<IEmcStorage> storageList) {
        return Util.spreadEMC(emc, storageList, null);
    }

    public static long spreadEMC(long emc, List<IEmcStorage> storageList, @Nullable Long maxPer) {
        return Util.safeLongValue(Util.spreadEMC(BigInteger.valueOf(emc), storageList, maxPer));
    }

    public static BigInteger spreadEMC(BigInteger emc, List<IEmcStorage> storageList) {
        return Util.spreadEMC(emc, storageList, null);
    }

    public static BigInteger spreadEMC(BigInteger emc, List<IEmcStorage> storageList, @Nullable Long maxPer) {
        if (emc.equals(BigInteger.ZERO) || storageList.isEmpty()) {
            return emc;
        }
        ArrayList notAccepting = new ArrayList();
        emc = Util.stepBigInteger(emc, (Long val) -> {
            long div = val / (long)storageList.size();
            if (maxPer != null && maxPer < div) {
                div = maxPer;
            }
            block0: while (val > 0L && notAccepting.size() < storageList.size()) {
                for (IEmcStorage storage : storageList) {
                    if (notAccepting.contains(storage)) continue;
                    if (val == 0L) break block0;
                    if (val < div) {
                        div = val;
                    }
                    long oldVal = val;
                    if ((val = Long.valueOf(val - storage.insertEmc(div, IEmcStorage.EmcAction.EXECUTE))).equals(oldVal)) {
                        notAccepting.add(storage);
                    }
                    if (maxPer == null || oldVal - val < maxPer) continue;
                    notAccepting.add(storage);
                }
            }
            return val;
        });
        return emc;
    }

    public static BigInteger stepBigInteger(BigInteger value, Function<Long, Long> func) {
        return Util.stepBigInteger(value, (Long)Long.MAX_VALUE, func);
    }

    public static BigInteger stepBigInteger(BigInteger value, Long step, Function<Long, Long> func) {
        return Util.stepBigInteger(value, step, (Long a, BigInteger b) -> (Long)func.apply((Long)a));
    }

    public static BigInteger stepBigInteger(BigInteger value, BiFunction<Long, BigInteger, Long> func) {
        return Util.stepBigInteger(value, (Long)Long.MAX_VALUE, func);
    }

    public static BigInteger stepBigInteger(BigInteger value, Long step, BiFunction<Long, BigInteger, Long> func) {
        long localValue;
        if (value.equals(BigInteger.ZERO)) {
            return value;
        }
        while ((localValue = Math.min(step, Util.safeLongValue(value))) > 0L) {
            value = value.subtract(BigInteger.valueOf(localValue));
            Long unused = func.apply(localValue, value);
            if (unused <= 0L) continue;
            value = value.add(BigInteger.valueOf(unused));
            break;
        }
        return value;
    }

    @Nullable
    public static ServerLevel getDimension(ResourceKey<Level> dimension) {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(dimension);
    }

    public static Style suggestCommand(Style style, String command) {
        return style.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)command).m_130940_(ChatFormatting.RED)));
    }

    public static BigDecimal divide(BigInteger dividend, BigInteger divisor) {
        return new BigDecimal(dividend).divide(new BigDecimal(divisor), 2, RoundingMode.HALF_EVEN);
    }

    public static int scaleToRedstone(long currentAmount, long max) {
        return Util.scaleToRedstone(BigInteger.valueOf(currentAmount), BigInteger.valueOf(max));
    }

    public static int scaleToRedstone(BigInteger currentAmount, BigInteger max) {
        double proportion = Util.divide(currentAmount, max).doubleValue();
        if (currentAmount.compareTo(BigInteger.ZERO) <= 0) {
            return 0;
        }
        if (currentAmount.compareTo(max) >= 0) {
            return 15;
        }
        return (int)Math.round(proportion * 13.0 + 1.0);
    }

    public static boolean isImmuneToFire(ServerPlayer player) {
        return Util.isImmuneToFire(player, 0);
    }

    public static boolean isImmuneToFire(ServerPlayer player, int timeTolerance) {
        IFireProtector protector;
        ItemStack chestplate = player.m_150109_().m_36052_(EquipmentSlot.CHEST.m_20749_());
        Item item = chestplate.m_41720_();
        if (item instanceof IFireProtector && (protector = (IFireProtector)item).canProtectAgainstFire(chestplate, player)) {
            return true;
        }
        MobEffectInstance fireResistance = player.m_21124_(MobEffects.f_19607_);
        if (fireResistance != null && fireResistance.m_19557_() > timeTolerance) {
            return true;
        }
        return player.m_5825_();
    }

    public static String ucwords(String str) {
        StringBuilder sb = new StringBuilder();
        boolean capitalize = true;
        for (char c : str.toCharArray()) {
            if (Character.isWhitespace(c)) {
                capitalize = true;
            } else if (capitalize) {
                c = Character.toTitleCase(c);
                capitalize = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int getSunMultiplier() {
        float pfValue = IEMCProxy.INSTANCE.getValue((Block)Objects.requireNonNull(Matter.FINAL.getPowerFlower()));
        float sunValue = IEMCProxy.INSTANCE.getValue((Block)Blocks.COMPACT_SUN.get());
        if (pfValue == 0.0f || sunValue == 0.0f) {
            return (Integer)Config.compactSunBonus.get();
        }
        int diff = (int)Math.ceil(sunValue / pfValue) + 1;
        return (int)Math.ceil((double)diff / 10.0) * 10;
    }

    public static int getSunBonus() {
        if (((Boolean)Config.sunMultiplierPriceCompensation.get()).booleanValue()) {
            int priceBonus = Util.getSunMultiplier();
            int staticBonus = (Integer)Config.compactSunBonus.get();
            return Math.max(priceBonus, staticBonus);
        }
        return (Integer)Config.compactSunBonus.get();
    }

    public static enum AddKnowledgeResult {
        FAIL,
        UNKNOWN,
        SUCCESS;

    }
}

