/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.Main;
import moze_intel.projecte.utils.LazyTagLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SunExposureHelper {
    public static final TagKey<Item> PROTECTIVE_ITEMS = ItemTags.create((ResourceLocation)Main.rl("sun_exposure_protection"));
    public static final LazyTagLookup<Item> PROTECTIVE_ITEMS_LOOKUP = LazyTagLookup.create((IForgeRegistry)ForgeRegistries.ITEMS, PROTECTIVE_ITEMS);

    private static boolean automaticProtection(ServerPlayer player) {
        return player.f_8941_.m_9295_() || player.f_8941_.m_9290_().equals((Object)GameType.SPECTATOR);
    }

    public static boolean wearingProtectiveBoots(ServerPlayer player) {
        return SunExposureHelper.automaticProtection(player) || PROTECTIVE_ITEMS_LOOKUP.contains((Object)player.m_150109_().m_36052_(EquipmentSlot.FEET.m_20749_()).m_41720_());
    }

    public static boolean wearingProtectiveLeggings(ServerPlayer player) {
        return SunExposureHelper.automaticProtection(player) || PROTECTIVE_ITEMS_LOOKUP.contains((Object)player.m_150109_().m_36052_(EquipmentSlot.LEGS.m_20749_()).m_41720_());
    }

    public static boolean wearingProtectiveChestplate(ServerPlayer player) {
        return SunExposureHelper.automaticProtection(player) || PROTECTIVE_ITEMS_LOOKUP.contains((Object)player.m_150109_().m_36052_(EquipmentSlot.CHEST.m_20749_()).m_41720_());
    }

    public static boolean wearingProtectiveHelmet(ServerPlayer player) {
        return SunExposureHelper.automaticProtection(player) || PROTECTIVE_ITEMS_LOOKUP.contains((Object)player.m_150109_().m_36052_(EquipmentSlot.HEAD.m_20749_()).m_41720_());
    }

    public static int getProtectionAmount(ServerPlayer player) {
        int protection = 0;
        if (SunExposureHelper.wearingProtectiveBoots(player)) {
            ++protection;
        }
        if (SunExposureHelper.wearingProtectiveLeggings(player)) {
            ++protection;
        }
        if (SunExposureHelper.wearingProtectiveChestplate(player)) {
            ++protection;
        }
        if (SunExposureHelper.wearingProtectiveHelmet(player)) {
            ++protection;
        }
        return protection;
    }

    public static boolean wearingAllProtectiveArmor(ServerPlayer player) {
        return SunExposureHelper.getProtectionAmount(player) == 4;
    }

    public static boolean wearingAnyProtectiveArmor(ServerPlayer player) {
        return SunExposureHelper.getProtectionAmount(player) > 0;
    }
}

