/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.item.ItemStar;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public enum Star {
    EIN("ein"),
    ZWEI("zwei"),
    DREI("drei"),
    VIER("vier"),
    SPHERE("sphere"),
    OMEGA("omega");

    public static final Star[] VALUES;
    public final String name;
    @Nullable
    private RegistryObject<ItemStar> itemMagnum = null;
    @Nullable
    private RegistryObject<ItemStar> itemColossal = null;
    private RegistryObject<ItemStar> itemGargantuan = null;

    public Star prev() {
        return VALUES[(this.ordinal() - 1 + VALUES.length) % VALUES.length];
    }

    public Star next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    private Star(String name) {
        this.name = name;
    }

    @Nullable
    public Star getPrev() {
        return this == EIN ? null : VALUES[this.ordinal() - 1];
    }

    @Nullable
    public ItemStar asMagnumItem() {
        return this.itemMagnum == null ? null : (ItemStar)((Object)this.itemMagnum.get());
    }

    @Nullable
    public ItemStar asColossalItem() {
        return this.itemColossal == null ? null : (ItemStar)((Object)this.itemColossal.get());
    }

    @Nullable
    public ItemStar asGargantuanItem() {
        return this.itemGargantuan == null ? null : (ItemStar)((Object)this.itemGargantuan.get());
    }

    private void register(StarType reg) {
        switch (reg) {
            case MAGNUM: {
                this.itemMagnum = Items.Registry.register(String.format("magnum_star_%s", this.name), () -> new ItemStar(reg, this));
                break;
            }
            case COLOSSAL: {
                this.itemColossal = Items.Registry.register(String.format("colossal_star_%s", this.name), () -> new ItemStar(reg, this));
                break;
            }
            case GARGANTUAN: {
                this.itemGargantuan = Items.Registry.register(String.format("gargantuan_star_%s", this.name), () -> new ItemStar(reg, this));
            }
        }
    }

    public static void registerAll() {
        Arrays.stream(StarType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.register((StarType)((Object)type))));
    }

    public static void setAllCreativeTab(CreativeModeTab.Output output) {
        Arrays.stream(StarType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.setCreativeTab(output, (StarType)((Object)type))));
    }

    private void setCreativeTab(CreativeModeTab.Output output, StarType type) {
        if (type == StarType.MAGNUM && this.itemMagnum != null) {
            output.m_246326_((ItemLike)this.itemMagnum.get());
        }
        if (type == StarType.COLOSSAL && this.itemColossal != null) {
            output.m_246326_((ItemLike)this.itemColossal.get());
        }
        if (type == StarType.GARGANTUAN && this.itemGargantuan != null) {
            output.m_246326_((ItemLike)this.itemGargantuan.get());
        }
    }

    static {
        VALUES = Star.values();
    }

    public static enum StarType {
        MAGNUM,
        COLOSSAL,
        GARGANTUAN;


        public int getOffset() {
            return this.ordinal() * 6;
        }
    }
}

