/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.block.BlockCollector;
import cool.furry.mc.forge.projectexpansion.block.BlockEMCLink;
import cool.furry.mc.forge.projectexpansion.block.BlockMatter;
import cool.furry.mc.forge.projectexpansion.block.BlockPowerFlower;
import cool.furry.mc.forge.projectexpansion.block.BlockRelay;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.item.ItemCompressedEnergyCollector;
import cool.furry.mc.forge.projectexpansion.registries.Blocks;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.blocks.MatterBlock;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEItems;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.RegistryObject;

public enum Matter {
    BASIC(0, () -> MapColor.f_283818_, null, null),
    DARK(2, () -> ((MatterBlock)PEBlocks.DARK_MATTER.getBlock()).m_284356_(), (Supplier<Item>)PEItems.DARK_MATTER, () -> ((BlockRegistryObject)PEBlocks.DARK_MATTER).getBlock()),
    RED(4, () -> ((MatterBlock)PEBlocks.RED_MATTER.getBlock()).m_284356_(), (Supplier<Item>)PEItems.RED_MATTER, () -> ((BlockRegistryObject)PEBlocks.RED_MATTER).getBlock()),
    MAGENTA(4, () -> MapColor.f_283931_, null, null),
    PINK(5, () -> MapColor.f_283765_, null, null),
    PURPLE(5, () -> MapColor.f_283889_, null, null),
    VIOLET(6, () -> MapColor.f_283889_, null, null),
    BLUE(6, () -> MapColor.f_283927_, null, null),
    CYAN(7, () -> MapColor.f_283772_, null, null),
    GREEN(7, () -> MapColor.f_283784_, null, null),
    LIME(8, () -> MapColor.f_283916_, null, null),
    YELLOW(8, () -> MapColor.f_283832_, null, null),
    ORANGE(9, () -> MapColor.f_283750_, null, null),
    WHITE(9, null, null, null),
    FADING(10, () -> MapColor.f_283927_, null, null),
    FINAL(10, null, (Supplier<Item>)Items.FINAL_STAR_SHARD, null);

    public final BigDecimal BASE_COLLECTOR_OUTPUT = BigDecimal.valueOf(4L);
    public final BigDecimal BASE_RELAY_BONUS = BigDecimal.valueOf(1L);
    public final BigDecimal BASE_RELAY_TRANSFER = BigDecimal.valueOf(64L);
    public static final Matter[] VALUES;
    public static final List<Matter> COMMON_ITEMS;
    public static final List<Matter> UNCOMMON_ITEMS;
    public static final List<Matter> RARE_ITEMS;
    public static final List<Matter> EPIC_ITEMS;
    public final String name;
    public final boolean hasItem;
    public final boolean hasBlock;
    public final int level;
    public final BigDecimal collectorOutputBase;
    public final BigDecimal relayBonusBase;
    public final BigDecimal relayTransferBase;
    @Deprecated
    public final int fluidEfficiency;
    @Nullable
    public final Supplier<MapColor> mapColor;
    @Nullable
    public final Supplier<Item> existingItem;
    @Nullable
    public final Supplier<Block> existingBlock;
    @Nullable
    private RegistryObject<Item> itemMatter = null;
    @Nullable
    private RegistryObject<BlockPowerFlower> powerFlower = null;
    @Nullable
    private RegistryObject<BlockItem> itemPowerFlower = null;
    @Nullable
    private RegistryObject<BlockCollector> collector = null;
    @Nullable
    private RegistryObject<BlockItem> itemCollector = null;
    @Nullable
    private RegistryObject<ItemCompressedEnergyCollector> itemCompressedCollector = null;
    @Nullable
    private RegistryObject<BlockRelay> relay = null;
    @Nullable
    private RegistryObject<BlockItem> itemRelay = null;
    @Nullable
    private RegistryObject<BlockEMCLink> emcLink = null;
    @Nullable
    private RegistryObject<BlockItem> itemEMCLink = null;
    @Nullable
    private RegistryObject<BlockItem> itemMatterBlock = null;
    @Nullable
    private RegistryObject<BlockMatter> blockMatterBlock = null;

    public Matter prev() {
        return VALUES[(this.ordinal() - 1 + VALUES.length) % VALUES.length];
    }

    public Matter next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    private Matter(@Nullable int fluidEfficiency, @Nullable Supplier<MapColor> mapColor, Supplier<Item> existingItem, Supplier<Block> existingBlock) {
        boolean isFinal = this.name().equals("FINAL");
        this.name = this.name().toLowerCase(Locale.US);
        this.hasItem = existingItem == null && this.ordinal() != 0;
        this.hasBlock = existingBlock == null && this.ordinal() != 0 && this.ordinal() != 15;
        this.level = this.ordinal() + 1;
        this.collectorOutputBase = this.getValue(this.BASE_COLLECTOR_OUTPUT);
        this.relayBonusBase = this.getValue(this.BASE_RELAY_BONUS);
        this.relayTransferBase = isFinal ? BigDecimal.valueOf(Long.MAX_VALUE) : this.getValue(this.BASE_RELAY_TRANSFER);
        this.fluidEfficiency = fluidEfficiency;
        this.mapColor = mapColor;
        this.existingItem = existingItem;
        this.existingBlock = existingBlock;
    }

    public Rarity getRarity() {
        if (COMMON_ITEMS.contains((Object)this)) {
            return Rarity.COMMON;
        }
        if (UNCOMMON_ITEMS.contains((Object)this)) {
            return Rarity.UNCOMMON;
        }
        if (RARE_ITEMS.contains((Object)this)) {
            return Rarity.RARE;
        }
        if (EPIC_ITEMS.contains((Object)this)) {
            return Rarity.EPIC;
        }
        return Rarity.COMMON;
    }

    public int getLevel() {
        return this.level;
    }

    private BigDecimal getValue(BigDecimal base) {
        BigDecimal val = base;
        for (int i = 0; i < this.ordinal(); ++i) {
            val = val.multiply(BigDecimal.valueOf(6L));
        }
        return val;
    }

    public int getFluidEfficiencyPercentage() {
        if (!((Boolean)Config.enableFluidEfficiency.get()).booleanValue()) {
            return 100;
        }
        AtomicInteger efficiency = new AtomicInteger(this.fluidEfficiency);
        Arrays.stream(VALUES).filter(m -> m.level < this.level).forEach(m -> efficiency.addAndGet(m.fluidEfficiency));
        return efficiency.get();
    }

    public BigInteger getPowerFlowerOutput() {
        return this.collectorOutputBase.multiply(BigDecimal.valueOf(18L)).add(this.relayBonusBase.multiply(BigDecimal.valueOf(30L))).multiply(BigDecimal.valueOf((Double)Config.powerflowerMultiplier.get())).toBigInteger();
    }

    public BigInteger getPowerFlowerOutputForTicks(int ticks) {
        if (ticks == 20) {
            return this.getPowerFlowerOutput();
        }
        BigInteger div20 = this.getPowerFlowerOutput().divide(BigInteger.valueOf(20L));
        return div20.multiply(BigInteger.valueOf(ticks));
    }

    public BigInteger getCollectorOutput() {
        return this.collectorOutputBase.multiply(BigDecimal.valueOf((Double)Config.collectorMultiplier.get())).toBigInteger();
    }

    public BigDecimal getCollectorOutputForTicks(int ticks) {
        if (ticks == 20) {
            return new BigDecimal(this.getCollectorOutput());
        }
        BigDecimal div20 = new BigDecimal(this.getCollectorOutput()).divide(BigDecimal.valueOf(20L), 3, RoundingMode.UP);
        return div20.multiply(BigDecimal.valueOf(ticks));
    }

    public BigInteger getRelayBonus() {
        return this.relayBonusBase.multiply(BigDecimal.valueOf((Double)Config.relayBonusMultiplier.get())).toBigInteger();
    }

    public BigInteger getRelayBonusForTicks(int ticks) {
        return this.getRelayBonus();
    }

    public BigInteger getRelayTransfer() {
        return this.relayTransferBase.multiply(BigDecimal.valueOf((Double)Config.relayTransferMultiplier.get())).toBigInteger();
    }

    public BigInteger getRelayTransferForTicks(int ticks) {
        return this.getRelayTransfer();
    }

    public int getEMCLinkInventorySize() {
        return this.level * 3;
    }

    public BigInteger getEMCLinkEMCLimit() {
        return BigDecimal.valueOf(16L).pow(this.level).multiply(BigDecimal.valueOf((Double)Config.emcLinkEMCLimitMultiplier.get())).toBigInteger();
    }

    public int getEMCLinkItemLimit() {
        try {
            return BigDecimal.valueOf(2L).pow(this.level - 1).multiply(BigDecimal.valueOf((Double)Config.emcLinkItemLimitMultiplier.get())).intValueExact();
        }
        catch (ArithmeticException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    public int getEMCLinkFluidLimit() {
        try {
            return BigDecimal.valueOf(2L).pow(this.level - 1).multiply(BigDecimal.valueOf(1000L)).multiply(BigDecimal.valueOf((Double)Config.emcLinkFluidLimitMultiplier.get())).intValueExact();
        }
        catch (ArithmeticException ignore) {
            return Integer.MAX_VALUE;
        }
    }

    public MutableComponent getFormattedComponent(int value) {
        return this.getFormattedComponent(BigInteger.valueOf(value));
    }

    public MutableComponent getFormattedComponent(long value) {
        return this.getFormattedComponent(BigInteger.valueOf(value));
    }

    public MutableComponent getFormattedComponent(BigInteger value) {
        return (this.equals((Object)FINAL) ? Component.m_237113_((String)"INFINITY") : EMCFormat.getComponent(value)).m_6270_(ColorStyle.GREEN);
    }

    public MutableComponent getEMCLinkItemLimitComponent() {
        return this.getFormattedComponent(this.getEMCLinkItemLimit());
    }

    public MutableComponent getEMCLinkFluidLimitComponent() {
        return this.getFormattedComponent(this.getEMCLinkFluidLimit());
    }

    public MutableComponent getEMCLinkEMCLimitComponent() {
        return this.getFormattedComponent(this.getEMCLinkEMCLimit());
    }

    public MutableComponent getRelayTransferComponent() {
        return this.getFormattedComponent(this.getRelayTransferForTicks((Integer)Config.tickDelay.get()));
    }

    @Nullable
    public Item getMatter() {
        return this.itemMatter == null ? null : (Item)this.itemMatter.get();
    }

    @Nullable
    public Item getMatterOrExisting() {
        return this.itemMatter == null ? (this.existingItem == null ? null : this.existingItem.get()) : (Item)this.itemMatter.get();
    }

    @Nullable
    public BlockPowerFlower getPowerFlower() {
        return this.powerFlower == null ? null : (BlockPowerFlower)this.powerFlower.get();
    }

    @Nullable
    public BlockItem getPowerFlowerItem() {
        return this.itemPowerFlower == null ? null : (BlockItem)this.itemPowerFlower.get();
    }

    @Nullable
    public BlockRelay getRelay() {
        return this.relay == null ? null : (BlockRelay)this.relay.get();
    }

    @Nullable
    public BlockItem getRelayItem() {
        return this.itemRelay == null ? null : (BlockItem)this.itemRelay.get();
    }

    @Nullable
    public BlockCollector getCollector() {
        return this.collector == null ? null : (BlockCollector)this.collector.get();
    }

    @Nullable
    public BlockItem getCollectorItem() {
        return this.itemCollector == null ? null : (BlockItem)this.itemCollector.get();
    }

    @Nullable
    public ItemCompressedEnergyCollector getCompressedCollectorItem() {
        return this.itemCompressedCollector == null ? null : (ItemCompressedEnergyCollector)((Object)this.itemCompressedCollector.get());
    }

    @Nullable
    public BlockEMCLink getEMCLink() {
        return this.emcLink == null ? null : (BlockEMCLink)this.emcLink.get();
    }

    @Nullable
    public BlockItem getEMCLinkItem() {
        return this.itemEMCLink == null ? null : (BlockItem)this.itemEMCLink.get();
    }

    private void register(RegistrationType reg) {
        switch (reg) {
            case MATTER: {
                if (!this.hasItem) break;
                this.itemMatter = Items.Registry.register(String.format("%s_matter", this.name), () -> new Item(new Item.Properties().m_41497_(this.getRarity())));
                break;
            }
            case MATTER_BLOCK: {
                if (!this.hasBlock) break;
                this.blockMatterBlock = Blocks.Registry.register(String.format("%s_matter_block", this.name), () -> new BlockMatter(this));
                this.itemMatterBlock = Items.Registry.register(String.format("%s_matter_block", this.name), () -> new BlockItem((Block)Objects.requireNonNull(this.blockMatterBlock).get(), new Item.Properties().m_41497_(this.getRarity())));
                break;
            }
            case COLLECTOR: {
                this.collector = Blocks.Registry.register(String.format("%s_collector", this.name), () -> new BlockCollector(this));
                this.itemCollector = Items.Registry.register(String.format("%s_collector", this.name), () -> new BlockItem((Block)Objects.requireNonNull(this.collector).get(), new Item.Properties().m_41497_(this.getRarity())));
                break;
            }
            case COMPRESSED_COLLECTOR: {
                this.itemCompressedCollector = Items.Registry.register(String.format("%s_compressed_collector", this.name), () -> new ItemCompressedEnergyCollector(this));
                break;
            }
            case POWER_FLOWER: {
                this.powerFlower = Blocks.Registry.register(String.format("%s_power_flower", this.name), () -> new BlockPowerFlower(this));
                this.itemPowerFlower = Items.Registry.register(String.format("%s_power_flower", this.name), () -> new BlockItem((Block)Objects.requireNonNull(this.powerFlower).get(), new Item.Properties().m_41497_(this.getRarity())));
                break;
            }
            case RELAY: {
                this.relay = Blocks.Registry.register(String.format("%s_relay", this.name), () -> new BlockRelay(this));
                this.itemRelay = Items.Registry.register(String.format("%s_relay", this.name), () -> new BlockItem((Block)Objects.requireNonNull(this.relay).get(), new Item.Properties().m_41497_(this.getRarity())));
                break;
            }
            case EMC_LINK: {
                this.emcLink = Blocks.Registry.register(String.format("%s_emc_link", this.name), () -> new BlockEMCLink(this));
                this.itemEMCLink = Items.Registry.register(String.format("%s_emc_link", this.name), () -> new BlockItem((Block)Objects.requireNonNull(this.emcLink).get(), new Item.Properties().m_41497_(this.getRarity())));
            }
        }
    }

    public static void registerAll() {
        Arrays.stream(RegistrationType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.register((RegistrationType)((Object)type))));
    }

    public static void setAllCreativeTab(CreativeModeTab.Output output) {
        Arrays.stream(RegistrationType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.setCreativeTab(output, (RegistrationType)((Object)type))));
    }

    private void setCreativeTab(CreativeModeTab.Output output, RegistrationType type) {
        if (type == RegistrationType.MATTER && this.itemMatter != null) {
            output.m_246326_((ItemLike)this.itemMatter.get());
        }
        if (type == RegistrationType.MATTER_BLOCK && this.itemMatterBlock != null) {
            output.m_246326_((ItemLike)this.itemMatterBlock.get());
        }
        if (type == RegistrationType.COLLECTOR && this.itemCollector != null) {
            output.m_246326_((ItemLike)this.itemCollector.get());
        }
        if (type == RegistrationType.COMPRESSED_COLLECTOR && this.itemCompressedCollector != null) {
            output.m_246326_((ItemLike)this.itemCompressedCollector.get());
        }
        if (type == RegistrationType.POWER_FLOWER && this.itemPowerFlower != null) {
            output.m_246326_((ItemLike)this.itemPowerFlower.get());
        }
        if (type == RegistrationType.RELAY && this.itemRelay != null) {
            output.m_246326_((ItemLike)this.itemRelay.get());
        }
        if (type == RegistrationType.EMC_LINK && this.itemEMCLink != null) {
            output.m_246326_((ItemLike)this.itemEMCLink.get());
        }
    }

    static {
        VALUES = Matter.values();
        COMMON_ITEMS = List.of(BASIC, DARK, RED);
        UNCOMMON_ITEMS = List.of(MAGENTA, PURPLE, VIOLET, BLUE);
        RARE_ITEMS = List.of(CYAN, GREEN, LIME, YELLOW);
        EPIC_ITEMS = List.of(ORANGE, WHITE, FADING, FINAL);
    }

    private static enum RegistrationType {
        MATTER,
        MATTER_BLOCK,
        COLLECTOR,
        COMPRESSED_COLLECTOR,
        POWER_FLOWER,
        RELAY,
        EMC_LINK;

    }
}

