/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.item.FuelBlockItem;
import cool.furry.mc.forge.projectexpansion.item.ItemFuel;
import cool.furry.mc.forge.projectexpansion.registries.Blocks;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.items.AlchemicalFuel;
import moze_intel.projecte.gameObjs.registration.impl.ItemRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.RegistryObject;

public enum Fuel {
    ALCHEMICAL(() -> ((ItemRegistryObject)PEItems.ALCHEMICAL_COAL).m_5456_()),
    MOBIUS(() -> ((ItemRegistryObject)PEItems.MOBIUS_FUEL).m_5456_()),
    AETERNALIS(() -> ((ItemRegistryObject)PEItems.AETERNALIS_FUEL).m_5456_()),
    MAGENTA(null),
    PINK(null),
    PURPLE(null),
    VIOLET(null),
    BLUE(null),
    CYAN(null),
    GREEN(null),
    LIME(null),
    YELLOW(null),
    ORANGE(null),
    WHITE(null);

    public static final List<Fuel> COMMON_ITEMS;
    public static final List<Fuel> UNCOMMON_ITEMS;
    public static final List<Fuel> RARE_ITEMS;
    public static final List<Fuel> EPIC_ITEMS;
    public static final Fuel[] VALUES;
    public final String name = this.name().toLowerCase(Locale.US);
    @Nullable
    public final Supplier<Item> existingItem;
    @Nullable
    private RegistryObject<Item> item = null;
    @Nullable
    private RegistryObject<Block> block = null;
    @Nullable
    private RegistryObject<BlockItem> blockItem = null;

    private Fuel(Supplier<Item> existingItem) {
        this.existingItem = existingItem;
    }

    public Rarity getRarity() {
        if (COMMON_ITEMS.contains((Object)this)) {
            return Rarity.COMMON;
        }
        if (UNCOMMON_ITEMS.contains((Object)this)) {
            return Rarity.UNCOMMON;
        }
        if (RARE_ITEMS.contains((Object)this)) {
            return Rarity.RARE;
        }
        if (EPIC_ITEMS.contains((Object)this)) {
            return Rarity.EPIC;
        }
        return Rarity.COMMON;
    }

    public int getBurnTime() {
        return this.getBurnTime(null);
    }

    public int getBurnTime(@Nullable RecipeType<?> type) {
        return this.item == null ? -1 : ((AlchemicalFuel)PEItems.AETERNALIS_FUEL.get()).getBurnTime(new ItemStack((ItemLike)this.item.get()), type);
    }

    public long getCollectorEMCLimit() {
        return Fuel.getCollectorEMCLimit(Objects.requireNonNull(Fuel.fuelToMatter(this)));
    }

    @Nullable
    public Item getItem() {
        return this.item == null ? null : (Item)this.item.get();
    }

    @Nullable
    public Item getItemOrExisting() {
        return this.item == null ? (this.existingItem == null ? null : this.existingItem.get()) : (Item)this.item.get();
    }

    @Nullable
    public Block getBlock() {
        return this.block == null ? null : (Block)this.block.get();
    }

    @Nullable
    public BlockItem getBlockItem() {
        return this.blockItem == null ? null : (BlockItem)this.blockItem.get();
    }

    private void register(RegistrationType reg) {
        if (this.existingItem != null) {
            return;
        }
        switch (reg) {
            case ITEM: {
                this.item = Items.Registry.register(String.format("%s_fuel", this.name), () -> new ItemFuel(this));
                break;
            }
            case BLOCK: {
                this.block = Blocks.Registry.register(String.format("%s_fuel_block", this.name), () -> new Block(BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(0.5f, 1.5f)));
                this.blockItem = Items.Registry.register(String.format("%s_fuel_block", this.name), () -> new FuelBlockItem(this));
            }
        }
    }

    public static void registerAll() {
        Arrays.stream(RegistrationType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.register((RegistrationType)((Object)type))));
    }

    public static void setAllCreativeTab(CreativeModeTab.Output output) {
        Arrays.stream(RegistrationType.values()).forEach(type -> Arrays.stream(VALUES).forEach(val -> val.setCreativeTab(output, (RegistrationType)((Object)type))));
    }

    private void setCreativeTab(CreativeModeTab.Output output, RegistrationType type) {
        if (type == RegistrationType.ITEM && this.item != null) {
            output.m_246326_((ItemLike)this.item.get());
        }
        if (type == RegistrationType.BLOCK && this.blockItem != null) {
            output.m_246326_((ItemLike)this.blockItem.get());
        }
    }

    @Nullable
    public static Fuel matterToFuel(Matter matter) {
        return switch (matter) {
            case Matter.BASIC -> ALCHEMICAL;
            case Matter.DARK -> MOBIUS;
            case Matter.RED -> AETERNALIS;
            default -> {
                for (Fuel fuel : VALUES) {
                    if (!fuel.name.equals(matter.name().toLowerCase(Locale.US))) continue;
                    yield fuel;
                }
                yield null;
            }
        };
    }

    @Nullable
    public static Matter fuelToMatter(Fuel fuel) {
        return switch (fuel) {
            case ALCHEMICAL -> Matter.BASIC;
            case MOBIUS -> Matter.DARK;
            case AETERNALIS -> Matter.RED;
            default -> {
                for (Matter matter : Matter.VALUES) {
                    if (!matter.name().toLowerCase(Locale.US).equals(fuel.name)) continue;
                    yield matter;
                }
                yield null;
            }
        };
    }

    public static long getCollectorEMCLimit(Matter matter) {
        BigInteger minute = matter.getCollectorOutput().multiply(BigInteger.valueOf(60L));
        return Util.safeLongValue(Fuel.roundToNearest(minute));
    }

    public static BigInteger roundToNearest(BigInteger number) {
        BigInteger[] divRem;
        BigInteger orderOfMagnitude = BigInteger.TEN.pow(number.toString().length() - 1);
        BigInteger nearest250 = orderOfMagnitude.divide(BigInteger.valueOf(4L));
        try {
            divRem = number.divideAndRemainder(nearest250);
        }
        catch (ArithmeticException ignored) {
            divRem = new BigInteger[]{BigInteger.ONE, BigInteger.ZERO};
        }
        BigInteger roundedValue = divRem[1].compareTo(BigInteger.ZERO) > 0 ? divRem[0].add(BigInteger.ONE) : divRem[0];
        return roundedValue.multiply(nearest250);
    }

    static {
        COMMON_ITEMS = List.of(ALCHEMICAL, MOBIUS, AETERNALIS);
        UNCOMMON_ITEMS = List.of(MAGENTA, PURPLE, VIOLET, BLUE);
        RARE_ITEMS = List.of(CYAN, GREEN, LIME, YELLOW);
        EPIC_ITEMS = List.of(ORANGE, WHITE);
        VALUES = Fuel.values();
    }

    private static enum RegistrationType {
        ITEM,
        BLOCK;

    }
}

