/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.config.Config;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class EMCFormat
extends DecimalFormat {
    public static EMCFormat INSTANCE = new EMCFormat();
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    public static final BigDecimal FORMAT_START = BigDecimal.valueOf(1000000L);

    private EMCFormat() {
        super("#,###");
        this.setRoundingMode(RoundingMode.DOWN);
    }

    @Override
    public StringBuffer format(double number, StringBuffer result, FieldPosition fieldPosition) {
        String formatted = EMCFormat.format(BigDecimal.valueOf(number));
        return new StringBuffer(formatted);
    }

    @Override
    public StringBuffer format(long number, StringBuffer result, FieldPosition fieldPosition) {
        return this.format(Double.parseDouble(Long.toString(number)), result, fieldPosition);
    }

    public static MutableComponent getComponent(long value) {
        return EMCFormat.getComponent(BigDecimal.valueOf(value));
    }

    public static MutableComponent getComponent(BigInteger value) {
        return EMCFormat.getComponent(new BigDecimal(value));
    }

    public static MutableComponent getComponent(BigDecimal value) {
        return Component.m_237113_((String)EMCFormat.format(value));
    }

    public static String formatForceShort(BigInteger value) {
        return EMCFormat.format(value, IgnoreShiftType.FORMAT);
    }

    public static String formatForceLong(BigInteger value) {
        return EMCFormat.format(value, IgnoreShiftType.NO_FORMAT);
    }

    public static String format(BigInteger value) {
        return EMCFormat.format(value, IgnoreShiftType.NONE);
    }

    public static String format(BigInteger value, IgnoreShiftType ignoreShiftType) {
        return EMCFormat.format(new BigDecimal(value), ignoreShiftType);
    }

    public static String formatForceShort(BigDecimal value) {
        return EMCFormat.format(value, IgnoreShiftType.FORMAT);
    }

    public static String formatForceLong(BigDecimal value) {
        return EMCFormat.format(value, IgnoreShiftType.NO_FORMAT);
    }

    public static String format(BigDecimal value) {
        return EMCFormat.format(value, IgnoreShiftType.NONE);
    }

    public static String format(BigDecimal value, IgnoreShiftType ignoreShiftType) {
        if (EMCFormat.shouldFormat(value, ignoreShiftType)) {
            NumberName name = NumberName.findName(value);
            if (name == null) {
                return NumberFormat.getNumberInstance(Locale.US).format(value);
            }
            return EMCFormat.getShort(value) + ((Boolean)Config.fullNumberNames.get() != false ? String.format(" %s", name.getName(false)) : name.getName(true));
        }
        return NumberFormat.getNumberInstance(Locale.US).format(value);
    }

    public boolean shouldFormat(BigDecimal value) {
        return EMCFormat.shouldFormat(value, IgnoreShiftType.NONE);
    }

    public static boolean shouldFormat(BigDecimal value, IgnoreShiftType ignoreShiftType) {
        return (Boolean)Config.formatEMC.get() != false && ignoreShiftType != IgnoreShiftType.NO_FORMAT && (ignoreShiftType == IgnoreShiftType.FORMAT || !Screen.m_96638_()) && value.compareTo(FORMAT_START) > -1;
    }

    public static String getShort(BigDecimal value) {
        return EMCFormat.getShort(value.toBigInteger());
    }

    static String getShort(BigInteger value) {
        String str = value.toString();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = str.length(); i > 0; --i) {
            if (current.length() >= 3) {
                list.add(current.reverse().toString());
                current.delete(0, current.length());
            }
            current.append(str.charAt(i - 1));
        }
        if (!current.isEmpty()) {
            list.add(current.reverse().toString());
            current.delete(0, current.length());
        }
        String sig = (String)list.get(list.size() - 1);
        String dec = ((String)list.get(list.size() - 2)).substring(0, 2);
        return String.format("%s.%s", sig, dec);
    }

    public static enum IgnoreShiftType {
        NONE,
        FORMAT,
        NO_FORMAT;

    }

    public static enum NumberName {
        MILLION(1000000.0, "M"),
        BILLION(1.0E9, "B"),
        TRILLION(1.0E12, "T"),
        QUADRILLION(1.0E15, "Qa"),
        QUINTILLION(1.0E18, "Qi"),
        SEXTILLION(1.0E21, "Sx"),
        SEPTILLION(1.0E24, "Sp"),
        OCTILLION(1.0E27, "O"),
        NONILLION(1.0E30, "N"),
        DECILLION(1.0E33, "D"),
        UNDECILLION(1.0E36, "U"),
        DUODECILLION(1.0E39, "Du"),
        TREDECILLION(1.0E42, "Tr"),
        QUATTUORDECILLION(1.0E45, "Qt"),
        QUINDECILLION(1.0E48, "Qd"),
        SEXDECILLION(1.0E51, "Sd"),
        SEPTENDECILLION(1.0E54, "St"),
        OCTODECILLION(1.0E57, "Oc"),
        NOVEMDECILLION(1.0E60, "No");

        public static final NumberName[] VALUES;
        private final double value;
        private final String shortName;

        private NumberName(double val, String shortName) {
            this.value = val;
            this.shortName = shortName;
        }

        public String getName() {
            return this.getName(false);
        }

        public String getName(boolean getShort) {
            return getShort ? this.shortName : (this.name().charAt(0) + this.name().toLowerCase(Locale.US).substring(1)).trim();
        }

        public double getValue() {
            return this.value;
        }

        public BigInteger getBigIntegerValue() {
            return new BigInteger(String.valueOf(this.getValue()));
        }

        public BigDecimal getBigDecimalValue() {
            return new BigDecimal(String.valueOf(this.getValue()));
        }

        @Nullable
        static NumberName findName(BigDecimal value) {
            return Arrays.stream(VALUES).filter(v -> value.compareTo(v.getBigDecimalValue()) > -1).reduce((first, second) -> second).orElse(null);
        }

        static {
            VALUES = NumberName.values();
        }
    }
}

