/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicBigInteger
extends Number {
    private final AtomicReference<BigInteger> bigInt;
    private static final BigInteger ONE = new BigInteger("1");
    private static final BigInteger NEGATIVE_ONE = new BigInteger("-1");

    public AtomicBigInteger() {
        this(BigInteger.ZERO);
    }

    public AtomicBigInteger(BigInteger bigInt) {
        this.bigInt = new AtomicReference<BigInteger>(bigInt);
    }

    @Override
    public double doubleValue() {
        return this.bigInt.get().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.bigInt.get().floatValue();
    }

    @Override
    public int intValue() {
        return this.bigInt.get().intValue();
    }

    @Override
    public long longValue() {
        return this.bigInt.get().longValue();
    }

    public final BigInteger get() {
        return this.bigInt.get();
    }

    public final void set(BigInteger newValue) {
        this.bigInt.set(newValue);
    }

    public final BigInteger addAndGet(BigInteger delta) {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.add(delta))) {
        }
        return nextVal;
    }

    public final BigInteger getAndAdd(BigInteger delta) {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.add(delta))) {
        }
        return currentVal;
    }

    public final BigInteger getAndIncrement() {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.add(ONE))) {
        }
        return currentVal;
    }

    public final BigInteger incrementAndGet() {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.add(ONE))) {
        }
        return nextVal;
    }

    public final BigInteger getAndDecrement() {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.add(NEGATIVE_ONE))) {
        }
        return currentVal;
    }

    public final BigInteger decrementAndGet() {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = this.bigInt.get().add(NEGATIVE_ONE))) {
        }
        return nextVal;
    }

    public final BigInteger getAndDivide(BigInteger val) {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.divide(val))) {
        }
        return currentVal;
    }

    public final BigInteger divideAndGet(BigInteger val) {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.divide(val))) {
        }
        return nextVal;
    }

    public final BigInteger getAndDivideRemainder(BigInteger val) {
        BigInteger[] result;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), (result = currentVal.divideAndRemainder(val))[0])) {
        }
        return currentVal;
    }

    public final BigInteger[] divideRemainderAndGet(BigInteger val) {
        BigInteger[] result;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), (result = currentVal.divideAndRemainder(val))[0])) {
        }
        return result;
    }

    public final BigInteger getAndMultiply(BigInteger val) {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.multiply(val))) {
        }
        return currentVal;
    }

    public final BigInteger multiplyAndGet(BigInteger val) {
        BigInteger nextVal;
        BigInteger currentVal;
        while (!this.bigInt.compareAndSet(currentVal = this.bigInt.get(), nextVal = currentVal.multiply(val))) {
        }
        return nextVal;
    }
}

