/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.SoundEvents;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;

public class AlchemicalCollectionCollector {
    public static HashMap<UUID, Collected> saved = new HashMap();

    public static void add(UUID player, BigInteger emc, List<ItemStack> items) {
        Collected existing = AlchemicalCollectionCollector.get(player);
        if (existing != null) {
            items.addAll(existing.items);
            saved.put(player, new Collected(player, existing.emc.add(emc), items, System.currentTimeMillis()));
        } else {
            saved.put(player, new Collected(player, emc, items, System.currentTimeMillis()));
        }
    }

    @Nullable
    public static Collected get(UUID player) {
        return saved.get(player);
    }

    public static void process() {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (UUID uuid : saved.keySet()) {
            Collected collected = saved.get(uuid);
            if (collected.inCooldown() || !collected.process()) continue;
            toRemove.add(uuid);
        }
        for (UUID uuid : toRemove) {
            saved.remove(uuid);
        }
    }

    public record Collected(UUID player, BigInteger emc, List<ItemStack> items, long lastUpdatedAt) {
        public boolean inCooldown() {
            return System.currentTimeMillis() < this.lastUpdatedAt + 250L;
        }

        public boolean process() {
            IKnowledgeProvider provider = Util.getKnowledgeProvider(this.player);
            ServerPlayer serverPlayer = Util.getPlayer(this.player);
            if (provider == null || serverPlayer == null) {
                return false;
            }
            for (ItemStack item : this.items) {
                if (!provider.addKnowledge(item)) continue;
                provider.syncKnowledgeChange(serverPlayer, NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromStack((ItemStack)item)), true);
            }
            provider.setEmc(provider.getEmc().add(this.emc));
            provider.syncEmc(serverPlayer);
            if (((Boolean)Config.alchemicalCollectionSound.get()).booleanValue()) {
                serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20183_(), (SoundEvent)SoundEvents.ALCHEMICAL_COLLECTION_COLLECT.get(), SoundSource.BLOCKS, 1.0f, 0.85f);
            }
            return true;
        }
    }
}

