/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.util;

import cool.furry.mc.forge.projectexpansion.block.BlockAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.registries.BlockEntityTypes;
import cool.furry.mc.forge.projectexpansion.registries.Blocks;
import cool.furry.mc.forge.projectexpansion.registries.Items;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.RegistryObject;

public class AdvancedAlchemicalChest {
    private static final Map<DyeColor, RegistryObject<BlockAdvancedAlchemicalChest>> blocks = new HashMap<DyeColor, RegistryObject<BlockAdvancedAlchemicalChest>>();
    private static final Map<DyeColor, RegistryObject<BlockEntityType<BlockEntityAdvancedAlchemicalChest>>> blockEntityTypes = new HashMap<DyeColor, RegistryObject<BlockEntityType<BlockEntityAdvancedAlchemicalChest>>>();
    private static final Map<DyeColor, RegistryObject<BlockItem>> blockItems = new HashMap<DyeColor, RegistryObject<BlockItem>>();

    public static void register() {
        for (DyeColor color : DyeColor.values()) {
            blocks.put(color, (RegistryObject<BlockAdvancedAlchemicalChest>)Blocks.Registry.register(String.format("%s_advanced_alchemical_chest", color.m_41065_()), () -> new BlockAdvancedAlchemicalChest(color)));
            blockEntityTypes.put(color, (RegistryObject<BlockEntityType<BlockEntityAdvancedAlchemicalChest>>)BlockEntityTypes.Registry.register(String.format("%s_advanced_alchemical_chest", color.m_41065_()), () -> BlockEntityType.Builder.m_155273_((pos, state) -> new BlockEntityAdvancedAlchemicalChest(pos, state, AdvancedAlchemicalChest.getBlockEntityType(color), color), (Block[])new Block[]{AdvancedAlchemicalChest.getBlock(color)}).m_58966_(null)));
            blockItems.put(color, (RegistryObject<BlockItem>)Items.Registry.register(String.format("%s_advanced_alchemical_chest", color.m_41065_()), () -> new BlockItem((Block)AdvancedAlchemicalChest.getBlock(color), new Item.Properties())));
        }
    }

    public static void setAllCreativeTab(CreativeModeTab.Output output) {
        Arrays.stream(DyeColor.values()).forEach(color -> output.m_246326_((ItemLike)blockItems.get(color).get()));
    }

    public static RegistryObject<BlockAdvancedAlchemicalChest> getRegistryBlock(DyeColor color) {
        return blocks.get(color);
    }

    public static BlockAdvancedAlchemicalChest getBlock(DyeColor color) {
        return (BlockAdvancedAlchemicalChest)AdvancedAlchemicalChest.getRegistryBlock(color).get();
    }

    public static RegistryObject<BlockEntityType<BlockEntityAdvancedAlchemicalChest>> getRegistryBlockEntityType(DyeColor color) {
        return blockEntityTypes.get(color);
    }

    public static BlockEntityType<BlockEntityAdvancedAlchemicalChest> getBlockEntityType(DyeColor color) {
        return (BlockEntityType)AdvancedAlchemicalChest.getRegistryBlockEntityType(color).get();
    }

    public static BlockAdvancedAlchemicalChest[] getBlocks() {
        return (BlockAdvancedAlchemicalChest[])blocks.values().stream().map(RegistryObject::get).toArray(BlockAdvancedAlchemicalChest[]::new);
    }
}

