/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.net.packets.to_server;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.packets.IPacket;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import java.math.BigInteger;
import java.util.UUID;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PacketTeleportToDestination
implements IPacket {
    final String name;
    final Player player;
    final InteractionHand hand;

    public PacketTeleportToDestination(String name, Player player, InteractionHand hand) {
        this.name = name;
        this.player = player;
        this.hand = hand;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ItemStack stack = this.player.m_21120_(this.hand);
        Item item = stack.m_41720_();
        if (item instanceof ItemAlchemicalBook) {
            ItemAlchemicalBook book = (ItemAlchemicalBook)item;
            try {
                IAlchemicalBookLocationsProvider provider = CapabilityAlchemicalBookLocations.from(stack);
                IKnowledgeProvider knowledgeProvider = (IKnowledgeProvider)this.player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).orElseThrow(() -> new IllegalStateException("Player does not have knowledge capability"));
                BigInteger emc = knowledgeProvider.getEmc();
                CapabilityAlchemicalBookLocations.TeleportLocation location = provider.getLocationOrThrow(this.name);
                BigInteger cost = BigInteger.valueOf(location.getCost(stack, this.player));
                if (!cost.equals(BigInteger.ZERO)) {
                    if (emc.compareTo(cost) < 0) {
                        throw new CapabilityAlchemicalBookLocations.BookError.NotEnoughEMCError(cost.toString());
                    }
                    knowledgeProvider.setEmc(emc.subtract(cost));
                    knowledgeProvider.syncEmc((ServerPlayer)this.player);
                }
                GlobalPos pos = GlobalPos.m_122643_((ResourceKey)this.player.m_9236_().m_46472_(), (BlockPos)this.player.m_20183_());
                location.teleportTo((ServerPlayer)this.player, book.getTier().isAcrossDimensions());
                if (location.distanceFrom(pos.m_122646_()) > 1.0) {
                    provider.saveBackLocation(this.player, pos);
                }
            }
            catch (CapabilityAlchemicalBookLocations.BookError error) {
                this.player.m_213846_((Component)Lang.Items.ALCHEMICAL_BOOK_TELEPORT_FAILED.translateColored(ChatFormatting.RED, new Object[]{error.getComponent()}));
            }
            catch (IllegalStateException error) {
                this.player.m_213846_((Component)Lang.PROVIDER_ERROR.translateColored(ChatFormatting.RED, new Object[0]));
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.m_130077_(this.player.m_20148_());
        buf.m_130068_((Enum)this.hand);
    }

    public static PacketTeleportToDestination decode(FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        UUID uuid = buf.m_130259_();
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
        if (player == null) {
            throw new IllegalStateException("Player not found in PacketTeleportToDestination packet");
        }
        return new PacketTeleportToDestination(name, (Player)player, hand);
    }
}

