/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.net.packets.to_server;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.packets.IPacket;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PacketCreateTeleportDestination
implements IPacket {
    final String name;
    final Player player;
    final InteractionHand hand;

    public PacketCreateTeleportDestination(String name, Player player, InteractionHand hand) {
        this.name = name;
        this.player = player;
        this.hand = hand;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ItemStack stack = this.player.m_21120_(this.hand);
        if (stack.m_41720_() instanceof ItemAlchemicalBook) {
            try {
                IAlchemicalBookLocationsProvider provider = CapabilityAlchemicalBookLocations.from(stack);
                provider.ensureEditable((ServerPlayer)this.player);
                provider.addLocation(this.player, this.name);
                provider.sync((ServerPlayer)this.player);
                provider.syncToOtherPlayers();
            }
            catch (CapabilityAlchemicalBookLocations.BookError error) {
                this.player.m_213846_((Component)Lang.Items.ALCHEMICAL_BOOK_CREATE_FAILED.translateColored(ChatFormatting.RED, new Object[]{error.getComponent()}));
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.name);
        buf.m_130077_(this.player.m_20148_());
        buf.m_130068_((Enum)this.hand);
    }

    public static PacketCreateTeleportDestination decode(FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        UUID uuid = buf.m_130259_();
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
        if (player == null) {
            throw new IllegalStateException("Player not found in PacketCreateTeleportDestination packet");
        }
        return new PacketCreateTeleportDestination(name, (Player)player, hand);
    }
}

