/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.net.packets.to_client;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.net.packets.IPacket;
import cool.furry.mc.forge.projectexpansion.util.ClientSideHandler;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;

public record PacketSyncAlchemicalBookLocations(List<CapabilityAlchemicalBookLocations.TeleportLocation> locations, boolean canEdit) implements IPacket
{
    @Override
    public void handle(NetworkEvent.Context context) {
        ClientSideHandler.handleSyncAlchemicalBookLocations(this);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        PacketSyncAlchemicalBookLocations.writeLocationsToBuffer(buf, this.locations);
        buf.writeBoolean(this.canEdit);
    }

    public static PacketSyncAlchemicalBookLocations decode(FriendlyByteBuf buf) {
        return new PacketSyncAlchemicalBookLocations(PacketSyncAlchemicalBookLocations.readLocationsFromBuffer(buf), buf.readBoolean());
    }

    public static void writeLocationsToBuffer(FriendlyByteBuf buf, List<CapabilityAlchemicalBookLocations.TeleportLocation> locations) {
        buf.m_130130_(locations.size());
        locations.forEach(location -> buf.m_130079_(location.serialize()));
    }

    public static List<CapabilityAlchemicalBookLocations.TeleportLocation> readLocationsFromBuffer(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<CapabilityAlchemicalBookLocations.TeleportLocation> locations = new ArrayList<CapabilityAlchemicalBookLocations.TeleportLocation>();
        try {
            for (int i = 0; i < size; ++i) {
                CapabilityAlchemicalBookLocations.TeleportLocation location = CapabilityAlchemicalBookLocations.TeleportLocation.deserialize(Objects.requireNonNull(buf.m_130260_()));
                locations.add(location);
            }
            locations.sort(Comparator.comparingInt(CapabilityAlchemicalBookLocations.TeleportLocation::index));
        }
        catch (Exception e) {
            LogManager.getLogger(PacketSyncAlchemicalBookLocations.class).error("Failed to read locations from buffer", (Throwable)e);
            Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_213846_((Component)Lang.Items.ALCHEMICAL_BOOK_CORRUPTED.translateColored(ChatFormatting.RED, new Object[0]));
        }
        return locations;
    }
}

