/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.net;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.net.packets.IPacket;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketOpenAlchemicalBookGUI;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketSyncAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketUpdateWindowBigInteger;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketUpdateWindowInt;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketUpdateWindowLong;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketCreateTeleportDestination;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketDeleteTeleportDestination;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketTeleportBack;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketTeleportToDestination;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)Main.rl("primary")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    private static int index;

    public static void register() {
        PacketHandler.registerClientToServer(PacketCreateTeleportDestination.class, PacketCreateTeleportDestination::decode);
        PacketHandler.registerClientToServer(PacketDeleteTeleportDestination.class, PacketDeleteTeleportDestination::decode);
        PacketHandler.registerClientToServer(PacketTeleportBack.class, PacketTeleportBack::decode);
        PacketHandler.registerClientToServer(PacketTeleportToDestination.class, PacketTeleportToDestination::decode);
        PacketHandler.registerServerToClient(PacketOpenAlchemicalBookGUI.class, PacketOpenAlchemicalBookGUI::decode);
        PacketHandler.registerServerToClient(PacketSyncAlchemicalBookLocations.class, PacketSyncAlchemicalBookLocations::decode);
        PacketHandler.registerServerToClient(PacketUpdateWindowLong.class, PacketUpdateWindowLong::decode);
        PacketHandler.registerServerToClient(PacketUpdateWindowInt.class, PacketUpdateWindowInt::decode);
        PacketHandler.registerServerToClient(PacketUpdateWindowBigInteger.class, PacketUpdateWindowBigInteger::decode);
    }

    private static <MSG extends IPacket> void registerClientToServer(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder) {
        PacketHandler.registerMessage(type, decoder, NetworkDirection.PLAY_TO_SERVER);
    }

    private static <MSG extends IPacket> void registerServerToClient(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder) {
        PacketHandler.registerMessage(type, decoder, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <MSG extends IPacket> void registerMessage(Class<MSG> type, Function<FriendlyByteBuf, MSG> decoder, NetworkDirection networkDirection) {
        HANDLER.registerMessage(index++, type, IPacket::encode, decoder, IPacket::handle, Optional.of(networkDirection));
    }

    public static <MSG extends IPacket> void sendToServer(MSG msg) {
        HANDLER.sendToServer(msg);
    }

    public static <MSG extends IPacket> void sendTo(MSG msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            HANDLER.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

