/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.mixin;

import cool.furry.mc.forge.projectexpansion.registries.Enchantments;
import cool.furry.mc.forge.projectexpansion.util.AlchemicalCollectionCollector;
import cool.furry.mc.forge.projectexpansion.util.AtomicBigInteger;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public abstract class AlchemicalCollectionMixin {
    @Inject(at={@At(value="RETURN")}, method={"getDrops(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;"}, cancellable=true)
    private static void getDrops(BlockState state, ServerLevel level, BlockPos pos, BlockEntity blockEntity, Entity entity, ItemStack stack, CallbackInfoReturnable<List<ItemStack>> cir) {
        boolean hasEnch;
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        IKnowledgeProvider provider = Util.getKnowledgeProvider((Player)player);
        if (provider == null) {
            return;
        }
        IEMCProxy proxy = IEMCProxy.INSTANCE;
        boolean bl = hasEnch = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)Enchantments.ALCHEMICAL_COLLECTION.get()), (ItemStack)stack) > 0;
        if (!state.canHarvestBlock((BlockGetter)level, pos, (Player)player) || !hasEnch) {
            return;
        }
        boolean enabled = stack.m_41784_().m_128471_(TagNames.ALCHEMICAL_COLLECTION_ENABLED);
        if (!enabled) {
            return;
        }
        List initialDrops = (List)cir.getReturnValue();
        AtomicBigInteger addEMC = new AtomicBigInteger();
        ArrayList<ItemStack> knowledgeAdditions = new ArrayList<ItemStack>();
        List newDrops = initialDrops.stream().map(drop -> {
            if (proxy.hasValue(drop)) {
                addEMC.addAndGet(BigInteger.valueOf(proxy.getValue(drop)));
                if (!provider.hasKnowledge(drop) && !knowledgeAdditions.contains(drop)) {
                    knowledgeAdditions.add((ItemStack)drop);
                }
                return null;
            }
            return drop;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (newDrops.size() < initialDrops.size() || addEMC.get().compareTo(BigInteger.ZERO) > 0) {
            AlchemicalCollectionCollector.add(player.m_20148_(), addEMC.get(), knowledgeAdditions);
            cir.setReturnValue(newDrops);
        }
    }
}

