/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.util.Star;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.capability.EmcHolderItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.integration.IntegrationHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.NotNull;

public class ItemStar
extends ItemPE
implements IItemEmcHolder,
IBarHelper {
    public static final long[] STAR_EMC = new long[18];
    public final Star tier;
    public final Star.StarType type;

    public ItemStar(Star.StarType type, Star tier) {
        super(new Item.Properties().m_41487_(1).m_41497_(tier == Star.OMEGA ? Rarity.EPIC : (type == Star.StarType.COLOSSAL ? Rarity.UNCOMMON : (type == Star.StarType.GARGANTUAN ? Rarity.RARE : Rarity.COMMON))));
        this.type = type;
        this.tier = tier;
        this.addItemCapability(EmcHolderItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return stack.m_41782_();
    }

    public float getWidthForBar(ItemStack stack) {
        long starEmc = ItemStar.getEmc((ItemStack)stack);
        return starEmc == 0L ? 1.0f : (float)(1.0 - (double)starEmc / (double)this.getMaximumEmc(stack));
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return this.getColorForBar(stack);
    }

    public long insertEmc(@Nonnull ItemStack stack, long toInsert, IEmcStorage.EmcAction action) {
        if (toInsert < 0L) {
            return this.extractEmc(stack, -toInsert, action);
        }
        long toAdd = Math.min(this.getNeededEmc(stack), toInsert);
        if (action.execute()) {
            ItemStar.addEmcToStack((ItemStack)stack, (long)toAdd);
        }
        return toAdd;
    }

    public long extractEmc(@Nonnull ItemStack stack, long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.insertEmc(stack, -toExtract, action);
        }
        long storedEmc = this.getStoredEmc(stack);
        long toRemove = Math.min(storedEmc, toExtract);
        if (action.execute()) {
            ItemStar.setEmc((ItemStack)stack, (long)(storedEmc - toRemove));
        }
        return toRemove;
    }

    public long getStoredEmc(@Nonnull ItemStack stack) {
        return ItemStar.getEmc((ItemStack)stack);
    }

    public long getMaximumEmc(@Nonnull ItemStack stack) {
        return STAR_EMC[this.tier.ordinal() + this.type.getOffset()];
    }

    static {
        long emc = 204800000L;
        for (int i = 0; i < STAR_EMC.length; ++i) {
            ItemStar.STAR_EMC[i] = emc;
            emc *= 4L;
        }
    }
}

