/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityCollector;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityEMCLink;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityNBTFilterable;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityOwnable;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityPowerFlower;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityRelay;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMatterUpgrader
extends Item {
    public ItemMatterUpgrader() {
        super(new Item.Properties());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        list.add((Component)Lang.Items.MATTER_UPGRADER_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[0]));
        list.add((Component)Lang.Items.MATTER_UPGRADER_TOOLTIP2.translateColored(ChatFormatting.GREEN, new Object[0]));
        list.add((Component)Lang.Items.MATTER_UPGRADER_TOOLTIP_CREATIVE.translateColored(ChatFormatting.RED, new Object[0]));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BigInteger newEmc;
        BlockEntityOwnable intBlockEntity;
        BlockEntityOwnable be;
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (level.f_46443_ || player == null) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        Block block = level.m_8055_(pos).m_60734_();
        if (!(block instanceof IHasMatter)) {
            return InteractionResult.PASS;
        }
        Matter matter = ((IHasMatter)block).getMatter();
        Matter upgradeTo = matter.next();
        if (matter == Matter.FINAL) {
            player.m_5661_((Component)Lang.Items.MATTER_UPGRADER_MAX_UPGRADE.translateColored(ChatFormatting.RED, new Object[0]), true);
            return InteractionResult.FAIL;
        }
        IKnowledgeProvider provider = Util.getKnowledgeProvider(player);
        if (provider == null) {
            player.m_5661_((Component)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(ChatFormatting.RED, new Object[]{player.m_5446_()}), true);
            return InteractionResult.FAIL;
        }
        IEMCProxy proxy = IEMCProxy.INSTANCE;
        BlockItem upgrade = null;
        Block upgradeBlock = null;
        BlockEntityOwnable newBlockEntity = null;
        BlockState newBlockState = null;
        if (blockEntity instanceof BlockEntityCollector) {
            upgrade = Objects.requireNonNull(upgradeTo.getCollectorItem());
            upgradeBlock = (Block)Objects.requireNonNull(upgradeTo.getCollector());
        }
        if (blockEntity instanceof BlockEntityPowerFlower) {
            be = (BlockEntityPowerFlower)blockEntity;
            upgrade = Objects.requireNonNull(upgradeTo.getPowerFlowerItem());
            upgradeBlock = Objects.requireNonNull(upgradeTo.getPowerFlower());
            if (be.owner == null) {
                return InteractionResult.FAIL;
            }
            if (!be.owner.equals(player.m_20148_())) {
                player.m_5661_((Component)Lang.Items.MATTER_UPGRADER_NOT_OWNER.translateColored(ChatFormatting.RED, new Object[0]), true);
                return InteractionResult.FAIL;
            }
            newBlockState = upgradeBlock.m_49966_();
            intBlockEntity = new BlockEntityPowerFlower(pos, newBlockState);
            ((BlockEntityPowerFlower)intBlockEntity).owner = be.owner;
            ((BlockEntityPowerFlower)intBlockEntity).ownerName = be.ownerName;
            ((BlockEntityPowerFlower)intBlockEntity).emc = be.emc;
            ((BlockEntityPowerFlower)intBlockEntity).m_183515_(new CompoundTag());
            newBlockEntity = intBlockEntity;
        }
        if (blockEntity instanceof BlockEntityEMCLink) {
            be = (BlockEntityEMCLink)blockEntity;
            upgrade = Objects.requireNonNull(upgradeTo.getEMCLinkItem());
            upgradeBlock = Objects.requireNonNull(upgradeTo.getEMCLink());
            if (((BlockEntityEMCLink)be).owner == null) {
                return InteractionResult.FAIL;
            }
            if (!((BlockEntityEMCLink)be).owner.equals(player.m_20148_())) {
                player.m_5661_((Component)Lang.Items.MATTER_UPGRADER_NOT_OWNER.translateColored(ChatFormatting.RED, new Object[0]), true);
                return InteractionResult.FAIL;
            }
            newBlockState = (BlockState)upgradeBlock.m_49966_().m_61124_((Property)BlockEntityNBTFilterable.FILTER, (Comparable)((Boolean)be.m_58900_().m_61143_((Property)BlockEntityNBTFilterable.FILTER)));
            intBlockEntity = new BlockEntityEMCLink(pos, newBlockState);
            ((BlockEntityEMCLink)intBlockEntity).owner = ((BlockEntityEMCLink)be).owner;
            ((BlockEntityEMCLink)intBlockEntity).ownerName = ((BlockEntityEMCLink)be).ownerName;
            ((BlockEntityEMCLink)intBlockEntity).emc = ((BlockEntityEMCLink)be).emc;
            ((BlockEntityEMCLink)intBlockEntity).itemStack = ((BlockEntityEMCLink)be).itemStack;
            ((BlockEntityEMCLink)intBlockEntity).remainingEMC = ((BlockEntityEMCLink)be).remainingEMC;
            ((BlockEntityEMCLink)intBlockEntity).remainingImport = ((BlockEntityEMCLink)be).remainingImport;
            ((BlockEntityEMCLink)intBlockEntity).remainingExport = ((BlockEntityEMCLink)be).remainingExport;
            ((BlockEntityEMCLink)intBlockEntity).remainingFluid = ((BlockEntityEMCLink)be).remainingFluid;
            ((BlockEntityEMCLink)intBlockEntity).m_183515_(new CompoundTag());
            newBlockEntity = intBlockEntity;
        }
        if (blockEntity instanceof BlockEntityRelay) {
            upgrade = Objects.requireNonNull(upgradeTo.getRelayItem());
            upgradeBlock = Objects.requireNonNull(upgradeTo.getRelay());
        }
        if (!provider.hasKnowledge(new ItemStack((ItemLike)upgrade)) && !player.m_7500_()) {
            player.m_5661_((Component)Lang.Items.MATTER_UPGRADER_NOT_LEARNED.translateColored(ChatFormatting.RED, new Object[]{Component.m_237115_((String)Objects.requireNonNull(upgrade).toString())}), true);
            return InteractionResult.FAIL;
        }
        long prevValue = proxy.getValue(block);
        long emcValue = proxy.getValue((Item)Objects.requireNonNull(upgrade));
        long diff = emcValue - prevValue;
        if (player.m_7500_()) {
            diff = 0L;
        }
        if ((newEmc = provider.getEmc().subtract(BigInteger.valueOf(diff))).compareTo(BigInteger.ZERO) < 0) {
            player.m_5661_((Component)Lang.Items.MATTER_UPGRADER_NOT_ENOUGH_EMC.translateColored(ChatFormatting.RED, new Object[]{EMCFormat.format(BigInteger.valueOf(diff))}), true);
            return InteractionResult.FAIL;
        }
        if (newBlockState == null) {
            newBlockState = upgradeBlock.m_49966_();
        }
        level.m_7471_(pos, false);
        level.m_46597_(pos, newBlockState);
        if (newBlockEntity != null) {
            level.m_46747_(pos);
            level.m_151523_((BlockEntity)newBlockEntity);
            Util.markDirty(level, pos);
        }
        provider.setEmc(newEmc);
        player.m_5661_((Component)Lang.Items.MATTER_UPGRADER_DONE.translateColored(ChatFormatting.WHITE, new Object[]{EMCFormat.format(BigInteger.valueOf(diff))}), true);
        return InteractionResult.SUCCESS;
    }
}

