/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemInfiniteFuel
extends Item {
    public ItemInfiniteFuel() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        list.add((Component)Lang.Items.INFINITE_FUEL_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[0]));
        list.add((Component)Lang.COST.translateColored(ChatFormatting.RED, new Object[]{EMCFormat.getComponent(((Integer)Config.infiniteFuelCost.get()).intValue()).m_6270_(ColorStyle.GRAY)}));
    }

    public int getBurnTime(ItemStack stack, @Nullable RecipeType<?> recipeType) {
        IKnowledgeProvider provider;
        UUID owner = stack.m_41783_() == null ? null : stack.m_41783_().m_128342_(TagNames.OWNER);
        IKnowledgeProvider iKnowledgeProvider = provider = owner == null ? null : Util.getKnowledgeProvider(owner);
        if (owner == null || provider == null) {
            return 0;
        }
        return (Integer)Config.infiniteFuelCost.get() == 0 || (Integer)Config.infiniteFuelBurnTime.get() == 0 ? 0 : (provider.getEmc().compareTo(BigInteger.valueOf(((Integer)Config.infiniteFuelCost.get()).intValue())) < 0 ? 0 : (Integer)Config.infiniteFuelBurnTime.get());
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        UUID owner;
        UUID uUID = owner = stack.m_41783_() == null ? null : stack.m_41783_().m_128342_(TagNames.OWNER);
        if (owner == null) {
            return stack;
        }
        ServerPlayer player = Util.getPlayer(owner);
        IKnowledgeProvider provider = Util.getKnowledgeProvider(owner);
        if (provider == null) {
            return stack;
        }
        provider.setEmc(provider.getEmc().subtract(BigInteger.valueOf(((Integer)Config.infiniteFuelCost.get()).intValue())));
        if (player != null) {
            provider.syncEmc(player);
        }
        return stack;
    }
}

