/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.net.PacketHandler;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketOpenAlchemicalBookGUI;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.TagNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemAlchemicalBook
extends Item {
    private final Tier tier;

    public ItemAlchemicalBook(Tier tier) {
        super(new Item.Properties().m_41497_(tier.getRarity()).m_41487_(1).m_41486_());
        this.tier = tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        super.m_7373_(stack, level, list, flag);
        list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP.translateColored(ChatFormatting.GRAY, new Object[0]));
        switch (this.tier) {
            case BASIC: {
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_BASIC.translateColored(ChatFormatting.RED, new Object[]{1000}));
                break;
            }
            case ADVANCED: {
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_ADVANCED.translateColored(ChatFormatting.RED, new Object[]{500}));
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_BIND.translateColored(ChatFormatting.GREEN, new Object[0]));
                break;
            }
            case MASTER: {
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_MASTER.translateColored(ChatFormatting.RED, new Object[]{100}));
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_BIND.translateColored(ChatFormatting.GREEN, new Object[0]));
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_ACROSS_DIMENSIONS.translateColored(ChatFormatting.GREEN, new Object[0]));
                break;
            }
            case ARCANE: {
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_ARCANE.translateColored(ChatFormatting.RED, new Object[]{0}));
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_BIND.translateColored(ChatFormatting.GREEN, new Object[0]));
                list.add((Component)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_ACROSS_DIMENSIONS.translateColored(ChatFormatting.GREEN, new Object[0]));
            }
        }
        if (this.getMode(stack) == Mode.PLAYER) {
            ServerPlayer player = this.getPlayer(stack);
            list.add((Component)Lang.Items.ALCHEMICAL_BOOK_BOUND_TO.translateColored(ChatFormatting.RED, new Object[]{player == null ? Component.m_237113_((String)stack.m_41784_().m_128461_(TagNames.OWNER_NAME)).m_130940_(ChatFormatting.DARK_AQUA) : player.m_5446_().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)}));
        }
        list.add((Component)Lang.SEE_WIKI.translateColored(ChatFormatting.AQUA, new Object[0]));
    }

    @Nullable
    public ServerPlayer getPlayer(ItemStack stack) {
        ItemAlchemicalBook book;
        Item item = stack.m_41720_();
        if (item instanceof ItemAlchemicalBook && (book = (ItemAlchemicalBook)item).getMode(stack) == Mode.STACK) {
            return null;
        }
        return Util.getPlayer(stack.m_41784_().m_128342_(TagNames.OWNER));
    }

    public Mode getMode(ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128441_(TagNames.OWNER) ? Mode.PLAYER : Mode.STACK;
    }

    public Tier getTier() {
        return this.tier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            if (player.m_6047_() && this.getTier().canBindToPlayer()) {
                CompoundTag tag = stack.m_41784_();
                if (this.getMode(stack) == Mode.PLAYER) {
                    if (!tag.m_128342_(TagNames.OWNER).equals(player.m_20148_())) {
                        player.m_213846_((Component)Lang.NOT_OWNER.translateColored(ChatFormatting.RED, new Object[]{Component.m_237113_((String)tag.m_128461_(TagNames.OWNER_NAME)).m_130940_(ChatFormatting.DARK_AQUA)}));
                        return InteractionResultHolder.m_19100_((Object)stack);
                    }
                    tag.m_128473_(TagNames.OWNER);
                    tag.m_128473_(TagNames.OWNER_NAME);
                    player.m_213846_((Component)Lang.Items.ALCHEMICAL_BOOK_NO_LONGER_BOUND.translateColored(ChatFormatting.GREEN, new Object[]{tag.m_128461_(TagNames.OWNER_NAME)}));
                } else {
                    tag.m_128362_(TagNames.OWNER, player.m_20148_());
                    tag.m_128359_(TagNames.OWNER_NAME, player.m_7755_().getString());
                    player.m_213846_((Component)Lang.Items.ALCHEMICAL_BOOK_NOW_BOUND.translateColored(ChatFormatting.GREEN, new Object[]{tag.m_128461_(TagNames.OWNER_NAME)}));
                }
            } else {
                try {
                    PacketHandler.sendTo(new PacketOpenAlchemicalBookGUI(hand, (List<CapabilityAlchemicalBookLocations.TeleportLocation>)CapabilityAlchemicalBookLocations.from(stack).getLocations(), this.getMode(stack), ItemAlchemicalBook.canEdit(stack, (ServerPlayer)player)), (ServerPlayer)player);
                }
                catch (CapabilityAlchemicalBookLocations.BookError.OwnerOfflineError ignore) {
                    player.m_213846_((Component)Lang.Items.ALCHEMICAL_BOOK_OWNER_NOT_ONLINE.translateColored(ChatFormatting.RED, new Object[0]));
                    return InteractionResultHolder.m_19100_((Object)stack);
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static boolean canEdit(ItemStack stack, ServerPlayer player) {
        Item item = stack.m_41720_();
        if (!(item instanceof ItemAlchemicalBook)) {
            return false;
        }
        ItemAlchemicalBook book = (ItemAlchemicalBook)item;
        ServerPlayer owner = book.getPlayer(stack);
        if (owner == null) {
            return true;
        }
        return ItemAlchemicalBook.canEdit(player, owner);
    }

    public static boolean canEdit(ServerPlayer player, ServerPlayer owner) {
        Config.AlchemicalBookEditLevel editLevel = Config.editOthersAlchemicalBooks();
        if (editLevel == Config.AlchemicalBookEditLevel.ENABLED) {
            return true;
        }
        if (player.m_20310_(2) && editLevel == Config.AlchemicalBookEditLevel.OP_ONLY) {
            return true;
        }
        return owner.equals((Object)player);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41784_().m_128441_(TagNames.OWNER);
    }

    public static enum Tier {
        BASIC,
        ADVANCED,
        MASTER,
        ARCANE;


        public boolean isAcrossDimensions() {
            return this == MASTER || this == ARCANE;
        }

        public boolean canBindToPlayer() {
            return this == ADVANCED || this == MASTER || this == ARCANE;
        }

        public float distanceRatio() {
            switch (this) {
                case BASIC: {
                    return 1000.0f;
                }
                case ADVANCED: {
                    return 500.0f;
                }
                case MASTER: {
                    return 100.0f;
                }
                case ARCANE: {
                    return 0.0f;
                }
            }
            throw new IllegalStateException("Unexpected value: " + this);
        }

        public Rarity getRarity() {
            switch (this) {
                case BASIC: {
                    return Rarity.COMMON;
                }
                case ADVANCED: {
                    return Rarity.UNCOMMON;
                }
                case MASTER: {
                    return Rarity.RARE;
                }
                case ARCANE: {
                    return Rarity.EPIC;
                }
            }
            throw new IllegalStateException("Unexpected value: " + this);
        }
    }

    public static enum Mode {
        PLAYER,
        STACK;

    }
}

