/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.integrations;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityEMCLink;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityNBTFilterable;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityOwnable;
import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityRelay;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IGeneratesEMC;
import cool.furry.mc.forge.projectexpansion.util.IHasColor;
import cool.furry.mc.forge.projectexpansion.util.IHasSunBonus;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Common {
    public static void registerCommonTooltips(Consumer<Component> addTooltip, Block block, BlockEntity blockEntity) {
        Object gen;
        if (blockEntity instanceof IGeneratesEMC) {
            gen = (IGeneratesEMC)blockEntity;
            BigInteger total = gen.getStoredEmcBigInteger();
            BigInteger maximum = gen.getMaximumEmcBigInteger();
            addTooltip.accept((Component)Lang.EMC_STORAGE.translateColored(ChatFormatting.GRAY, new Object[]{Common.formatEMC(total), Common.formatEMC(maximum)}));
            BigInteger generated = gen.getGeneratedEMC();
            addTooltip.accept((Component)Lang.EMC_PER_SECOND.translateColored(ChatFormatting.GRAY, new Object[]{Common.formatEMC(generated)}));
        }
        if (blockEntity instanceof IHasSunBonus && (gen = (IHasSunBonus)blockEntity).hasSunBonus()) {
            int bonus = Objects.requireNonNull(gen.getSunBonus());
            addTooltip.accept((Component)Lang.SUN_BONUS.translateColored(ChatFormatting.GRAY, new Object[]{Component.m_237113_((String)String.valueOf(bonus)).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.YELLOW))}));
        }
        if (blockEntity instanceof BlockEntityEMCLink) {
            BlockEntityEMCLink link = (BlockEntityEMCLink)blockEntity;
            Matter matter = link.getMatter();
            BigInteger emcLimit = matter.getEMCLinkEMCLimit();
            int importExportLimit = matter.getEMCLinkItemLimit();
            int fluidLimit = matter.getEMCLinkFluidLimit();
            addTooltip.accept((Component)Lang.EMC_IMPORT_LIMIT.translateColored(ChatFormatting.GRAY, new Object[]{Common.formatEMC(link.remainingEMC), Common.formatEMC(emcLimit)}));
            addTooltip.accept((Component)Lang.ITEM_EXPORT_LIMIT.translateColored(ChatFormatting.GRAY, new Object[]{Common.formatEMC(BigInteger.valueOf(link.remainingExport)), Common.formatEMC(BigInteger.valueOf(importExportLimit))}));
            addTooltip.accept((Component)Lang.ITEM_IMPORT_LIMIT.translateColored(ChatFormatting.GRAY, new Object[]{Common.formatEMC(BigInteger.valueOf(link.remainingImport)), Common.formatEMC(BigInteger.valueOf(importExportLimit))}));
            addTooltip.accept((Component)Lang.FLUID_EXPORT_LIMIT.translateColored(ChatFormatting.GRAY, new Object[]{Common.formatEMC(BigInteger.valueOf(link.remainingFluid)), Common.formatEMC(BigInteger.valueOf(fluidLimit))}));
            addTooltip.accept((Component)Lang.FLUID_EXPORT_EFFICIENCY.translateColored(ChatFormatting.GRAY, new Object[]{Component.m_237113_((String)String.valueOf(matter.getFluidEfficiencyPercentage())).m_130940_(ChatFormatting.GREEN)}));
        }
        if (blockEntity instanceof BlockEntityNBTFilterable) {
            BlockEntityNBTFilterable filter = (BlockEntityNBTFilterable)blockEntity;
            addTooltip.accept((Component)Lang.FILTER_STATUS.translateColored(ChatFormatting.GRAY, new Object[]{filter.getFilterStatus() ? Lang.ENABLED.translateColored(ChatFormatting.GREEN, new Object[0]) : Lang.DISABLED.translateColored(ChatFormatting.RED, new Object[0])}));
        }
        if (blockEntity instanceof IHasColor) {
            IHasColor color = (IHasColor)blockEntity;
            addTooltip.accept((Component)Lang.COLOR.translateColored(ChatFormatting.GRAY, new Object[]{Component.m_237113_((String)Util.ucwords(color.getColor().toString())).m_130948_(Style.f_131099_.m_178520_(color.getColor().m_41071_()))}));
        }
        if (blockEntity instanceof BlockEntityRelay) {
            BlockEntityRelay relay = (BlockEntityRelay)blockEntity;
            BigInteger bonus = relay.getMatter().getRelayBonus();
            BigInteger transfer = relay.getMatter().getRelayTransfer();
            addTooltip.accept((Component)Lang.RELAY_BONUS.translateColored(ChatFormatting.GRAY, new Object[]{Common.formatEMC(bonus)}));
            addTooltip.accept((Component)Lang.EMC_TRANSFER_RATE.translateColored(ChatFormatting.GRAY, new Object[]{Common.formatEMC(transfer)}));
        }
        if (blockEntity instanceof BlockEntityOwnable) {
            BlockEntityOwnable ownable = (BlockEntityOwnable)blockEntity;
            boolean isOwner = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_20148_().equals(ownable.owner);
            String ownerName = ownable.ownerName;
            if (ownerName.isEmpty()) {
                ownerName = ownable.owner.toString();
            }
            addTooltip.accept((Component)Lang.OWNER.translateColored(ChatFormatting.GRAY, new Object[]{Component.m_237113_((String)ownerName).m_130940_(isOwner ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED)}));
        }
    }

    private static MutableComponent formatEMC(BigInteger value) {
        return EMCFormat.getComponent(value).m_130940_(ChatFormatting.GREEN);
    }
}

