/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.gui.container;

import cool.furry.mc.forge.projectexpansion.block.entity.BlockEntityCollector;
import cool.furry.mc.forge.projectexpansion.gui.container.ContainerBase;
import cool.furry.mc.forge.projectexpansion.registries.MenuTypes;
import java.util.Objects;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotGhost;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;

public abstract class ContainerCollector
extends ContainerBase {
    public BlockEntityCollector collector;
    public final DataSlot sunLevel = DataSlot.m_39401_();
    public final ContainerBase.BoxedBigInteger emc = new ContainerBase.BoxedBigInteger();
    private final DataSlot kleinChargeProgress = DataSlot.m_39401_();
    private final DataSlot fuelProgress = DataSlot.m_39401_();
    public final PEContainer.BoxedLong kleinEmc = new PEContainer.BoxedLong();

    public ContainerCollector(MenuType<?> type, int windowId, Inventory inv, BlockEntityCollector collector) {
        super(type, windowId, inv);
        this.bigIntegerFields.add(this.emc);
        this.m_38895_(this.sunLevel);
        this.m_38895_(this.kleinChargeProgress);
        this.m_38895_(this.fuelProgress);
        this.longFields.add(this.kleinEmc);
        this.collector = collector;
        switch (collector.getMatter()) {
            case BASIC: {
                this.initSlotsTier1();
                break;
            }
            case DARK: {
                this.initSlotsTier2();
                break;
            }
            default: {
                this.initSlotsTier3();
            }
        }
    }

    void initSlotsTier1() {
        IItemHandler aux = this.collector.getAux();
        IItemHandler main = this.collector.getInput();
        this.m_38897_((Slot)new ValidatedSlot(aux, 0, 124, 58, SlotPredicates.COLLECTOR_INV));
        int counter = 0;
        for (int i = 1; i >= 0; --i) {
            for (int j = 3; j >= 0; --j) {
                this.m_38897_((Slot)new ValidatedSlot(main, counter++, 20 + i * 18, 8 + j * 18, SlotPredicates.COLLECTOR_INV));
            }
        }
        this.m_38897_((Slot)new ValidatedSlot(aux, 1, 124, 13, SlotPredicates.ALWAYS_FALSE));
        this.m_38897_((Slot)new SlotGhost(aux, 2, 153, 36, SlotPredicates.COLLECTOR_LOCK));
        this.addPlayerInventory(8, 84);
    }

    void initSlotsTier2() {
        IItemHandler aux = this.collector.getAux();
        IItemHandler main = this.collector.getInput();
        this.m_38897_((Slot)new ValidatedSlot(aux, 0, 140, 58, SlotPredicates.COLLECTOR_INV));
        int counter = 0;
        for (int i = 2; i >= 0; --i) {
            for (int j = 3; j >= 0; --j) {
                this.m_38897_((Slot)new ValidatedSlot(main, counter++, 18 + i * 18, 8 + j * 18, SlotPredicates.COLLECTOR_INV));
            }
        }
        this.m_38897_((Slot)new ValidatedSlot(aux, 1, 140, 13, SlotPredicates.ALWAYS_FALSE));
        this.m_38897_((Slot)new SlotGhost(aux, 2, 169, 36, SlotPredicates.COLLECTOR_LOCK));
        this.addPlayerInventory(20, 84);
    }

    void initSlotsTier3() {
        IItemHandler aux = this.collector.getAux();
        IItemHandler main = this.collector.getInput();
        this.m_38897_((Slot)new ValidatedSlot(aux, 0, 158, 58, SlotPredicates.COLLECTOR_INV));
        int counter = 0;
        for (int i = 3; i >= 0; --i) {
            for (int j = 3; j >= 0; --j) {
                this.m_38897_((Slot)new ValidatedSlot(main, counter++, 18 + i * 18, 8 + j * 18, SlotPredicates.COLLECTOR_INV));
            }
        }
        this.m_38897_((Slot)new ValidatedSlot(aux, 1, 158, 13, SlotPredicates.ALWAYS_FALSE));
        this.m_38897_((Slot)new SlotGhost(aux, 2, 187, 36, SlotPredicates.COLLECTOR_LOCK));
        this.addPlayerInventory(30, 84);
    }

    public void m_150399_(int slotID, int button, ClickType flag, Player player) {
        Slot slot = this.tryGetSlot(slotID);
        if (slot instanceof SlotGhost && !slot.m_7993_().m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            super.m_150399_(slotID, button, flag, player);
        }
    }

    @Override
    protected void broadcastPX(boolean all) {
        this.emc.set(this.collector.getStoredEmcBigInteger());
        this.sunLevel.m_6422_(this.collector.getSunLevel());
        this.kleinChargeProgress.m_6422_((int)(this.collector.getItemChargeProportion() * 8000.0));
        this.fuelProgress.m_6422_((int)(this.collector.getFuelProgress() * 8000.0));
        this.kleinEmc.set(this.collector.getItemCharge());
        super.broadcastPX(all);
    }

    protected Block getValidBlock() {
        return (Block)Objects.requireNonNull(this.collector.getMatter().getCollector());
    }

    public boolean m_6875_(Player player) {
        return ContainerCollector.stillValid(player, this.collector, this::getValidBlock);
    }

    public double getKleinChargeProgress() {
        return (double)this.kleinChargeProgress.m_6501_() / 8000.0;
    }

    public double getFuelProgress() {
        return (double)this.fuelProgress.m_6501_() / 8000.0;
    }

    public static class Tier3
    extends ContainerCollector {
        public Tier3(int windowId, Inventory inv, BlockEntityCollector collector) {
            super((MenuType)MenuTypes.COLLECTOR_TIER_3.get(), windowId, inv, collector);
            this.initSlotsTier3();
        }
    }

    public static class Tier2
    extends ContainerCollector {
        public Tier2(int windowId, Inventory inv, BlockEntityCollector collector) {
            super((MenuType)MenuTypes.COLLECTOR_TIER_2.get(), windowId, inv, collector);
            this.initSlotsTier2();
        }
    }

    public static class Tier1
    extends ContainerCollector {
        public Tier1(int windowId, Inventory inv, BlockEntityCollector collector) {
            super((MenuType)MenuTypes.COLLECTOR_TIER_1.get(), windowId, inv, collector);
            this.initSlotsTier1();
        }
    }
}

